/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.looks;

import com.jgoodies.looks.Options;
import com.jgoodies.looks.plastic.PlasticLookAndFeel;
import com.jgoodies.looks.plastic.PlasticTheme;
import java.awt.Color;
import java.awt.Component;
import java.awt.Insets;
import java.awt.Toolkit;
import java.util.Collections;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.plaf.InsetsUIResource;
import javax.swing.plaf.UIResource;

public final class LookUtils {
    private static final String JAVA_VERSION = LookUtils.getSystemProperty("java.version");
    private static final String OS_NAME = LookUtils.getSystemProperty("os.name");
    private static final String OS_VERSION = LookUtils.getSystemProperty("os.version");
    public static final boolean IS_JAVA_1_4 = LookUtils.startsWith(JAVA_VERSION, "1.4");
    static final boolean IS_JAVA_1_4_0 = LookUtils.startsWith(JAVA_VERSION, "1.4.0");
    public static final boolean IS_JAVA_1_4_2_OR_LATER = !LookUtils.startsWith(JAVA_VERSION, "1.4.0") && !LookUtils.startsWith(JAVA_VERSION, "1.4.1");
    public static final boolean IS_JAVA_5 = LookUtils.startsWith(JAVA_VERSION, "1.5");
    public static final boolean IS_JAVA_5_OR_LATER = !IS_JAVA_1_4;
    public static final boolean IS_JAVA_6 = LookUtils.startsWith(JAVA_VERSION, "1.6");
    public static final boolean IS_JAVA_6_OR_LATER = !IS_JAVA_1_4 && !IS_JAVA_5;
    public static final boolean IS_OS_FREEBSD = LookUtils.startsWithIgnoreCase(OS_NAME, "FreeBSD");
    public static final boolean IS_OS_LINUX = LookUtils.startsWithIgnoreCase(OS_NAME, "Linux");
    public static final boolean IS_OS_OS2 = LookUtils.startsWith(OS_NAME, "OS/2");
    public static final boolean IS_OS_MAC = LookUtils.startsWith(OS_NAME, "Mac");
    public static final boolean IS_OS_WINDOWS = LookUtils.startsWith(OS_NAME, "Windows");
    public static final boolean IS_OS_WINDOWS_MODERN = LookUtils.startsWith(OS_NAME, "Windows") && !LookUtils.startsWith(OS_VERSION, "4.0");
    public static final boolean IS_OS_WINDOWS_XP = LookUtils.startsWith(OS_NAME, "Windows") && LookUtils.startsWith(OS_VERSION, "5.1");
    public static final boolean IS_OS_SOLARIS = LookUtils.startsWith(OS_NAME, "Solaris");
    public static final boolean IS_LAF_WINDOWS_XP_ENABLED = LookUtils.isWindowsXPLafEnabled();
    public static final boolean IS_LOW_RESOLUTION = LookUtils.isLowResolution();
    private static boolean loggingEnabled = true;

    private LookUtils() {
    }

    public static String getSystemProperty(String key) {
        try {
            return System.getProperty(key);
        }
        catch (SecurityException e) {
            LookUtils.log("Can't read the System property " + key + ".");
            return null;
        }
    }

    public static String getSystemProperty(String key, String defaultValue) {
        try {
            return System.getProperty(key, defaultValue);
        }
        catch (SecurityException e) {
            LookUtils.log("Can't read the System property " + key + ".");
            return defaultValue;
        }
    }

    public static Boolean getBooleanSystemProperty(String key, String logMessage) {
        String value = LookUtils.getSystemProperty(key, "");
        Boolean result = value.equalsIgnoreCase("false") ? Boolean.FALSE : (value.equalsIgnoreCase("true") ? Boolean.TRUE : null);
        if (result != null) {
            LookUtils.log(logMessage + " have been " + (result != false ? "en" : "dis") + "abled in the system properties.");
        }
        return result;
    }

    private static boolean isWindowsXPLafEnabled() {
        return IS_OS_WINDOWS_XP && IS_JAVA_1_4_2_OR_LATER && Boolean.TRUE.equals(Toolkit.getDefaultToolkit().getDesktopProperty("win.xpstyle.themeActive")) && LookUtils.getSystemProperty("swing.noxp") == null;
    }

    public static boolean isTrueColor(Component c) {
        return c.getToolkit().getColorModel().getPixelSize() >= 24;
    }

    public static boolean getToolkitUsesNativeDropShadows() {
        return IS_OS_MAC;
    }

    public static void installNarrowMargin(AbstractButton b, String propertyPrefix) {
        Object value = b.getClientProperty("jgoodies.isNarrow");
        boolean isNarrow = Boolean.TRUE.equals(value);
        String defaultsKey = propertyPrefix + (isNarrow ? "narrowMargin" : "margin");
        Insets insets = b.getMargin();
        if (insets == null || insets instanceof UIResource) {
            b.setMargin(UIManager.getInsets(defaultsKey));
        }
    }

    public static Insets createButtonMargin(boolean narrow) {
        int pad = narrow || Options.getUseNarrowButtons() ? 4 : 14;
        return IS_LOW_RESOLUTION ? new InsetsUIResource(2, pad, 1, pad) : new InsetsUIResource(3, pad, 3, pad);
    }

    public static Color getSlightlyBrighter(Color color) {
        return LookUtils.getSlightlyBrighter(color, 1.1f);
    }

    public static Color getSlightlyBrighter(Color color, float factor) {
        float[] hsbValues = new float[3];
        Color.RGBtoHSB(color.getRed(), color.getGreen(), color.getBlue(), hsbValues);
        float hue = hsbValues[0];
        float saturation = hsbValues[1];
        float brightness = hsbValues[2];
        float newBrightness = Math.min(brightness * factor, 1.0f);
        return Color.getHSBColor(hue, saturation, newBrightness);
    }

    public static void setLookAndTheme(LookAndFeel laf, Object theme) throws UnsupportedLookAndFeelException {
        if (laf instanceof PlasticLookAndFeel && theme != null && theme instanceof PlasticTheme) {
            PlasticLookAndFeel.setMyCurrentTheme((PlasticTheme)theme);
        }
        UIManager.setLookAndFeel(laf);
    }

    public static Object getDefaultTheme(LookAndFeel laf) {
        return laf instanceof PlasticLookAndFeel ? PlasticLookAndFeel.createMyDefaultTheme() : null;
    }

    public static List getInstalledThemes(LookAndFeel laf) {
        return laf instanceof PlasticLookAndFeel ? PlasticLookAndFeel.getInstalledThemes() : Collections.EMPTY_LIST;
    }

    public static void setLoggingEnabled(boolean enabled) {
        loggingEnabled = enabled;
    }

    public static void log() {
        if (loggingEnabled) {
            System.out.println();
        }
    }

    public static void log(String message) {
        if (loggingEnabled) {
            System.out.println("JGoodies Looks: " + message);
        }
    }

    private static boolean isLowResolution() {
        return Toolkit.getDefaultToolkit().getScreenResolution() < 120;
    }

    private static boolean startsWith(String str, String prefix) {
        return str != null && str.startsWith(prefix);
    }

    private static boolean startsWithIgnoreCase(String str, String prefix) {
        return str != null && str.toUpperCase().startsWith(prefix.toUpperCase());
    }
}

