/*
 * Decompiled with CFR 0.152.
 */
package de.chrmoll.jGPSpeedEvaluator;

import de.chrmoll.jGPSpeedEvaluator.gui.GPSpeedPanel;
import de.chrmoll.jGPSpeedEvaluator.utils.Icons;
import de.chrmoll.jGPSpeedEvaluator.utils.Parsers.GPXParser;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Locale;
import java.util.Properties;
import java.util.Vector;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JSeparator;
import javax.swing.filechooser.FileFilter;
import lu.tudor.santec.i18n.Translatrix;
import net.iharder.dnd.FileDrop;

public class JGPSpeedEvaluator {
    public static final String VERSION = "v0.4.1";
    private JFrame mainframe;
    private Dimension preferredSize = new Dimension(800, 480);
    public static File SETTINGS_FILE = new File(System.getProperty("user.dir"), "JGPSPeedEvaluator.properties");
    public Properties settings = new Properties();
    private GPSpeedPanel speedPanel;
    private GPXParser gpx;
    private File fileToOpen = new File("");
    private Locale locale;

    public static void main(String[] args) {
        System.out.println(System.getProperty("user.dir"));
        JGPSpeedEvaluator speedEvaluator = new JGPSpeedEvaluator();
        speedEvaluator.mainframe.setVisible(true);
    }

    public JGPSpeedEvaluator() {
        this.loadSettings();
        this.loadTranslation();
        Runtime.getRuntime().addShutdownHook(new Thread(){

            public void run() {
                JGPSpeedEvaluator.this.saveSettings();
            }
        });
        this.speedPanel = new GPSpeedPanel(this);
        new FileDrop((Component)this.speedPanel, new FileDrop.Listener(){

            public void filesDropped(File[] files) {
                if (files.length > 0 && files[0].getName().toLowerCase().endsWith(".gpx")) {
                    JGPSpeedEvaluator.this.loadGPXFile(files[0]);
                }
            }
        });
        this.mainframe = new JFrame(String.valueOf(Translatrix.getTranslationString((String)"title")) + " " + VERSION);
        this.mainframe.setPreferredSize(this.preferredSize);
        this.buildMenu();
        this.mainframe.setSize(800, 480);
        this.mainframe.add(this.speedPanel);
        this.mainframe.setIconImage(Icons.getImage("JGPSpeedEvaluator.png", 16));
        this.mainframe.pack();
        this.mainframe.setDefaultCloseOperation(3);
    }

    private void buildMenu() {
        JMenu file = new JMenu(Translatrix.getTranslationString((String)"file"));
        file.setMnemonic(Translatrix.getTranslationString((String)"file.key").charAt(0));
        JMenuItem openItem = new JMenuItem(Translatrix.getTranslationString((String)"file.open"));
        openItem.setMnemonic(Translatrix.getTranslationString((String)"file.open.key").charAt(0));
        openItem.setIcon(Icons.getIcon22("3floppy_unmount.png"));
        file.add(openItem);
        file.add(new JSeparator());
        JMenuItem exitItem = new JMenuItem(Translatrix.getTranslationString((String)"file.exit"));
        exitItem.setMnemonic(Translatrix.getTranslationString((String)"file.exit.key").charAt(0));
        exitItem.setIcon(Icons.getIcon22("exit.png"));
        file.add(exitItem);
        JMenu setup = new JMenu(Translatrix.getTranslationString((String)"settings"));
        setup.setMnemonic(Translatrix.getTranslationString((String)"settings.key").charAt(0));
        JMenu langSubMenu = new JMenu(Translatrix.getTranslationString((String)"settings.language"));
        langSubMenu.setMnemonic(Translatrix.getTranslationString((String)"settings.language.key").charAt(0));
        langSubMenu.setIcon(Icons.getIcon22("babelfish.png"));
        setup.add(langSubMenu);
        JMenuItem langEngItem = new JMenuItem(Translatrix.getTranslationString((String)"settings.language.english"));
        langEngItem.setMnemonic(Translatrix.getTranslationString((String)"settings.language.english.key").charAt(0));
        langEngItem.setIcon(Icons.getIcon22("english.png"));
        langSubMenu.add(langEngItem);
        JMenuItem langDeuItem = new JMenuItem(Translatrix.getTranslationString((String)"settings.language.german"));
        langDeuItem.setMnemonic(Translatrix.getTranslationString((String)"settings.language.german.key").charAt(0));
        langDeuItem.setIcon(Icons.getIcon22("german.png"));
        langSubMenu.add(langDeuItem);
        JMenuItem langFreItem = new JMenuItem(Translatrix.getTranslationString((String)"settings.language.french"));
        langFreItem.setMnemonic(Translatrix.getTranslationString((String)"settings.language.french.key").charAt(0));
        langFreItem.setIcon(Icons.getIcon22("french.png"));
        JMenu info = new JMenu(Translatrix.getTranslationString((String)"info"));
        info.setMnemonic(Translatrix.getTranslationString((String)"info.key").charAt(0));
        JMenuItem aboutItem = new JMenuItem(Translatrix.getTranslationString((String)"info.about"));
        aboutItem.setMnemonic(Translatrix.getTranslationString((String)"info.about.key").charAt(0));
        aboutItem.setIcon(Icons.getIcon22("error.png"));
        info.add(aboutItem);
        openItem.addActionListener(new ActionListener(){
            private JFileChooser chooser;
            private Component parent;

            public void actionPerformed(ActionEvent e) {
                FileFilter gpxFileFilter = new FileFilter(){

                    public boolean accept(File f) {
                        if (f.isDirectory()) {
                            return true;
                        }
                        return f.getName().toLowerCase().endsWith(".gpx");
                    }

                    public String getDescription() {
                        return Translatrix.getTranslationString((String)"gpxfile");
                    }
                };
                this.chooser = new JFileChooser(JGPSpeedEvaluator.this.fileToOpen);
                this.chooser.addChoosableFileFilter(gpxFileFilter);
                this.chooser.setDialogType(0);
                this.chooser.setMultiSelectionEnabled(false);
                int returnVal = this.chooser.showOpenDialog(this.parent);
                if (returnVal == 0) {
                    JGPSpeedEvaluator.this.fileToOpen = this.chooser.getSelectedFile();
                    JGPSpeedEvaluator.this.loadGPXFile(JGPSpeedEvaluator.this.fileToOpen);
                }
            }
        });
        exitItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                System.exit(0);
            }
        });
        langDeuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (!JGPSpeedEvaluator.this.locale.equals(Locale.GERMANY)) {
                    JGPSpeedEvaluator.this.locale = Locale.GERMANY;
                    if (JGPSpeedEvaluator.this.restart()) {
                        System.exit(0);
                    }
                }
            }
        });
        langEngItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (!JGPSpeedEvaluator.this.locale.equals(Locale.US)) {
                    JGPSpeedEvaluator.this.locale = Locale.US;
                    if (JGPSpeedEvaluator.this.restart()) {
                        System.exit(0);
                    }
                }
            }
        });
        langFreItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (!JGPSpeedEvaluator.this.locale.equals(Locale.FRANCE)) {
                    JGPSpeedEvaluator.this.locale = Locale.FRANCE;
                    if (JGPSpeedEvaluator.this.restart()) {
                        System.exit(0);
                    }
                }
            }
        });
        aboutItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                JLabel icon = new JLabel(Icons.getIcon("JGPSpeedEvaluator.png", 128));
                JLabel title = new JLabel("<HTML><H2>JGPSpeedEvaluator v0.4.1</H2></HTML>");
                title.setHorizontalAlignment(0);
                JLabel main = new JLabel(Translatrix.getTranslationString((String)"about.message"));
                main.setHorizontalAlignment(0);
                JDialog about = new JDialog(JGPSpeedEvaluator.this.mainframe);
                about.add((Component)title, "North");
                about.add((Component)icon, "West");
                about.add((Component)main, "Center");
                about.setSize(new Dimension(480, 240));
                about.setLocationRelativeTo(JGPSpeedEvaluator.this.mainframe);
                about.setVisible(true);
            }
        });
        JMenuBar bar = new JMenuBar();
        this.mainframe.setJMenuBar(bar);
        bar.add(file);
        bar.add(setup);
        bar.add(info);
    }

    protected void loadGPXFile(File fileToOpen) {
        try {
            this.gpx = new GPXParser(fileToOpen.getCanonicalPath());
            this.speedPanel.getTrksSelector().updateTrkSelector(this.gpx.getTrks());
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
    }

    private void saveSettings() {
        try {
            this.settings.put("working.dir", this.fileToOpen.getPath());
            this.settings.put("language", this.locale.getLanguage());
            this.settings.put("country", this.locale.getCountry());
            this.speedPanel.getSelectorPanel().saveSettings(this.settings);
            this.settings.store(new FileOutputStream(SETTINGS_FILE), "");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void loadSettings() {
        try {
            this.settings.load(new FileInputStream(SETTINGS_FILE));
            try {
                this.setPath(this.settings.getProperty("working.dir"));
                this.setLocale(this.settings.getProperty("language"), this.settings.getProperty("country"));
            }
            catch (Exception exception) {}
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void setLocale(String language, String country) {
        this.locale = new Locale(language, country);
        System.out.println(String.valueOf(language) + "_" + country);
        System.out.println(this.locale.getCountry());
    }

    private void setPath(String path) {
        this.fileToOpen = new File(path);
    }

    private void loadTranslation() {
        Translatrix.loadSupportedLocales((String)"de.chrmoll.jGPSpeedEvaluator.resources.supportedLocales");
        Translatrix.setLocale((Locale)Translatrix.getDefaultLocale());
        Vector locales = Translatrix.getSupportedLocales();
        if (locales.contains(this.locale)) {
            Translatrix.setLocale((Locale)this.locale);
            System.out.println("set locale: " + Locale.getDefault());
        } else {
            this.locale = Translatrix.getLocale();
        }
        Translatrix.addBundle((String)"de.chrmoll.jGPSpeedEvaluator.resources.translatrix");
    }

    private boolean restart() {
        int response = JOptionPane.showConfirmDialog(this.mainframe, Translatrix.getTranslationString((String)"restart.dialog"), Translatrix.getTranslationString((String)"restart.title"), 0);
        return response == 0;
    }

    public static void benchmark(long startTime, String message) {
        long computingTime = System.currentTimeMillis() - startTime;
        int minutes = (int)computingTime / 60000;
        int seconds = (int)(computingTime - (long)(minutes * 60));
        System.out.println("---" + message + "---");
        System.out.println(String.valueOf(computingTime) + "ms: total: processing time " + minutes + " minutes, " + seconds + " seconds");
        System.out.println("-------------------------------------");
    }
}

