/*
 * Decompiled with CFR 0.152.
 */
package de.chrmoll.jGPSpeedEvaluator.gui;

import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import de.chrmoll.jGPSpeedEvaluator.JGPSpeedEvaluator;
import de.chrmoll.jGPSpeedEvaluator.gui.SelectorPanel;
import de.chrmoll.jGPSpeedEvaluator.gui.TachoChartPanel;
import de.chrmoll.jGPSpeedEvaluator.gui.TimeSeriesPanel;
import de.chrmoll.jGPSpeedEvaluator.utils.TrackPoint;
import java.awt.Component;
import java.awt.LayoutManager;
import java.util.Vector;
import javax.swing.JPanel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GPSpeedPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private TachoChartPanel maxtacho;
    private TimeSeriesPanel speedchart;
    private SelectorPanel selector;
    private JGPSpeedEvaluator evaluator;

    public GPSpeedPanel(JGPSpeedEvaluator parent) {
        this.evaluator = parent;
        this.initComponent();
        this.buildPanel();
    }

    private void buildPanel() {
        CellConstraints cc = new CellConstraints();
        String panelColumns = "3dlu,300dlu ,3dlu,120dlu,3dlu";
        String panelRows = "3dlu,100dlu,3dlu,fill:pref:grow,3dlu,pref,3dlu";
        FormLayout panelLayout = new FormLayout(panelColumns, panelRows);
        this.setLayout((LayoutManager)panelLayout);
        this.add((Component)this.speedchart, cc.xywh(2, 2, 1, 3));
        this.add((Component)this.maxtacho, cc.xy(4, 2));
        this.add((Component)this.selector, cc.xy(4, 4));
    }

    private void initComponent() {
        this.maxtacho = new TachoChartPanel(0);
        this.speedchart = new TimeSeriesPanel(this);
        this.selector = new SelectorPanel(this);
    }

    public SelectorPanel getTrksSelector() {
        return this.selector;
    }

    public void updateGraph(Vector<TrackPoint> trkpts, boolean plotHeight) {
        this.speedchart.updateGraph(trkpts, plotHeight);
    }

    public void updateTacho(double maxSpeed) {
        this.maxtacho.setValue(maxSpeed);
    }

    public void updateDistance(double distance) {
        this.selector.updateDistance(distance);
    }

    public SelectorPanel getSelectorPanel() {
        return this.selector;
    }

    public JGPSpeedEvaluator getFramework() {
        return this.evaluator;
    }

    public void updateHeight(double minHeight, double maxHeight) {
        this.selector.updateHeight(minHeight, maxHeight);
    }

    public void updateSpeed(double speed) {
        this.selector.updateSpeed(speed);
    }
}

