/*
 * Decompiled with CFR 0.152.
 */
package de.chrmoll.jGPSpeedEvaluator.gui;

import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import de.chrmoll.jGPSpeedEvaluator.gui.GPSpeedPanel;
import de.chrmoll.jGPSpeedEvaluator.utils.TrackPoint;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.text.NumberFormat;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Properties;
import java.util.Set;
import java.util.Vector;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import lu.tudor.santec.i18n.Translatrix;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SelectorPanel
extends JPanel
implements ItemListener,
ActionListener {
    private static final long serialVersionUID = 1L;
    private GPSpeedPanel parent;
    private JComboBox trkSelector;
    private DefaultComboBoxModel trksModel = new DefaultComboBoxModel();
    private JCheckBox plotHeight;
    private LinkedHashMap<String, Vector<TrackPoint>> trks;
    private boolean isPlotHeight;
    private JLabel distanceLabel;
    private NumberFormat nf;
    private JLabel maxSpeedLabel;
    private JLabel minHeightLabel;
    private JLabel maxHeightLabel;
    private JLabel absHeightLabel;
    private NumberFormat shortFormat;

    public SelectorPanel(GPSpeedPanel parent) {
        this.parent = parent;
        this.initComponent();
        this.buildPanel();
        this.nf = NumberFormat.getInstance();
        this.nf.setMaximumFractionDigits(3);
        this.nf.setMinimumFractionDigits(3);
        this.shortFormat = NumberFormat.getInstance();
        this.shortFormat.setMaximumFractionDigits(1);
        this.shortFormat.setMinimumFractionDigits(1);
    }

    private void buildPanel() {
        CellConstraints cc = new CellConstraints();
        String panelColumns = "pref";
        String panelRows = "pref,3dlu,pref,3dlu,pref,3dlu,pref,3dlu,pref,3dlu,pref,3dlu,pref";
        FormLayout panelLayout = new FormLayout(panelColumns, panelRows);
        this.setLayout((LayoutManager)panelLayout);
        this.add((Component)this.distanceLabel, cc.xy(1, 1));
        this.add((Component)this.maxSpeedLabel, cc.xy(1, 3));
        this.add((Component)this.maxHeightLabel, cc.xy(1, 5));
        this.add((Component)this.minHeightLabel, cc.xy(1, 7));
        this.add((Component)this.absHeightLabel, cc.xy(1, 9));
        this.add((Component)this.trkSelector, cc.xy(1, 11));
        this.add((Component)this.plotHeight, cc.xy(1, 13));
    }

    private void initComponent() {
        this.trkSelector = new JComboBox(this.trksModel);
        this.trksModel.addElement(Translatrix.getTranslationString((String)"selector.emptymessage"));
        this.trkSelector.addItemListener(this);
        this.isPlotHeight = Boolean.parseBoolean((String)this.parent.getFramework().settings.get("height.selected"));
        this.plotHeight = new JCheckBox(Translatrix.getTranslationString((String)"selector.heightcheckbox"));
        this.plotHeight.addActionListener(this);
        this.plotHeight.setSelected(this.isPlotHeight);
        this.distanceLabel = new JLabel(Translatrix.getTranslationString((String)"selector.distance.default"));
        this.maxSpeedLabel = new JLabel(Translatrix.getTranslationString((String)"selector.maxSpeed.default"));
        this.minHeightLabel = new JLabel(Translatrix.getTranslationString((String)"selector.minHeight.default"));
        this.maxHeightLabel = new JLabel(Translatrix.getTranslationString((String)"selector.maxHeight.default"));
        this.absHeightLabel = new JLabel(Translatrix.getTranslationString((String)"selector.absHeight.default"));
    }

    public void updateTrkSelector(LinkedHashMap<String, Vector<TrackPoint>> trks) {
        this.trks = trks;
        Set<String> keys = trks.keySet();
        this.trksModel.removeAllElements();
        Iterator<String> iter = keys.iterator();
        while (iter.hasNext()) {
            this.trksModel.addElement(iter.next());
        }
    }

    @Override
    public void itemStateChanged(ItemEvent arg0) {
        if (arg0.getStateChange() == 1) {
            this.parent.updateGraph(this.trks.get(this.trksModel.getSelectedItem()), this.plotHeight.isSelected());
        }
    }

    @Override
    public void actionPerformed(ActionEvent arg0) {
        try {
            this.parent.updateGraph(this.trks.get(this.trksModel.getSelectedItem()), this.plotHeight.isSelected());
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void saveSettings(Properties settings) {
        settings.put("height.selected", String.valueOf(this.plotHeight.isSelected()));
    }

    public void updateDistance(double distance) {
        if (distance > 9999.0) {
            this.distanceLabel.setText(String.valueOf(Translatrix.getTranslationString((String)"selector.distance.default")) + " " + this.nf.format(distance / 1000.0) + Translatrix.getTranslationString((String)"selector.distance.kilometer"));
        } else {
            this.distanceLabel.setText(String.valueOf(Translatrix.getTranslationString((String)"selector.distance.default")) + " " + this.nf.format(distance) + Translatrix.getTranslationString((String)"selector.distance.meter"));
        }
    }

    public void updateSpeed(double speed) {
        this.maxSpeedLabel.setText(String.valueOf(Translatrix.getTranslationString((String)"selector.maxSpeed.default")) + " " + this.shortFormat.format(speed) + Translatrix.getTranslationString((String)"selector.speed.kmh"));
    }

    public void updateHeight(double minHeight, double maxHeight) {
        this.minHeightLabel.setText(String.valueOf(Translatrix.getTranslationString((String)"selector.minHeight.default")) + " " + this.shortFormat.format(minHeight) + Translatrix.getTranslationString((String)"selector.distance.meter"));
        this.maxHeightLabel.setText(String.valueOf(Translatrix.getTranslationString((String)"selector.maxHeight.default")) + " " + this.shortFormat.format(maxHeight) + Translatrix.getTranslationString((String)"selector.distance.meter"));
        this.absHeightLabel.setText(String.valueOf(Translatrix.getTranslationString((String)"selector.absHeight.default")) + " " + this.shortFormat.format(maxHeight - minHeight) + Translatrix.getTranslationString((String)"selector.distance.meter"));
    }
}

