/*
 * Decompiled with CFR 0.152.
 */
package de.chrmoll.jGPSpeedEvaluator.gui;

import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import de.chrmoll.jGPSpeedEvaluator.utils.JGPSpeedEvaluatorColor;
import java.awt.BasicStroke;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.Paint;
import java.awt.Stroke;
import javax.swing.JPanel;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.plot.DialShape;
import org.jfree.chart.plot.MeterInterval;
import org.jfree.chart.plot.MeterPlot;
import org.jfree.chart.plot.Plot;
import org.jfree.data.Range;
import org.jfree.data.general.DatasetChangeListener;
import org.jfree.data.general.DatasetGroup;
import org.jfree.data.general.ValueDataset;

public class TachoChartPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private JFreeChart chart;
    private MeterPlot meterPlot;
    private ValueDataset data;
    private MeterInterval good = new MeterInterval("good", new Range(90.0, 150.0), (Paint)JGPSpeedEvaluatorColor.lightGray, (Stroke)new BasicStroke(2.0f), JGPSpeedEvaluatorColor.GOOD);
    private MeterInterval attention = new MeterInterval("good", new Range(60.0, 90.0), (Paint)JGPSpeedEvaluatorColor.lightGray, (Stroke)new BasicStroke(2.0f), JGPSpeedEvaluatorColor.ATTENTION);
    private MeterInterval stop = new MeterInterval("good", new Range(30.0, 60.0), (Paint)JGPSpeedEvaluatorColor.lightGray, (Stroke)new BasicStroke(2.0f), JGPSpeedEvaluatorColor.STOP);
    private double value;

    public TachoChartPanel(int value) {
        this.value = value;
        this.buildChart();
    }

    private void buildChart() {
        this.data = new ValueDataset(){

            public Number getValue() {
                return TachoChartPanel.this.value;
            }

            public void addChangeListener(DatasetChangeListener arg0) {
            }

            public DatasetGroup getGroup() {
                return null;
            }

            public void removeChangeListener(DatasetChangeListener arg0) {
            }

            public void setGroup(DatasetGroup arg0) {
            }
        };
        this.meterPlot = new MeterPlot(this.data);
        this.meterPlot.setRange(new Range(0.0, 150.0));
        this.meterPlot.setDialShape(DialShape.PIE);
        this.meterPlot.setMeterAngle(260);
        this.meterPlot.setDialBackgroundPaint((Paint)JGPSpeedEvaluatorColor.white);
        this.meterPlot.setBackgroundAlpha(0.3f);
        this.meterPlot.addInterval(this.stop);
        this.meterPlot.addInterval(this.attention);
        this.meterPlot.addInterval(this.good);
        this.meterPlot.setNeedlePaint((Paint)JGPSpeedEvaluatorColor.darkGray);
        this.meterPlot.setTickSize(10.0);
        this.meterPlot.setTickPaint((Paint)JGPSpeedEvaluatorColor.darkGray);
        this.meterPlot.setValuePaint((Paint)JGPSpeedEvaluatorColor.darkGray);
        this.meterPlot.setUnits("km/h");
        this.chart = new JFreeChart((Plot)this.meterPlot);
        this.chart.removeLegend();
        ChartPanel chartpanel = new ChartPanel(this.chart);
        chartpanel.setSize(100, 100);
        CellConstraints cc = new CellConstraints();
        String panelColumns = "100dlu";
        String panelRows = "100dlu";
        FormLayout panelLayout = new FormLayout(panelColumns, panelRows);
        this.setLayout((LayoutManager)panelLayout);
        this.add((Component)chartpanel, cc.xy(1, 1));
        this.setSize(100, 100);
    }

    public void setValue(double value) {
        try {
            this.value = value;
            this.repaint();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

