/*
 * Decompiled with CFR 0.152.
 */
package de.chrmoll.jGPSpeedEvaluator.gui;

import de.chrmoll.jGPSpeedEvaluator.JGPSpeedEvaluator;
import de.chrmoll.jGPSpeedEvaluator.gui.GPSpeedPanel;
import de.chrmoll.jGPSpeedEvaluator.utils.TrackPoint;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Shape;
import java.awt.geom.Rectangle2D;
import java.util.Date;
import java.util.Vector;
import javax.swing.JPanel;
import lu.tudor.santec.i18n.Translatrix;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.LegendItem;
import org.jfree.chart.LegendItemCollection;
import org.jfree.chart.axis.AxisLocation;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.event.ChartProgressEvent;
import org.jfree.chart.event.ChartProgressListener;
import org.jfree.chart.plot.XYPlot;
import org.jfree.data.time.Second;
import org.jfree.data.xy.XYDataset;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;

public class TimeSeriesPanel
extends JPanel
implements ChartProgressListener {
    private static final long serialVersionUID = 1L;
    private JFreeChart chart;
    private XYSeriesCollection dataset = new XYSeriesCollection();
    private XYSeriesCollection datasetHeight = new XYSeriesCollection();
    private Vector<TrackPoint> rawData;
    private NumberAxis rangeSpeed;
    private NumberAxis rangeHeight;
    private GPSpeedPanel parent;
    private LegendItemCollection legend = new LegendItemCollection();
    private XYPlot plot;
    private XYSeries xsSpeed;
    private XYSeries xsHeight;

    public TimeSeriesPanel(GPSpeedPanel parent) {
        this.parent = parent;
        this.chart = ChartFactory.createTimeSeriesChart((String)Translatrix.getTranslationString((String)"chart.title"), null, (String)Translatrix.getTranslationString((String)"chart.rangeaxis"), (XYDataset)this.dataset, (boolean)true, (boolean)false, (boolean)false);
        this.plot = (XYPlot)this.chart.getPlot();
        this.plot.setNoDataMessage(Translatrix.getTranslationString((String)"chart.emptymessage"));
        this.plot.setFixedLegendItems(this.legend);
        this.plot.setDomainCrosshairVisible(true);
        this.plot.setDomainCrosshairLockedOnData(true);
        this.legend.add(new LegendItem(Translatrix.getTranslationString((String)"chart.speedlegend"), Translatrix.getTranslationString((String)"chart.speedlegend"), "", "", (Shape)new Rectangle2D.Double(0.0, 0.0, 5.0, 5.0), this.plot.getRenderer().getSeriesPaint(0)));
        this.legend.add(new LegendItem(Translatrix.getTranslationString((String)"chart.elevationlegend"), Translatrix.getTranslationString((String)"chart.elevationlegend"), "", "", (Shape)new Rectangle2D.Double(0.0, 0.0, 5.0, 5.0), this.plot.getRenderer().getSeriesPaint(1)));
        this.rangeSpeed = (NumberAxis)this.plot.getRangeAxis();
        this.rangeSpeed.setAutoRangeIncludesZero(true);
        ChartPanel chartpanel = new ChartPanel(this.chart);
        chartpanel.getChartRenderingInfo().setEntityCollection(null);
        this.chart.addProgressListener((ChartProgressListener)this);
        this.setLayout(new BorderLayout());
        this.add((Component)chartpanel, "Center");
    }

    public void updateGraph(Object trkpts, boolean plotHeight) {
        long startTime = System.currentTimeMillis();
        double minHeight = Double.MAX_VALUE;
        double maxHeight = Double.MIN_VALUE;
        this.rawData = (Vector)trkpts;
        this.xsSpeed = new XYSeries((Comparable)((Object)"speed"));
        this.xsHeight = new XYSeries((Comparable)((Object)"height"));
        this.dataset.removeAllSeries();
        this.datasetHeight.removeAllSeries();
        this.chart.setNotify(false);
        System.out.println("dataset size: " + this.rawData.size());
        for (TrackPoint element : this.rawData) {
            this.xsSpeed.add((double)new Second(element.getDate()).getStart().getTime(), element.getSpeed());
            this.xsHeight.add((double)new Second(element.getDate()).getStart().getTime(), element.getHeight());
            if (element.getHeight() > maxHeight) {
                maxHeight = element.getHeight();
            }
            if (!(element.getHeight() < minHeight)) continue;
            minHeight = element.getHeight();
        }
        System.out.println("total distance of track: " + this.rawData.lastElement().getDistance() + "m");
        System.out.println("max height of track: " + maxHeight + "m");
        System.out.println("min height of track: " + minHeight + "m");
        System.out.println("relative max height of track: " + (maxHeight - minHeight) + "m");
        this.dataset.addSeries(this.xsSpeed);
        if (this.plot.getRangeAxisCount() > 1) {
            this.plot.setRangeAxis(1, null);
        }
        if (plotHeight) {
            this.datasetHeight.addSeries(new XYSeries((Comparable)((Object)"empty")));
            this.datasetHeight.addSeries(this.xsHeight);
            this.rangeHeight = new NumberAxis(Translatrix.getTranslationString((String)"chart.elevationlegend"));
            this.plot.setRangeAxisLocation(1, AxisLocation.BOTTOM_OR_RIGHT);
            this.plot.setRangeAxis(1, (ValueAxis)this.rangeHeight);
            this.plot.getRenderer().setSeriesPaint(1, this.plot.getRenderer().getSeriesPaint(1));
            this.plot.setDataset(1, (XYDataset)this.datasetHeight);
            this.plot.mapDatasetToRangeAxis(1, 1);
        }
        this.chart.setNotify(true);
        this.parent.updateTacho(0.0);
        this.parent.updateDistance(this.rawData.lastElement().getDistance());
        this.parent.updateHeight(minHeight, maxHeight);
        this.parent.updateSpeed(this.getMaxValue(this.xsSpeed));
        Runtime rt = Runtime.getRuntime();
        double maxVM = rt.maxMemory() / 1024L;
        double totalAlloc = rt.totalMemory() / 1024L;
        double freeAlloc = rt.freeMemory() / 1024L;
        double used = totalAlloc - freeAlloc;
        double free = maxVM - used;
        System.out.println("used: " + used + " free: " + free);
        JGPSpeedEvaluator.benchmark(startTime, "Graph Update");
    }

    private double getMaxValue(XYSeries xs) {
        double max = -65536.0;
        int i = 0;
        while (i < xs.getItemCount()) {
            if (xs.getY(i).doubleValue() > max) {
                max = xs.getY(i).doubleValue();
            }
            ++i;
        }
        return max;
    }

    public void chartProgress(ChartProgressEvent arg0) {
        double crosshairValue = ((XYPlot)this.chart.getPlot()).getDomainCrosshairValue();
        double speed = 0.0;
        int index = 0;
        try {
            Date selection = new Date((long)crosshairValue);
            Date start = new Date(this.dataset.getSeries(0).getX(0).longValue());
            Date end = new Date(this.dataset.getSeries(0).getX(this.dataset.getSeries(0).getItemCount() - 1).longValue());
            int anz = (int)((end.getTime() - start.getTime()) / 1000L);
            index = (int)((selection.getTime() - start.getTime()) / 1000L);
            double factor = (0.0 + (double)this.dataset.getSeries(0).getItemCount()) / (double)anz;
            index = (int)((double)index * factor);
            speed = this.dataset.getSeries(0).getY(index).doubleValue();
            this.parent.updateTacho(speed);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

