/*
 * Decompiled with CFR 0.152.
 */
package de.chrmoll.jGPSpeedEvaluator.utils.Parsers;

import de.chrmoll.jGPSpeedEvaluator.utils.Parsers.Parser;
import de.chrmoll.jGPSpeedEvaluator.utils.TrackPoint;
import java.io.File;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Vector;
import org.dinopolis.gpstool.util.GeoMath;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GPXParser
implements Parser {
    private Date date;
    private Vector<TrackPoint> trkpts = null;
    private LinkedHashMap<String, Vector<TrackPoint>> trks = new LinkedHashMap();
    private TrackPoint trkpt;
    private SimpleDateFormat df = new SimpleDateFormat("dd.MM.yyyy HH:mm:ss");
    private int index;

    public GPXParser(String filename) {
        Document doc = null;
        try {
            SAXBuilder b = new SAXBuilder(false);
            doc = b.build(new File(filename));
            Element gpxElement = doc.getRootElement();
            for (Element childElem : gpxElement.getChildren()) {
                this.parseTRK(childElem);
            }
            System.out.println(this.trks.size());
        }
        catch (JDOMException j) {
            j.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void parseTRK(Element element) {
        if (element.getName().equals("trk")) {
            for (Element trkSegment : element.getChildren()) {
                this.parseTRKseg(trkSegment);
            }
        }
    }

    private void parseTRKseg(Element element) {
        if (element.getName().equals("trkseg")) {
            Iterator trkSegIter = element.getChildren().iterator();
            this.trkpts = new Vector();
            this.index = 0;
            while (trkSegIter.hasNext()) {
                Element trkElements = (Element)trkSegIter.next();
                Iterator trkElementsIter = trkElements.getChildren().iterator();
                this.date = null;
                if (!trkElements.getName().equals("trkpt")) continue;
                this.trkpt = new TrackPoint(trkElements.getAttributeValue("lat"), trkElements.getAttributeValue("lon"));
                while (trkElementsIter.hasNext()) {
                    Element value = (Element)trkElementsIter.next();
                    if (value.getName().equals("time")) {
                        String s = value.getTextTrim();
                        String sDate = s.substring(0, 10);
                        String sTime = s.substring(11, 19);
                        GregorianCalendar calendar = new GregorianCalendar();
                        calendar.set(new Integer(sDate.substring(0, 4)), new Integer(sDate.substring(5, 7)) - 1, new Integer(sDate.substring(8, 10)), new Integer(sTime.substring(0, 2)), new Integer(sTime.substring(3, 5)), new Integer(sTime.substring(6, 8)));
                        this.date = new Date(calendar.getTimeInMillis());
                        this.trkpt.setDate(this.date);
                    }
                    if (value.getName().equals("speed")) {
                        this.trkpt.setSpeed(new Double(value.getTextTrim()) * 3.6);
                    }
                    if (value.getName().equals("ele")) {
                        this.trkpt.setHeight(new Double(value.getTextTrim().replaceAll(",", "")));
                    }
                    if (this.trkpt.isDistanceSet || this.trkpts.size() == 0) continue;
                    this.trkpt.setDistance(this.trkpts.get(this.index - 1).getDistance() + GeoMath.distance(this.trkpts.get(this.index - 1).getLatitude(), this.trkpts.get(this.index - 1).getLongitude(), this.trkpt.getLatitude(), this.trkpt.getLongitude()));
                }
                this.trkpts.add(this.trkpt);
                ++this.index;
            }
            if (this.trkpts.size() != 0) {
                this.trks.put(this.df.format(this.date), this.trkpts);
            }
            this.trkpts = new Vector();
        }
    }

    @Override
    public LinkedHashMap<String, Vector<TrackPoint>> getTrks() {
        return this.trks;
    }
}

