/*
 * Decompiled with CFR 0.152.
 */
package net.hermen.input.atmegalogger;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.GregorianCalendar;
import java.util.HashMap;
import org.jfree.data.xy.XYSeries;

public class ATMegaFileReader {
    private static final boolean DEBUG = true;
    private DateFormat NMEATime = new SimpleDateFormat("ddMMyy-HHmmss.SSS");
    private DateFormat printFormat = new SimpleDateFormat("dd/MM/yy-HH:mm:ss.SSS");
    private GregorianCalendar timeStamp;
    public HashMap<Integer, XYSeries> measurementSeries = new HashMap();
    public static final double REFERENCE_VOLTAGE = 1.1;
    public static final double MAX_VAL = 1024.0;
    public static final double FACTOR = 0.00107421875;
    private String gpsString;
    private double km_h;
    private double m_s;
    private double height;
    private double satellites;

    public void readFile(String filePath) {
        this.readFile(new File(filePath));
    }

    public void readFile(File f) {
        try {
            BufferedReader br = new BufferedReader(new FileReader(f));
            String line = null;
            while ((line = br.readLine()) != null) {
                if (line.length() == 0) continue;
                if (line.startsWith(":")) {
                    this.parseMeasurementData(line);
                    continue;
                }
                if (line.startsWith("$GP")) {
                    this.readGPSLine(line);
                    continue;
                }
                this.readGPSLine(line);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void readGPSLine(String line) {
        if (line.startsWith("$GP")) {
            this.gpsString = line;
        } else {
            if (this.gpsString == null) {
                return;
            }
            this.gpsString = String.valueOf(this.gpsString) + line;
        }
        if (this.gpsString.contains("*")) {
            this.parseNMEAString(this.gpsString);
            this.gpsString = null;
        }
    }

    private void parseNMEAString(String gpsString) {
        try {
            String[] element = gpsString.split(",");
            if (element[0].equals("$GPRMC")) {
                if (element[2].equals("A")) {
                    this.timeStamp = new GregorianCalendar();
                    this.timeStamp.setTime(this.NMEATime.parse(String.valueOf(element[9]) + "-" + element[1]));
                    Double knots = Double.parseDouble(element[7]);
                    this.km_h = knots * 1.852;
                    this.m_s = knots * 0.51444;
                }
            } else if (element[0].equals("$GPGGA") && element[6].equals("1")) {
                this.height = Double.parseDouble(element[9]);
                this.satellites = Double.parseDouble(element[7]);
                System.out.println(String.valueOf(this.printFormat.format(this.timeStamp.getTime())) + " speed: " + this.km_h + " height: " + this.height + " satellites: " + this.satellites);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void parseMeasurementData(String line) {
        try {
            String[] columns = line.split("\t");
            String[] timeStrings = columns[0].split(" ");
            int timeFragment = Integer.parseInt(timeStrings[1]);
            int channel = 1;
            while (channel < columns.length) {
                XYSeries series = this.measurementSeries.get(channel);
                if (series == null) {
                    series = new XYSeries((Comparable)((Object)("Channel " + channel)));
                    series.setDescription("Channel " + channel);
                    this.measurementSeries.put(channel, series);
                }
                double value = Double.parseDouble(columns[channel]) * 0.00107421875;
                if (this.timeStamp != null) {
                    System.out.println(String.valueOf(series.getDescription()) + " " + this.printFormat.format(this.timeStamp.getTime()) + " " + value);
                }
                ++channel;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void main(String[] args) {
        ATMegaFileReader reader = new ATMegaFileReader();
        reader.readFile("testfiles/md001.txt");
    }
}

