/*
 * Decompiled with CFR 0.152.
 */
package org.dinopolis.gpstool.util;

public class GeoMath {
    public static final double RADIUS_EQUATOR = 6378137.0;
    public static final double CIRCUMFERENCE_EQUATOR = 4.007501668557849E7;
    public static final double M_PER_DEGREE = 111319.49079327358;
    public static final double M_PER_RADIAN = 6378137.000000001;
    static final double EPSILON = 1.0E-20;
    static final double EQUAL_EPSILON = 1.0E-10;

    public static double distance(double latitude1, double longitude1, double latitude2, double longitude2) {
        double distance_deg = GeoMath.distanceDegrees(latitude1, longitude1, latitude2, longitude2);
        return distance_deg * 111319.49079327358;
    }

    public static double distanceDegrees(double latitude1, double longitude1, double latitude2, double longitude2) {
        double distance_rad = GeoMath.distanceRadians(Math.toRadians(latitude1), Math.toRadians(longitude1), Math.toRadians(latitude2), Math.toRadians(longitude2));
        return Math.toDegrees(distance_rad);
    }

    public static double distanceRadians(double latitude1, double longitude1, double latitude2, double longitude2) {
        double pdiff = Math.sin((latitude2 - latitude1) / 2.0);
        double ldiff = Math.sin((longitude2 - longitude1) / 2.0);
        double rval = Math.sqrt(pdiff * pdiff + Math.cos(latitude2) * Math.cos(latitude1) * (ldiff * ldiff));
        return 2.0 * Math.asin(rval);
    }

    public static double courseDegrees(double latitude1, double longitude1, double latitude2, double longitude2) {
        double course = Math.toDegrees(GeoMath.courseRadians(Math.toRadians(latitude1), Math.toRadians(longitude1), Math.toRadians(latitude2), Math.toRadians(longitude2)));
        if (course < 0.0) {
            return 360.0 + course;
        }
        return course;
    }

    public static double courseRadians(double latitude1, double longitude1, double latitude2, double longitude2) {
        if (Math.abs(Math.cos(latitude1)) < 1.0E-20) {
            if (latitude1 > 0.0) {
                return Math.PI;
            }
            return 0.0;
        }
        double ldiff = longitude2 - longitude1;
        double cosphi = Math.cos(latitude2);
        return Math.atan2(cosphi * Math.sin(ldiff), Math.cos(latitude1) * Math.sin(latitude2) - Math.sin(latitude1) * cosphi * Math.cos(ldiff));
    }

    public static boolean approximatelyEqual(double a, double b) {
        return GeoMath.approximatelyEqual(a, b, 1.0E-10);
    }

    public static boolean approximatelyEqual(double a, double b, double epsilon) {
        return Math.abs(a - b) <= epsilon;
    }

    public static void main(String[] args) {
        System.out.println("north:");
        System.out.println("deg " + GeoMath.courseDegrees(47.0, 16.0, 48.0, 16.0));
        System.out.println("rad " + GeoMath.courseRadians(47.0, 16.0, 48.0, 16.0));
        System.out.println("south:");
        System.out.println("deg " + GeoMath.courseDegrees(47.0, 16.0, 46.0, 16.0));
        System.out.println("rad " + GeoMath.courseRadians(47.0, 16.0, 46.0, 16.0));
        System.out.println("north east:");
        System.out.println("deg " + GeoMath.courseDegrees(47.0, 16.0, 48.0, 17.0));
        System.out.println("rad " + GeoMath.courseRadians(47.0, 16.0, 48.0, 17.0));
        System.out.println("west:");
        System.out.println("deg " + GeoMath.courseDegrees(47.0, 16.0, 47.0, 15.0));
        System.out.println("rad " + GeoMath.courseRadians(47.0, 16.0, 47.0, 15.0));
    }
}

