
;All code by Rolf R Bakke 2011, 2012

;best viewed with a TAB-setting of 8 and monospace font.



.include "m324Pdef.inc"
.include "macros.inc"
.include "miscmacros.inc"
.include "variables.asm"
.include "hardware.asm"
.include "168mathlib_macros.inc"
.include "824mathlib_macros.inc"
.include "constants.asm"

.org 0x0000

	jmp reset		; Reset
	jmp unused		; External Interrupt Request 0
	jmp IsrCppm		; External Interrupt Request 1
	jmp unused		; External Interrupt Request 2
	jmp unused		; Pin Change Interrupt Request 0
	jmp unused		; Pin Change Interrupt Request 1
	jmp unused		; Pin Change Interrupt Request 2
	jmp unused		; Pin Change Interrupt Request 3
	jmp unused		; Watchdog Time-out Interrupt
	jmp unused		; Timer/Counter2 Compare Match A
	jmp unused		; Timer/Counter2 Compare Match B
	jmp unused		; Timer/Counter2 Overflow
	jmp unused		; Timer/Counter1 Capture Event
	jmp IsrPwmStart		; Timer/Counter1 Compare Match A
	jmp IsrPwmEnd		; Timer/Counter1 Compare Match B
	jmp unused		; Timer/Counter1 Overflow
	jmp unused		; Timer/Counter0 Compare Match A
	jmp unused		; Timer/Counter0 Compare Match B
	jmp unused		; Timer/Counter0 Overflow
	jmp unused		; SPI Serial Transfer Complete
	jmp unused		; USART0, Rx Complete
	jmp unused		; USART0 Data register Empty
	jmp unused		; USART0, Tx Complete
	jmp unused		; Analog Comparator
	jmp unused		; ADC Conversion Complete
	jmp unused		; EEPROM Ready
	jmp unused		; 2-wire Serial Interface
	jmp unused		; Store Program Memory Read
	jmp unused		; USART1 RX complete
	jmp unused		; USART1 Data Register Empty
	jmp unused		; USART1 TX complete

unused:	reti


;--- Hardware Init ---

reset:	ldi t,low(ramend)	;initalize stack pointer
	out spl,t
	ldi t,high(ramend)
	out sph,t

	ldx 100
	call WaitXms

	call SetupHardware


;--- Initialize LCD ---

	call LcdUpdate
	call LcdClear
	call LcdUpdate


;--- Variables init ---

	rvsetflagfalse Mode		;a factory reset will set this flag to 'true' (i.e. to skip ESC calibration)
	call EeInit

	lrv MainMenuCursorYposSave, 0
	lrv MainMenuListYposSave, 0
	
	lrv LoadMenuCursorYposSave, 0
	lrv LoadMenuListYposSave, 0

	lrv Status, 0
	lrv StatusOldState, 0

	lrv TuningRate, 2		;2=medium tuning rate
	b16ldi TuningRateValue, 0.45

	clr t
	sts TuningMode, t

	sts CppmChannel1L, t
	sts CppmChannel1H, t
	sts CppmChannel2L, t
	sts CppmChannel2H, t
	sts CppmChannel3L, t
	sts CppmChannel3H, t
	sts CppmChannel4L, t
	sts CppmChannel4H, t
	sts CppmChannel5L, t
	sts CppmChannel5H, t
	sts CppmChannel6L, t
	sts CppmChannel6H, t
	sts CppmChannel7L, t
	sts CppmChannel7H, t

	sts flagCppmValid, t
	lrv CppmDetectionCounter, CppmDetectionCount

	ldz CppmChannel1L
	sts CppmPulseArrayAddressL, zl
	sts CppmPulseArrayAddressH, zh

	call gyrocal

	call FlightInit


;--- MAIN ----

	sei				;global interrupts must be enabled here for PWM output in EscThrottleCalibration


;--- Throttle cal ----

	rvbrflagtrue Mode, ma2		;skip ESC calibration if arriving here after a factory reset
	load t, pinb			;read buttons. Will not use 'GetButtons' here because of delay
	com t
	swap t
	andi t, 0x0f			;any button pressed?
	breq ma2

	andi t, 0x08			;yes, button 1 pressed?
	breq ma5

	call EscCalWarning		;yes, show warning and skip ESC calibration
	rjmp ma2

ma5:	call EscThrottleCalibration



;--- Flight loop init

ma2:	call FlightInit

	;       76543210		;clear pending OCR1A and B interrupt
	ldi t,0b00000110
	store tifr1, t



;--- Flight Loop

ma1:
	;sbi OutputPin8		;OBS DEBUG

	call PwmStart			;runtime between PwmStart and B interrupt (in PwmEnd) must not exeed 1.5ms
	call GetRxChannels
	call CheckRx
	call Arming
	call Logic
	call Tuning
	call Imu
	call HeightDampening
	call Mixer
	call CameraStab
	call Beeper
	call Lva
	call PwmEnd

	
	rvcp Status, StatusOldState			;Set LcdUpdate if Status changes and not armed
	breq ma8
	rvmov StatusOldState, Status
	rvflagnot flagA, flagArmed 
	rvflagor  flagLcdUpdate, flagLcdUpdate, flagA 
ma8:
	rvflageor flagA, flagAuxOn, flagAuxOnOldState	;set LcdUpdate true if AuxOn changes state and it is not armed
	rvflagnot flagB, flagArmed
	rvflagand flagA, flagA, flagB 
	rvflagor  flagLcdUpdate, flagLcdUpdate, flagA 
	rvflagand flagAuxOnOldState, flagAuxOn, flagAuxOn

	rvbrflagfalse flagLcdUpdate, ma3		;Update LCD once if flagLcdUpdate is true 
	rvsetflagfalse flagLcdUpdate
	call UpdateFlightDisplay

ma3:	rvbrflagfalse flagArmed, ma7	;skip buttonreading if armed
	rjmp ma1

ma7:	load t, pinb			;read buttons
	com t
	swap t
	andi t, 0x0f
	cpi t, 0x01			;MENU?
	breq ma4
	
	lrv ButtonDelay, 0		;No, reset ButtonDelay, and go to start of the loop
	rjmp ma1	

ma4:	rvinc ButtonDelay		;yes, ButtonDelay++
	rvcpi ButtonDelay, 50		;ButtonDelay == 50?
	brne ma6			;yes, goto the menu
	rjmp ma1			;no, go to start of the loop	

ma6:

;--- Menu 

;	         76543210		;disable OCR1A and B interrupt
	ldi tt,0b00000000
	store timsk1, tt

	call Beep
	call MainMenu
	rjmp ma2

.include "camstab.asm"
.include "trigonometry.asm"
.include "cppmsettings.asm"
.include "checkrx.asm"
.include "setuphw.asm"
.include "version.asm"
.include "reset.asm"
.include "beeper.asm"
.include "menu.asm"
.include "lva.asm"
.include "logic.asm"
.include "heightdamp.asm"
.include "loader.asm"
.include "selflevel.asm"
.include "layout.asm"
.include "throttlecal.asm"
.include "eeinit.asm"
.include "sensorcal.asm"
.include "settingsc.asm"
.include "settingsb.asm"
.include "settingsa.asm"
.include "flightdisplay.asm"
.include "arm.asm"
.include "flightinit.asm"
.include "pieditor.asm"
.include "tuning.asm"
.include "numedit.asm"
.include "mixedit.asm"
.include "mixer2.asm"
.include "imu.asm"
.include "pwmgen.asm"
.include "rxtest.asm"
.include "readrx.asm"
.include "mainmenu.asm"
.include "sensortest.asm"
.include "sensorreading.asm"
.include "ST7565.asm"
.include "miscsubs.asm"
.include "168mathlib_subs.asm"
.include "824mathlib_subs.asm"
font6x8:
.include "font6x8.asm"
font8x12:
;.include "font8x12.asm"
font12x16:
.include "font12x16.asm"
symbols16x16:
.include "symbols16x16.asm"
font4x6:
.include "font4x6.asm"

	.db "__date__"




