


	;--- CPPM ISR ---

IsrCppm:

	in SregSaver, sreg

	sbic pind,3			;rising or falling?
	rjmp rx7

	out sreg, SregSaver		;falling, exit
	reti

rx7:	push xl				;rising, calculate pulse length:
	push xh
	push zl
	push zh
	
	lds xl, tcnt1l			;X = TCNT1 - CppmPulseStart, CppmPulseStart = TCNT1
	lds xh, tcnt1h
	lds zl, CppmPulseStartL
	lds zh, CppmPulseStartH
	sts CppmPulseStartL, xl
	sts CppmPulseStartH, xh
	sub xl, zl
	sbc xh, zh

	brpl rx8			;X = ABS(X)
	ldz 0
	sub zl, xl
	sbc zh, xh
	movw x, z
rx8:	
	ldz 6250			;pulse longer than 2.5ms?
	cp  xl, zl
	cpc xh, zh
	brlo rx11

	ldz CppmChannel1L		;yes, reset cppm sequence

	lds tt, CppmDetectionCounter	;detect CPPM pulse train after start-up or after a timeout
	dec tt
	brmi rx6

	sts CppmDetectionCounter, tt
	rjmp rx10

rx6:	ser tt				;set flag to indicate that a valid CPPM pulse train has been received
	sts flagCppmValid, tt
	rjmp rx10

rx11:	lds zl, CppmPulseArrayAddressL	;store channel in channel array.
	lds zh, CppmPulseArrayAddressH

	st z+, xl
	st z+, xh

	ldx CppmChannel9L		;end of array reached?
	cp  zl, xl
	cpc zh, xh
	brlo rx10
	breq rx10

	ldz CppmChannel9L		;yes, limit

rx10:	sts CppmPulseArrayAddressL, zl	;store array pointer
	sts CppmPulseArrayAddressH, zh

	clr tt				;reset timeout counter
	sts CppmTimeoutCounter, tt

	pop zh
	pop zl
	pop xh
	pop xl

	out sreg, SregSaver		;exit	
	reti


	;---


GetRxChannels:

	;--- Roll ---

	ldz eeCppmRoll
	rcall GetCppmChannel
	rcall Sanitize
	clr yh				;store in register
	b16store RxRoll

	
	;--- Pitch

	ldz eeCppmPitch
	rcall GetCppmChannel
	rcall Sanitize
	clr yh				;store in register
	b16store RxPitch


	;--- Throttle ---

	ldz eeCppmThrottle
	rcall GetCppmChannel

	rvsetflagfalse flagThrottleZero

	rcall Xabs			;X = ABS(X)

	ldz 2875			;X = X - 2875 (1.15ms)
	sub xl, zl
	sbc xh, zh

	ldz 0				;X < 0 ?
	cp  xl, zl
	cpc xh, zh
	brge gt8m8

	rjmp rx30			;yes, set to zero

gt8m8:	ldz 3125			;X > 3125? (1.25ms)
	cp  xl, zl
	cpc xh, zh
	brlt gt7m2

rx30:	ldx 0				;Yes, set to zero
	rvsetflagtrue flagThrottleZero

gt7m2:	clr yh				;store in register
	b16store RxThrottle


	;--- Yaw ---

	ldz eeCppmYaw
	rcall GetCppmChannel
	rcall Sanitize
	clr yh				;store in register
	b16store RxYaw

	
	;--- AUX ---

	ldz eeCppmAux
	rcall GetCppmChannel
	rcall Sanitize

	rvsetflagfalse flagBeepAuxOn
	rvsetflagfalse flagAuxOn
	ldz 625
	cp  xl, zl
	cpc xh, zh
	brge rx34			;is the AUX switch in ON position?

	ldz -625
	cp  xl, zl
	cpc xh, zh
	brlt rx35			;no, is it in OFF position?

rx33:	rvsetflagtrue flagBeepAuxOn	;no, it is in middle position
	rjmp rx36

rx34:	rvsetflagtrue flagAuxOn
	
rx35:	ser t				;re-initialize the 'delay' counter used for the 'Lost Model' alarm
	sts AuxBeepDelay, t

rx36:	clr yh				;store in register
	b16store RxAux


	;--- AUX2 ---

	ldi t, 5			;AUX2 is on CPPM channel 6
	mov r0, t
	ldzarray CppmChannel1L, 2, r0
	cli
	ld xl, z+
	ld xh, z
	sei
	rcall Sanitize
	clr yh				;store in register
	b16store RxAux2


	;--- AUX3 ---

	ldi t, 6			;AUX3 is on CPPM channel 7
	mov r0, t
	ldzarray CppmChannel1L, 2, r0
	cli
	ld xl, z+
	ld xh, z
	sei
	rcall Sanitize
	
	clr yh				;store in register
	b16store RxAux3


	;--- Use a [-100, 100] range for Aux2 and Aux3

	b16ldi Temp, 0.1
	b16mul RxAux2, RxAux2, Temp
	b16mul RxAux3, RxAux3, Temp


	;--- Check RX ---

	rvbrflagfalse flagCppmValid, rx24
	rjmp rx22

rx23:	ret

rx22:	rvinc CppmTimeoutCounter			;CPPM timeout?
	rvcp CppmTimeoutCounter, RxTimeoutLimit
	brlo rx23

	rvdec CppmTimeoutCounter
	lrv CppmDetectionCounter, CppmDetectionCount

rx24:	rvsetflagfalse flagCppmValid			;yes, set flag to false and values to zero
	b16clr RxRoll
	b16clr RxPitch
	b16clr RxThrottle
	b16clr RxYaw
	b16clr RxAux
	b16clr RxAux2
	b16clr RxAux3
	rvsetflagtrue flagThrottleZero
	rvsetflagfalse flagAuxOn
	rvsetflagfalse flagBeepAuxOn
	ret





	;----

GetCppmChannel:
	call ReadEeprom
	dec t
	mov r0, t
	ldzarray CppmChannel1L, 2, r0
	cli
	ld xl, z+
	ld xh, z
	sei

	ret



Sanitize:
	rcall Xabs	;X = ABS(X)

	ldz 3750	;X = X - 3750 (1.5ms)
	sub xl, zl
	sbc xh, zh

	ldz -1750	;X < -1750?  (0.7ms)
	cp  xl, zl
	cpc xh, zh
	brlt gt1m2

	ldz 1750	;X > 1750?
	cp  xl, zl
	cpc xh, zh
	brge gt1m2

	ret		;No, exit

gt1m2:	ldx 0		;Yes, set to zero
	ret





Xabs:	tst xh		;X = ABS(X)
	brpl xa1

	com xl
	com xh
	
	ldi t,1
	add xl,t
	clr t
	adc xh,t

xa1:	ret




