



EscThrottleCalibration:

	rvsetflagtrue Mode		;true = 2ms output, false = 1.02ms output

esc1:	call LcdClear6x8

	lrv Y1, 10			;print "Calibrating ESCs..."
	ldz esc10*2
	call PrintString

	rvbrflagtrue Mode, esc6		;will not print the footer while setting upper throttle limit

	lrv X1, 0			;print footer (i.e. 'EXIT')
	lrv Y1, 57
	ldz esc13*2
	call PrintString

	call LcdUpdate
	rjmp esc2

esc6:	lrv X1, 0			;print "Release button to set LOW throttle level." over two lines
	lrv Y1, 30
	ldz esc20*2
	call PrintString

	lrv X1, 0
	lrv Y1, 39
	ldz esc21*2
	call PrintString

	call LcdUpdate

	lrv OutputRateBitmask, 0x00	;low rate on all channels
	lrv OutputTypeBitmask, 0x00	;servo type on all channels
	lrv OutputRateDividerCounter, 1
	lrv OutputRateDivider, 8	;slow rate divider. f = 400 / OutputRateDivider
	rvsetflagtrue flagArmed
	b16ldi ServoFilter, 1

	LedOn

	;       76543210		;clear pending OCR1A and B interrupt
	ldi t,0b00000110
	store tifr1, t

	b16ldi Temp, 5000.0		;start with full throttle on M1 - M6
	b16ldi Temper, 2220.0		;center the gimbal servos
	rvsetflagfalse flagThrottleZero

esc2:	call PwmStart
	b16mov Out1, Temp
	b16mov Out2, Temp
	b16mov Out3, Temp
	b16mov Out4, Temp
	b16mov Out5, Temp
	b16mov Out6, Temp
	b16mov Out7, Temper		;gimbal servos on M7 and M8
	b16mov Out8, Temper
	call PwmEnd

	load t, pinb			;read buttons. Cannot use 'GetButtons' here because of delay
	com t
	swap t
	andi t, 0x0f
	push t				;must save register 't' since it is used by 'rvbrflagfalse' also

	rvbrflagfalse Mode, esc3
	pop t
	tst t				;button released?
	breq esc5
	b16ldi Temp, 5000.0		;no, keep full throttle
	rjmp esc2

esc3:	pop t
	cpi t, 0x08			;EXIT?
	breq esc4

	b16ldi Temp, 88.8		;no, set minimum throttle level
	rjmp esc2

esc5:	b16ldi Temp, 88.8		;mode is changing, set minimum throttle level
	rvsetflagfalse Mode
	rjmp esc1

esc4:	LedOff				;done
	call Beep
	ret



	;--- Warning displayed if button 1 is held down ---

EscCalWarning:

	call LcdClear12x16

	lrv X1, 22			;warning
	ldz war1*2
	call PrintString

	lrv FontSelector, f6x8

	lrv X1, 0			;print warning text
	lrv Y1, 17
	clr t

war12:	push t
	ldz war10*2
	call PrintFromStringArray
	lrv X1, 0
	rvadd Y1, 9
	pop t
	inc t
	cpi t, 3
	brne war12

	;footer
	call PrintOkFooter

	call LcdUpdate

war11:	call GetButtonsBlocking
	cpi t, 0x01			;OK?
	brne war11

	call Beep
	call ReleaseButtons
	ret





esc10:	.db "Calibrating ESCs...", 0
esc13:	.db "EXIT",0,0
esc20:	.db "Release button to set", 0
esc21:	.db "LOW throttle level.", 0

war1:	.db 72, 58, 68, 66, 63, 66, 62, 0	;the text "WARNING" in the mangled 12x16 font

war2:	.db "ESC calibration will", 0, 0
war3:	.db "fail if the leftmost", 0, 0
war4:	.db "button is held down!", 0, 0

war10:	.dw war2*2, war3*2, war4*2
