


	;--- CPPM ISR ---

IsrCppm:

	in SregSaver, sreg

	push xl
	push xh
	push zl
	push zh

	lds xl, tcnt1l			;calculate pulse length: X = TCNT1 - CppmPulseStart, CppmPulseStart = TCNT1
	lds xh, tcnt1h
	lds zl, CppmPulseStartL
	lds zh, CppmPulseStartH
	sts CppmPulseStartL, xl
	sts CppmPulseStartH, xh
	sub xl, zl
	sbc xh, zh
	brpl cppm8

	ldz 0				;X = ABS(X)
	sub zl, xl
	sbc zh, xh
	movw x, z

cppm8:	ldz 6250			;pulse longer than 2.5ms?
	cp  xl, zl
	cpc xh, zh
	brlo cppm11

	ldz CppmChannel1L		;yes, reset cppm sequence

	lds tt, CppmDetectionCounter	;detect CPPM pulse train after start-up or after a timeout
	dec tt
	brmi cppm6

	sts CppmDetectionCounter, tt
	rjmp cppm10

cppm6:	ser tt				;set flag to indicate that a valid CPPM pulse train has been received
	sts flagCppmValid, tt
	rjmp cppm10

cppm11:	lds zl, CppmPulseArrayAddressL	;store channel in channel array.
	lds zh, CppmPulseArrayAddressH

	st z+, xl
	st z+, xh

	ldx CppmChannel9L		;end of array reached?
	cp  zl, xl
	cpc zh, xh
	brlo cppm10
	breq cppm10

	ldz CppmChannel9L		;yes, limit

cppm10:	sts CppmPulseArrayAddressL, zl	;store array pointer
	sts CppmPulseArrayAddressH, zh

	clr tt				;reset timeout counter
	sts CppmTimeoutCounter, tt

	pop zh
	pop zl
	pop xh
	pop xl

	out sreg, SregSaver		;exit	
	reti


	;---


GetRxChannels:

	;--- Roll ---

	ldz eeChannelRoll
	rcall GetCppmChannel
	rcall Sanitize
	clr yh				;store in register
	b16store RxRoll

	
	;--- Pitch

	ldz eeChannelPitch
	rcall GetCppmChannel
	rcall Sanitize
	clr yh				;store in register
	b16store RxPitch


	;--- Throttle ---

	ldz eeChannelThrottle
	rcall GetCppmChannel

	rvsetflagfalse flagThrottleZero

	rcall Xabs			;X = ABS(X)

	ldz 2875			;X = X - 2875 (1.15ms)
	sub xl, zl
	sbc xh, zh

	ldz 0				;X < 0 ?
	cp  xl, zl
	cpc xh, zh
	brge gcc8

	rjmp gcc30			;yes, set to zero

gcc8:	ldz 3125			;X > 3125? (1.25ms)
	cp  xl, zl
	cpc xh, zh
	brlt gcc2

gcc30:	ldx 0				;Yes, set to zero
	rvsetflagtrue flagThrottleZero

gcc2:	clr yh				;store in register
	b16store RxThrottle


	;--- Yaw ---

	ldz eeChannelYaw
	rcall GetCppmChannel
	rcall Sanitize
	clr yh				;store in register
	b16store RxYaw

	
	;--- AUX ---

	ldz eeChannelAux
	rcall GetCppmChannel
	rcall Sanitize

	clr yl				;detect AUX switch position
	ldz -600
	cp  xl, zl
	cpc xh, zh
	brlt gcc35			;AUX switch is in position #1

	inc yl
	ldz -200
	cp  xl, zl
	cpc xh, zh
	brlt gcc35			;AUX switch is in position #2

	inc yl
	ldz 200
	cp  xl, zl
	cpc xh, zh
	brlt gcc35			;AUX switch is in position #3

	inc yl
	ldz 600
	cp  xl, zl
	cpc xh, zh
	brlt gcc35			;AUX switch is in position #4

	inc yl				;AUX switch is in position #5

gcc35:	sts AuxSwitchPosition, yl

	clr yh				;store in register
	b16store RxAux


	;--- AUX2 ---

	ldz eeChannelAux2
	rcall GetCppmChannel
	rcall Sanitize
	clr yh				;store in register
	b16store RxAux2


	;--- AUX3 ---

	ldz eeChannelAux3
	rcall GetCppmChannel
	rcall Sanitize
	clr yh				;store in register
	b16store RxAux3


	;--- AUX4 ---

	ldz eeChannelAux4
	rcall GetCppmChannel
	call Sanitize

	clr yl				;detect AUX4 switch position
	ldz -400
	cp  xl, zl
	cpc xh, zh
	brlt gcc38			;AUX4 switch is in position #1

	inc yl
	ldz 400
	cp  xl, zl
	cpc xh, zh
	brlt gcc38			;AUX4 switch is in position #2

	inc yl				;AUX4 switch is in position #3

gcc38:	sts Aux4SwitchPosition, yl

	clr yh				;store in register
	b16store RxAux4


	;--- Check RX ---

	rvbrflagfalse flagCppmValid, gcc24
	rjmp gcc22

gcc23:	ret

gcc22:	rvinc CppmTimeoutCounter			;CPPM signal timeout?
	rvcp CppmTimeoutCounter, RxTimeoutLimit
	brlo gcc23

	rvmov CppmTimeoutCounter, RxTimeoutLimit	;yes, prevent wrap-around
	lrv CppmDetectionCounter, CppmDetectionCount

	clr t						;select AUX switch function #1
	sts AuxSwitchPosition, t
	ser t				;make sure the AUX switch function will be updated
	sts AuxSwitchPositionOld, t

	rvbrflagfalse flagArmed, gcc24	;set "Signal Lost" flag only when armed

	setstatusbit RxSignalLost

gcc24:	rvsetflagfalse flagCppmValid	;set flag to false and values to zero
	b16clr RxRoll
	b16set RxPitch
	b16set RxThrottle
	b16set RxYaw
	b16set RxAux
	b16set RxAux2
	b16set RxAux3
	b16set RxAux4
	rvsetflagtrue flagThrottleZero
	ret



	;--- Get channel value ---

GetCppmChannel:

	call ReadEeprom
	dec t
	mov r0, t
	ldzarray CppmChannel1L, 2, r0
	cli
	ld xl, z+
	ld xh, z
	sei

	ret



	;--- Sanitize ---

Sanitize:

	rcall Xabs	;X = ABS(X)

	ldz 3750	;X = X - 3750 (1.5ms)
	sub xl, zl
	sbc xh, zh

	ldz -1750	;X < -1750?  (0.7ms)
	cp  xl, zl
	cpc xh, zh
	brlt gt1m2

	ldz 1750	;X > 1750?
	cp  xl, zl
	cpc xh, zh
	brge gt1m2

	ret		;No, exit

gt1m2:	ldx 0		;Yes, set to zero
	ret



	;---

Xabs:

	tst xh		;X = ABS(X)
	brpl xa1

	com xl
	com xh
	
	ldi t, 1
	add xl, t
	clr t
	adc xh, t

xa1:	ret



	;--- Scale AUX inputs (divide by 10) ---

ScaleAuxInputValues:

	b16ldi Temp, 0.1
	b16mul RxAux2, RxAux2, Temp
	b16mul RxAux3, RxAux3, Temp
	ret




