
.set xoff = 85				;X position for the channel value texts


RxTest:

	rvbrflagtrue flagCppmValid, rxt2;display a "NO SIGNAL" message if CPPM signal is absent

	call ShowNoSignalDlg
	ret

rxt2:	lrv RxTimeoutLimit, 2

rxt1:	call GetRxChannels

	b16ldi Temp, 0.1
	b16mul RxRoll, RxRoll, Temp
	b16mul RxPitch, RxPitch, Temp
	b16mul RxYaw, RxYaw, Temp
	b16mul RxAux, RxAux, Temp

	b16ldi Temp, 0.053
	b16mul RxThrottle, RxThrottle, Temp

	call LcdClear6x8

	ldi t, 5			;print all channel labels first
	ldz rxch*2
	call PrintStringArray

	lrv Y1, 1			;aileron
	b16load RxRoll
	ldz ailtxt*2
	rcall PrintRxValue

	b16load RxPitch			;elevator
	ldz eletxt*2
	rcall PrintRxValue

	rcall PrintRxColon		;throttle (needs special attention)
	b16load RxThrottle
	call Print16Signed
	lrv X1, xoff
	rvbrflagfalse flagThrottleZero, rxt4

	clr xl				;idle
	rjmp rxt6

rxt4:	ldz 90
	rcall CompareXZ
	brge rxt5

	ldi xl, 1			;1 - 90%
	rjmp rxt6

rxt5:	ldi xl, 2			;full
	
rxt6:	ldz thrtxt*2
	rcall PrintRxText

	b16load RxYaw			;rudder
	ldz rudtxt*2
	rcall PrintRxValue

	rcall PrintRxColon		;aux (needs special attention)
	b16load RxAux
	call Print16Signed
	lrv X1, xoff
	lds t, AuxSwitchPosition
	ldz auxtxt*2
	call PrintFromStringArray

	;footer
	lrv X1, 0
	lrv Y1, 57
	ldz rxt10*2
	call PrintString

	call LcdUpdate

	rcall RxPollDelay

	call GetButtons
	cpi t, 0x08			;BACK?
	brne rxt35

	ret	

rxt35:	cpi t, 0x04			;MORE?
	brne rxt7

	call Beep
	rcall RxTest2

rxt7:	rjmp rxt1



	;--- Second screen ---

RxTest2:

	call GetRxChannels

	call ScaleAuxInputValues
	b16mul RxAux4, RxAux4, Temp	;TEMP was set to 0.1 in ScaleAuxInputValues

	call LcdClear6x8

	clr xh				;print all channel labels first
	call PrintAuxLabels

	lrv Y1, 1			;aux2
	rcall PrintRxColon
	b16load RxAux2
	ldz notext*2
	call PrintRxValue

	rcall PrintRxColon		;aux3
	b16load RxAux3
	ldz notext*2
	call PrintRxValue

	rcall PrintRxColon		;aux4
	b16load RxAux4
	call Print16Signed
	lrv X1, xoff
	lds t, Aux4SwitchPosition
	ldz aux4txt*2
	call PrintFromStringArray

	;footer
	call PrintBackFooter

	call LcdUpdate

	rcall RxPollDelay

	call GetButtons
	cpi t, 0x08			;BACK?
	brne rxt202

	call Beep
	call ReleaseButtons
	ret				;return to the first RX test screen

rxt202:	rjmp rxTest2




rxt10:	.db "BACK MORE", 0

null:	.db 0, 0
left:	.db "Left", 0, 0
right:	.db "Right", 0
fwd:	.db "Forward", 0
rev:	.db "Back", 0, 0
idle:	.db "Idle", 0, 0
full:	.db "Full", 0, 0
center:	.db "Center", 0, 0

notext:	.dw null*2, null*2, null*2
ailtxt:	.dw left*2, null*2, right*2
eletxt:	.dw fwd*2, null*2, rev*2
thrtxt:	.dw idle*2, null*2, full*2
rudtxt:	.dw right*2, null*2, left*2



	;--- Print RX channel value and text ---

PrintRxValue:

	pushz				;register Z (input parameter) points to the string array that will be used
	rcall PrintRxColon
	call Print16Signed		;register X and YH (input parameter) holds the RX channel value
	lrv X1, xoff

	tst xl				;print "Center" when value is zero
	brne prt5

	tst yh
	brne prt5

	ldz center*2
	call PrintString
	popz
	rjmp prt4

prt5:	rcall CompareXZminus10		;print specified text when value is below -10 and above 10
	brge prt1

	clr xl
	rjmp prt3

prt1:	rcall CompareXZplus10
	brge prt2

	ldi xl, 1			;close to center
	rjmp prt3

prt2:	ldi xl, 2

prt3:	popz

PrintRxText:

	mov t, xl
	call PrintFromStringArray

prt4:	rvadd Y1, 9
	ret



	;--- Print a colon (:) ---

PrintRxColon:

	lrv X1, 48
	ldi t, ':'
	rcall PrintChar
	lrv X1, 57
	ret



	;--- Compare if stick input exceeds 10% ---

CompareXZminus10:

	ldz -10
	rjmp CompareXZ

CompareXZplus10:

	ldz 10

CompareXZ:

	cp  xl, zl
	cpc xh, zh
	ret



	;--- Delay for RX polling ---

RxPollDelay:
	ldi yh, 5
rpd1:	ldi yl, 0
	call wms
	dec yh
	brne rpd1

	ret


