
.def AuxItem = r17
.def Changes = r18

AuxSwitchSetup:

	clr Changes

aux11:	call GetRxChannels
	call LcdClear6x8

	clr t				;print all text labels first

aux15:	push t
	ldz auxtxt*2
	call PrintFromStringArray
	lrv X1, 0
	rvadd Y1, 9
	pop t
	inc t
	cpi t, 3
	brne aux15

	lrv Y1, 1			;aux position 1 function
	lds t, AuxPos1Function
	rcall PrintAuxValue

	lds t, AuxPos2Function		;aux position 2 function
	rcall PrintAuxValue

	lds t, AuxPos3Function		;aux position 3 function
	rcall PrintAuxValue

	lrv X1, 0			;aux switch position
	lrv Y1, 36
	ldz aux5*2
	call PrintString
	ldi t, '1'
	lds xl, AuxSwitchPosition
	add t, xl
	call PrintChar

	;footer
	call PrintStdFooter

	;print selector
	ldzarray aux7*2, 4, AuxItem
	call PrintSelector

	call LcdUpdate

	call RxPollDelay

	call GetButtons

	cpi t, 0x08			;BACK?
	brne aux12

	tst Changes
	brne aux17

	ret	

aux17:	lds xl, AuxPos1Function		;save to EEPROM
	ldz eeAuxPos1Function
	call StoreEeVariable8

	lds xl, AuxPos2Function
	ldz eeAuxPos2Function
	call StoreEeVariable8

	lds xl, AuxPos3Function
	ldz eeAuxPos3Function
	call StoreEeVariable8
	ret

aux12:	cpi t, 0x04			;PREV?
	brne aux13

	dec AuxItem
	brpl aux16

	ldi AuxItem, 2

aux16:	call Beep
	call ReleaseButtons
	rjmp aux11	

aux13:	cpi t, 0x02			;NEXT?
	brne aux14

	inc AuxItem
	cpi AuxItem, 3
	brne aux16

	clr AuxItem
	rjmp aux16	

aux14:	cpi t, 0x01			;CHANGE?
	brne aux19

	ser Changes
	ldx AuxPos1Function
	add xl, AuxItem
	brcc aux20

	inc xh

aux20:	ld t, x
	inc t
	cpi t, 6
	brlt aux21

	clr t

aux21:	st x, t
	rjmp aux16

aux19:	rjmp aux11



	;--- Print AUX function (string) ---

PrintAuxValue:

	push t				;register T holds the item index
	lrv X1, 30
	call PrintColonAndSpace
	pop t
	ldz auxfn*2
	call PrintFromStringArray
	rvadd Y1, 9
	ret




acro:	.db "Acro", 0, 0
slmixl:	.db "SL Mix Low", 0, 0
slmixm:	.db "SL Mix Medium", 0
slmixh:	.db "SL Mix High", 0
normsl:	.db "Normal SL", 0
alarm:	.db "Alarm", 0

auxfn:	.dw acro*2, slmixl*2, slmixm*2, slmixh*2, normsl*2, alarm*2

aux5:	.db "AUX Switch Pos.: ", 0

aux7:	.db 41, 0, 127, 9
	.db 41, 9, 127, 18
	.db 41, 18, 127, 27


.undef Changes
.undef AuxItem
