
.def	Counter = r17



	;--- Initialize EEPROM if the signature is bad ---

EeInit:

	ldz 0				;check EEPROM signature for user profile #1
	rcall CheckEeSignature
	tst xl
	breq eei1

	clr t				;initialize user profile #1
	sts UserProfile, t
	rcall InitUserProfile

	call DisableEscCalibration	;initialize variables that are used in profile #1 only
	call SetDefaultLcdContrast

	clr t				;set user profile #1 to be used by default
	ldz eeUserProfile
	call WriteEeprom

eei1:	ldz eeUserAccepted		;show the disclaimer if not yet accepted
	call ReadEeprom
	brflagtrue t, eei2

	rcall ShowDisclaimer

eei2:	lds zh, UserProfile		;check EEPROM signature for the current user profile (skipped for profile #1)
	tst zh
	breq eei3

	clr zl
	rcall CheckEeSignature
	tst xl
	breq eei3

	rcall InitUserProfile		;initialize current user profile

eei3:	ret



	;--- Check EEPROM signature (register ZH decides which user profile to check) ---

CheckEeSignature:

	call GetEeVariable8
	cpi xl, 0x19
	brne ces1

	call GetEeVariable8
	cpi xl, 0x03
	brne ces1

	call GetEeVariable8
	cpi xl, 0x73
	brne ces1

	call GetEeVariable8
	cpi xl, 0xB2
	brne ces1

	clr xl				;signature is OK
	ret

ces1:	ser xl				;bad signature
	ret



	;--- Initialize the current user profile ---

InitUserProfile:

	ldz EeMixerTable		;Mixertable
	ldx 0
	ldi Counter, 64
iup3:	call StoreEePVariable8
	dec Counter
	brne iup3

	ldx EeParameterTable		;ParameterTable
	ldy eei4*2
	ldi Counter, 24
iup5:	movw z, y
	lpm t, z
	movw z, x
	call WriteEepromP
	adiw x, 1
	adiw y, 1
	dec Counter
	brne iup5

	ldx eeStickScaleRoll		;Stick Scaling
	ldy eei7*2
	ldi Counter, 10
iup8:	movw z, y
	lpm t, z
	movw z, x
	call WriteEepromP
	adiw x, 1
	adiw y, 1
	dec Counter
	brne iup8


	ldx 60
	ldz eeSelflevelPgain
	call StoreEePVariable16		;eeSelflevelPgain
	ldx 20
	call StoreEePVariable16		;eeSelflevelPlimit
	ldx 0
	call StoreEePVariable16		;eeAccTrimRoll
	call StoreEePVariable16		;eeAccTrimPitch
	ldx 10
	call StoreEePVariable16		;eeSlMixRate


	call StoreEePVariable16		;eeEscLowLimit (set to 10)
	ldx 0
	call StoreEePVariable16		;eeHeightDampeningGain
	ldx 30
	call StoreEePVariable16		;eeHeightDampeningLimit
	ldx 0
	call StoreEePVariable16		;eeBattAlarmVoltage
	ldx 50
	call StoreEePVariable16		;eeServoFilter


	ser xl
	call StoreEePVariable8		;eeLinkRollPitch
	call StoreEePVariable8		;eeAutoDisarm
	call StoreEePVariable8		;eeButtonBeep
	call StoreEePVariable8		;eeArmingBeeps
	call StoreEePVariable8		;eeReserved


	ldx 0
	call StoreEePVariable16		;eeCamRollGain
	ldx 50
	call StoreEePVariable16		;eeCamRollOffset
	ldx 0
	call StoreEePVariable16		;eeCamPitchGain
	ldx 50
	call StoreEePVariable16		;eeCamPitchOffset
	ldx 0
	call StoreEePVariable8		;eeCamServoMixing (set to NONE)


	setflagfalse xl
	call StoreEePVariable8		;eeSensorsCalibrated
	call StoreEePVariable8		;eeMotorLayoutOk
	call StoreEePVariable8		;eeUserAccepted


	clr xl
	call StoreEePVariable8		;eeAuxPos1Function (set to ACRO)
	call StoreEePVariable8		;eeAuxPos2Function (set to ACRO)
	call StoreEePVariable8		;eeAuxPos3Function (set to ACRO)
	call StoreEePVariable8		;eeAuxPos4Function (set to ACRO)
	call StoreEePVariable8		;eeAuxPos5Function (set to ACRO)


	ldz 0				;EE signature
	ldi xl, 0x19
	call StoreEePVariable8
	ldi xl, 0x03
	call StoreEePVariable8
	ldi xl, 0x73
	call StoreEePVariable8
	ldi xl, 0xB2
	call StoreEePVariable8

	ldi Counter, 5
iup6:	call Beep
	ldi yl, 0
	call wms
	dec Counter
	brne iup6

	ret



	;--- Disclaimer ---

ShowDisclaimer:

	call LcdClear12x16

	lrv X1, 16			;reminder
	ldz eew1*2
	call PrintString

	lrv FontSelector, f6x8

	lrv X1, 0			;print disclaimer text
	lrv Y1, 17
	clr t

eew12:	push t
	ldz eew10*2
	call PrintFromStringArray
	lrv X1, 0
	rvadd Y1, 9
	pop t
	inc t
	cpi t, 4
	brne eew12

	;footer
	call PrintOkFooter

	call LcdUpdate

eew11:	call GetButtonsBlocking
	cpi t, 0x01			;OK?
	brne eew11

	ser t				;set flag to indicate that the user has accepted the disclaimer
	ldz eeUserAccepted
	call WriteEeprom

	call ReleaseButtons		;make sure buttons are released
	ret




eei4:	.dw 50, 100, 25, 20		;default PI gains and limits for aileron, elevator and rudder
	.dw 50, 100, 25, 20
	.dw 50, 20, 50, 10


eei7:	.dw 30, 30, 50, 90, 100		;default stick scaling values


eew1:	.db 70, 61, 66, 64, 67, 60, 61, 70, 0, 0	;the text "REMINDER" in the mangled 12x16 font

eew2:	.db "YOU USE THIS FIRMWARE", 0
eew3:	.db "AT YOUR OWN RISK!", 0
eew4:	.db "Read the instructions", 0
eew5:	.db "carefully.", 0, 0

eew10:	.dw eew2*2, eew3*2, eew4*2, eew5*2


.undef Counter

