

UpdateFlightDisplay:

	rvsetflagtrue flagMutePwm

	call LcdClear12x16


	;--- Print armed status ---

	rvbrflagfalse flagArmed, udp3

	lrv X1, 34				;Armed
	lrv Y1, 22
	ldz upd5*2
	call PrintString

	ldz udp7*2				;banner
	call PrintSelector
	rjmp udp22

udp3:	lrv X1, 38				;Safe
	ldz upd2*2
	call PrintString


	;--- Print user profile selection ---

	lrv X1, 102
	ldi t, 69				;character 'P' in the mangled 12x16 font
	call PrintChar
	ldi t, 49				;character '1' in the mangled 12x16 font
	lds xl, UserProfile
	add t, xl
	call PrintChar
udp22:


	;--- Print footer if safe ---

	rvbrflagtrue flagArmed, udp20

	lrv X1, 36				;footer
	lrv Y1, 57
	lrv FontSelector, f6x8
	ldz upd1*2
	call PrintString

	rvbrflagfalse flagArmed, udp23		;skip the rest if armed
udp20:	rjmp udp21
	


udp23:	;--- Print status ---

	lrv X1, 0
	lrv Y1, 17
	rcall LoadStatusString
	call PrintString



	;--- Print flight mode ---

	lrv X1, 0				;mode
	lrv Y1, 27
	ldz udp9*2
	call PrintString
	rvbrflagfalse flagSlOn, udp50

	ldz udp10*2				;normal SL
	call PrintString
	rjmp udp13

udp50:	rvbrflagfalse flagSlStickMixing, udp52

	ldz udp12*2				;SL mixing
	call PrintString
	rjmp udp13

udp52:	ldz udp11*2				;acro
	call PrintString



udp13:	;--- Print battery voltages ---

	lrv Y1, 36
	ldz batt*2
	b16mov Temper, BatteryVoltage
	rcall PrintVoltage

	ldz ublog*2
	b16mov Temper, BatteryVoltageLogged
	call PrintVoltage


	;---

udp21:	call LcdUpdate

	rvsetflagfalse flagMutePwm
	ret



	;--- Print voltage value ---

PrintVoltage:

	lrv X1, 0				;label
	call PrintString

	b16ldi Temp, 6.875067139		;calculate value
	b16mul Temp, Temper, Temp
	b16fdiv Temp, 8

	b16load Temp				;print the integer part
 	call Print16Signed
	
	ldi t,'.'
	call PrintChar

	mov xl, yh
	clr xh
	b16store Temp

	b16ldi Temper, 0.0390625
	b16mul Temp, Temp, Temper

	b16load Temp				;print the fractional part (one digit)
 	call Print16Signed
	ldi t, 'V'
	call PrintChar

	rvadd Y1, 9
	ret



upd1:	.db "<PROFILE>  MENU", 0
upd2:	.db 71, 58, 62, 61, 0, 0		;the text "SAFE" in the mangled 12x16 font
upd5:	.db 58, 70, 66, 61, 60, 0		;the text "ARMED" in the mangled 12x16 font

udp7:	.db 0, 19, 127, 40

udp9:	.db "Mode   : ", 0
udp10:	.db "NORMAL SL", 0
udp11:	.db "ACRO", 0, 0
udp12:	.db "SL MIXING", 0

batt:	.db "Battery: ", 0
ublog:	.db "Logged : ", 0

sta1:	.db "ACC not calibrated.", 0
sta2:	.db "No aileron input.", 0
sta3:	.db "No elevator input.", 0, 0
sta4:	.db "No throttle input.", 0, 0
sta5:	.db "No rudder input.", 0, 0
sta6:	.db "Sanity check failed.", 0, 0
sta7:	.db "No motor layout!", 0, 0



	;--- Load status string ---

LoadStatusString:

	lds t, StatusBits
	cbr t, LvaWarning			;no error message displayed for LVA warning
	tst t
	brne lss1

	ldz ok*2				;no error
	ret

lss1:	lds t, StatusBits
	andi t, NoMotorLayout
	breq lss2

	ldz sta7*2				;no motor layout
	ret

lss2:	lds t, StatusBits
	andi t, AccNotCalibrated
	breq lss3

	ldz sta1*2				;ACC not calibrated
	ret

lss3:	lds t, StatusBits
	andi t, SanityCheckFailed
	breq lss4

	ldz sta6*2				;sanity check failed
	ret

lss4:	lds t, StatusBits
	andi t, NoAileronInput
	breq lss5

	ldz sta2*2				;no aileron input
	ret

lss5:	lds t, StatusBits
	andi t, NoElevatorInput
	breq lss6

	ldz sta3*2				;no elevator input
	ret

lss6:	lds t, StatusBits
	andi t, NoThrottleInput
	breq lss7

	ldz sta4*2				;no throttle input
	ret

lss7:	ldz sta5*2				;no rudder input
	ret



