
	;--- Quick tuning ---

QuickTuning:

	call FlightInit				;initialize variables that might have been modified without returning to the SAFE screen
	call StopLedSeq				;the KK2 LED cannot be used to indicate selected user profile here
	call StopPwmQuiet			;stop PWM timer (if running). PWM output will instead be generated by the flight loop below

qt10:	;header
	call LcdClear12x16
	rvbrflagfalse flagArmed, qt11

	lrv X1, 34				;armed
	lrv Y1, 22
	ldz armed*2
	call PrintString
	rjmp qt12

qt11:	lrv X1, 28				;tuning (safe)
	ldz tuning*2
	call PrintString
	lrv FontSelector, f6x8

	;parameter
	lrv X1, 0				;first part of the parameter label (e.g. "Aileron")
	lrv Y1, 17
	lds t, QTuningIndex
	ldz tune1*2
	call PrintFromStringArray

	ldi t, ' '				;second part of the parameter label (e.g. "P gain")
	call PrintChar
	lds t, QTuningIndex
	ldz tune2*2
	call PrintFromStringArray
	call PrintColonAndSpace

	lds yl, QTuningIndex			;fetch parameter value from EEPROM
	rcall LoadEeTuningAddress
	call GetEePVariable16
 	call Print16Signed

	;status
	lrv X1, 0
	lrv Y1, 30
	lds t, StatusBits
	tst t
	brne qt13

	ldz ready*2				;ready for take-off
	rjmp qt14

qt13:	call LoadStatusString			;error message

qt14:	call PrintString

	;flight mode
	lrv X1, 0
	rvadd Y1, 9
	ldz flmode*2
	call PrintString
	call PrintFlightMode

	;footer
	call PrintStdFooter

qt12:	call LcdUpdate

qt50:	;flight loop
	call PwmStart				;runtime between PwmStart and B interrupt (in PwmEnd) must not exeed 1.5ms
	call GetRxChannels
	call CheckRx
	call Arming
	call Logic
	call Imu
	call HeightDampening
	call Mixer
	call CameraStab
	call Beeper
	call Lva
	call PwmEnd

	rvbrflagfalse flagLcdUpdate, qt53	;update LCD once if flagLcdUpdate is true

	rvsetflagfalse flagLcdUpdate
	rjmp qt10

qt53:	rvbrflagfalse flagArmed, qt54		;skip buttonreading if armed
	rjmp qt50

qt54:	load t, pinb				;read buttons
	com t
	swap t
	andi t, 0x0F				;button pressed?
	brne qt55
	
	lrv ButtonDelay, 0			;no, reset ButtonDelay, and go to start of the loop
	rjmp qt50	

qt55:	rvinc ButtonDelay			;yes, ButtonDelay++
	rvcpi ButtonDelay, 50			;ButtonDelay == 50?
	breq qt56				;yes, re-check button
	rjmp qt50				;no, go to start of the loop	

qt56:	call GetButtons
	cpi t, 0x08				;BACK?
	brne qt57

;	         76543210			;disable OCR1A and B interrupt
	ldi t, 0b00000000
	store timsk1, t

	call StartLedSeq
	call StartPwmQuiet
	ret

qt57:	cpi t, 0x04				;PREV?
	brne qt58

	lds xl, QTuningIndex
	dec xl
	brpl qt61

	ldi xl, 10

qt61:	sts QTuningIndex, xl
	rjmp qt10

qt58:	cpi t, 0x02				;NEXT?
	brne qt59

	lds xl, QTuningIndex
	inc xl
	cpi xl, 11
	brlt qt61

	clr xl
	rjmp qt61

	rjmp qt10

qt59:	cpi t, 0x01				;CHANGE?
	brne qt60

;	         76543210			;disable OCR1A and B interrupt
	ldi t, 0b00000000
	store timsk1, t

	call StartLedSeq
	call StartPwmQuiet

	lds yl, QTuningIndex
	rcall LoadEeTuningAddress
	push zl
	push zh
	call GetEePVariable16
	ldzarray tune4*2, 4, yl
	lpm yl, Z+
	lpm yh, Z+
	lpm r0, Z+
	lpm r1, Z+
	mov zl, r0
	mov zh, r1
	call NumberEdit
	mov xl, r0
	mov xh, r1
	pop zh
	pop zl
	call StoreEePVariable16

	lds yl, QTuningIndex			;aileron or elevator parameter selected?
	cpi yl, 4
	brge qt67

	lds t, flagRollPitchLink		;yes, linked?
	tst t
	breq qt67

	cpi yl, 2				;yes, which parameter was just saved?
	brge qt65

	ori yl, 0x02				;aileron parameter was saved
	rjmp qt66

qt65:	andi yl, 0x01				;elevator parameter was saved

qt66:	pushx					;save the same parameter value for the other axis
	rcall LoadEeTuningAddress
	popx
	call StoreEePVariable16

qt67:	call FlightInit				;initialize variables

	call StopLedSeq
	call StopPwmQuiet
	rjmp qt10

qt60:	rjmp qt50



tuning:	.db 72, 73, 67, 64, 67, 63, 0, 0	;the text "TUNING" in the mangled 12x16 font

ready:	.db "Ready for take-off!", 0
flmode:	.db "Mode: ", 0, 0

roll:	.db "Roll", 0, 0
pitch:	.db "Pitch", 0

tune1:	.dw ail*2, ail*2, ele*2, ele*2, rudd*2, rudd*2, selflvl*2, sltrim*2, sltrim*2, gimbal*2, gimbal*2
tune2:	.dw pgain*2, igain*2, pgain*2, igain*2, pgain*2, igain*2, pgain*2, roll*2, pitch*2, roll*2, pitch*2
tune3:	.dw 0x0044, 0x0048, 0x004C, 0x0050, 0x0054, 0x0058, eeSelflevelPgain, eeAccTrimRoll, eeAccTrimPitch, eeCamRollGain, eeCamPitchGain

tune4:	.dw 0, 900				;aileron P-gain
	.dw 0, 900				;aileron I-gain
	.dw 0, 900				;elevator P-gain
	.dw 0, 900				;elevator I-gain
	.dw 0, 900				;rudder P-gain
	.dw 0, 900				;rudder I-gain
	.dw 0, 900				;SL P-gain
	.dw -900, 900				;ACC trim roll
	.dw -900, 900				;ACC trim pitch
	.dw -32000, 32000			;gimbal roll gain
	.dw -32000, 32000			;gimbal pitch gain



	;--- Load EEPROM variable's address ---

LoadEeTuningAddress:

	ldzarray tune3, 1, yl
	lsl zl
	rol zh
	lpm xl, z+
	lpm xh, z
	movw z, x
	ret

