
	;--- turn off buzzer when BeeperDelay runs out ----

Beeper:	b16clr Temp					;is BeeperDelay == 0 ?
	b16cmp BeeperDelay, Temp
	breq bee1

	b16dec BeeperDelay				;No, subtract one and exit
	rjmp bee2


bee1:	rvsetflagfalse flagGeneralBuzzerOn		;yes, turn off buzzer and exit


bee2:	;--- Make a short beep regulary when armed and throttle at idle ----

	rvflagand flagA, flagArmed, flagThrottleZero
	rvbrflagfalse FlagA, bee4

	b16dec ArmedBeepDds

	b16clr Temp
	b16cmp ArmedBeepDds, Temp
	brge bee4

	b16ldi ArmedBeepDds, 400*2

	rvsetflagtrue flagGeneralBuzzerOn
	b16ldi BeeperDelay, 20


bee4:	;--- No activity alarm ---

	rvflageor flagA, flagArmed, flagArmedOldState		;flagA == true if flagArmed changes state
	rvflagand flagArmedOldState, flagArmed, flagArmed

	rvbrflagfalse flagA, bee5				;activity?

	b16clr NoActivityTimer					;Yes, reset timer

bee5:	b16ldi Temp, 0.004					;add 3.90625ms to timer
	b16add NoActivityTimer, NoActivityTimer, Temp

	b16ldi Temp, 32000					;avoid wrap-around
	b16cmp NoActivityTimer, Temp
	brlt bee8

	b16mov NoActivityTimer, Temp
	
bee8:	lds t, FailSafe						;activate alarm if failsafe has been triggered
	tst t
	brne bee7

	lds t, Channel17					;is alarm activated remotely?
	tst t
	breq bee9

	lds t, Channel17Old					;yes, reset the 'Activation' delay counter when the state changes
	tst t
	brne bee10

	ser t
	sts AuxBeepDelay, t
	rjmp bee9

bee10:	lds t, AuxBeepDelay					;use a short 'Activation' delay to avoid extra beep during start-up
	tst t
	breq bee7

	dec t							;keep the 'No Activity' counter zeroed while counting down so that
	sts AuxBeepDelay, t					;...the first beep starts immediately after the timeout
	b16clr NoActivityDds

bee9:	lds t, Channel17					;update the switch value used for detecting a state change
	sts Channel17Old, t

	b16ldi Temp, 937.5 * 3					;30 minutes without activity? (arming or disarming)
	b16cmp NoActivityTimer, Temp
	brlt bee6

bee7:	b16dec NoActivityDds					;yes, beep once every 5s
	b16clr Temp
	b16cmp NoActivityDds, Temp
	brge bee6

	b16ldi NoActivityDds, 400*5
	rvsetflagtrue flagGeneralBuzzerOn
	b16ldi BeeperDelay, 400


bee6:	;--- turn buzzer on/off depending on flags ---

	rvflagor flagA, flagGeneralBuzzerOn, flagLvaBuzzerOn
	rvflagor flagA, flagA, flagDebugBuzzerOn
	rvbrflagtrue flagA, bee3
	BuzzerOff
	ret

bee3:	BuzzerOn
	ret




	;--- A short (button) beep ---

Beep:

	push t				;check beep setting
	pushz
	ldz eeButtonBeep
	call ReadEeprom
	brflagtrue t, beep1

	popz				;button beep is turned off
	pop t
	ret

beep1:	popz				;beep
	push yl

	BuzzerOn
	ldi yl, 50
	call wms
	BuzzerOff

	pop yl
	pop t
	ret
