
.set xoff = 78


SBusStatus:

sbus11:	rcall GetSBusFlags
	lds t, flagSBusFrameValid
	tst t
	brne sbus21

	rcall ShowNoDataDlg		;no data to be displayed
	ret

sbus21:	call LcdClear6x8

	clr t				;print all text labels first

sbus22:	push t
	ldz sbus6*2
	call PrintFromStringArray
	lrv X1, 66
	call PrintColonAndSpace
	lrv X1, 0
	rvadd Y1, 9
	pop t
	inc t
	cpi t, 5
	brne sbus22

	lrv X1, xoff			;channel 17 (DG1)
	lrv Y1, 1
	lds t, Channel17
	ldz onoff*2
	rcall PrintSBusValue

	lds t, Channel18		;channel 18 (DG2)
	ldz onoff*2
	rcall PrintSBusValue

	lds t, Failsafe			;failsafe
	ldz yesno*2
	rcall PrintSBusValue

	lds t, FrameLost		;frame lost
	ldz yesno*2
	rcall PrintSBusValue

	lds t, DataErrors		;data errors
	ldz yesno*2
	rcall PrintSBusValue

	;footer
	call PrintBackFooter

	call LcdUpdate

	call GetButtons

	cpi t, 0x08			;BACK?
	brne sbus20

	call ReleaseButtons
	rcall ClearSBusErrors
	ret	

sbus20:	rjmp sbus11




sbus1:	.db "S.Bus Ch.17", 0
sbus2:	.db "S.Bus Ch.18", 0
sbus3:	.db "Failsafe", 0, 0
sbus4:	.db "Frame lost", 0, 0
sbus5:	.db "Data errors", 0

sbus6:	.dw sbus1*2, sbus2*2, sbus3*2, sbus4*2, sbus5*2

pnd1:	.db 60, 58, 71, 58, 0, 0	;the text "DATA" in the mangled 12x16 font

pnd2:	.db "Please supply S.Bus", 0
pnd3:	.db "data to the throttle", 0, 0
pnd4:	.db "input connector.", 0, 0

pnd8:	.dw pnd2*2, pnd3*2, pnd4*2


	;---

PrintSBusValue:

	call PrintFromStringArray
	lrv X1, xoff	
	rvadd Y1, 9
	ret


	;---

ShowNoDataDlg:

	call LcdClear12x16

	lrv X1, 22
	ldi t, 67			;the character 'N' in the mangled 12x16 font
	call PrintChar
	ldi t, 68			;the character 'O' in the mangled 12x16 font
	call PrintChar

	lrv X1, 58			;print "DATA"
	ldz pnd1*2
	call PrintString

	lrv FontSelector, f6x8

	lrv X1, 0			;print "Please supply S.Bus data to the throttle input connector."
	lrv Y1, 17
	clr t

pnd11:	push t
	ldz pnd8*2
	call PrintFromStringArray
	lrv X1, 0
	rvadd Y1, 9
	pop t
	inc t
	cpi t, 3
	brne pnd11

	;footer
	call PrintBackFooter

	call LcdUpdate

pnd10:	call GetButtonsBlocking
	cpi t, 0x08			;BACK?
	brne pnd10

	ret


	;---

ClearSBusErrors:

	clr t
	sts FrameLost, t
	sts Failsafe, t
	sts DataErrors, t

	cli
	sts SBusDataErrors, t
	sei
	ret


	;---

GetSBusFlags:

	lds t, TimeoutCounter		;RX timeout?
	cpi t, TimeoutLimit
	brlt sbf7

	clr t				;yes, tag S.Bus frame as invalid and refuse arming
	ldi xl, 0x01			;activate the 'Lost Model' alarm via Channel 17
	sts Channel17, xl
	rjmp sbf6

sbf7:	inc t				;no, increase counter and continue
	sts TimeoutCounter, t


	;S.Bus flags (4 bit) are stored in SBusFlags:
	;S.Bus data bits sent:	7654----
	;S.Bus data received:	----4567

	cli
	lds t, SBusFrameValid
	lds xl, SBusFlags
	lds xh, SBusDataErrors
	sei

sbf6:	sts flagSBusFrameValid, t
	tst t				;is S.Bus data frame valid?
	brne sbf5

	ldi t, 2			;no, exit and refuse arming
	rcall SetStatusValue
	ret

sbf5:	lds t, Status			;yes, clear the "No S.Bus data" error, but only if the current value corresponds to an S.Bus error!
	cpi t, 3
	brge sbf4

	andi t, 0x01
	sts Status, t

sbf4:	andi xh, 0x01			;check the data error flag
	sts DataErrors, xh
	tst xh
	breq sbf3

	rcall SetStatusValue1

sbf3:	mov t, xl			;read digital channels
	andi t, 0x01
	sts Channel17, t

	lsr xl
	mov t, xl
	andi t, 0x01
	sts Channel18, t

	lsr xl				;set the 'Frame Lost' flag if one or more S.Bus data frames got lost
	mov t, xl
	andi t, 0x01
	breq sbf2

	sts FrameLost, t
	rcall SetStatusValue1

sbf2:	lsr xl				;set the 'Failsafe' flag if one or more failsafe situations occurred
	andi xl, 0x01
	breq sbf1

	sts Failsafe, xl
	rcall SetStatusValue1
sbf1:	ret


	;---

SetStatusValue1:
	ldi t, 1

SetStatusValue:				;set the 'Status' value, but only if it is zero
	lds xh, Status
	tst xh
	brne ssv10

	sts Status, t
ssv10:	ret
