
.set xoff = 78


SBusStatus:

sbus11:	rcall GetSBusFlags
	lds t, flagSBusFrameValid
	tst t
	brne sbus21

	rcall ShowNoDataDlg		;no data to be displayed
	ret

sbus21:	call LcdClear6x8

	clr t				;print all text labels first

sbus22:	push t
	ldz sbus6*2
	call PrintFromStringArray
	lrv X1, 66
	call PrintColonAndSpace
	lrv X1, 0
	rvadd Y1, 9
	pop t
	inc t
	cpi t, 5
	brne sbus22

	lrv X1, xoff			;channel 17 (DG1)
	lrv Y1, 1
	lds t, Channel17
	ldz onoff*2
	rcall PrintSBusValue

	lds t, Channel18		;channel 18 (DG2)
	ldz onoff*2
	rcall PrintSBusValue

	lds t, Failsafe			;failsafe
	ldz yesno*2
	rcall PrintSBusValue

	lds xl, FrameLoss		;frame loss
	rcall PrintPercentage

	lds xl, FrameLossMax		;logged frame loss
	rcall PrintPercentage

	;footer
	call PrintBackFooter

	call LcdUpdate

	call GetButtons

	cpi t, 0x08			;BACK?
	brne sbus20

	call ReleaseButtons
	rcall ClearSBusErrors
	ret	

sbus20:	rjmp sbus11




sbus1:	.db "S.Bus Ch.17", 0
sbus2:	.db "S.Bus Ch.18", 0
sbus3:	.db "Failsafe", 0, 0
sbus4:	.db "Frame loss", 0, 0
sbus5:	.db "Logged loss", 0

sbus6:	.dw sbus1*2, sbus2*2, sbus3*2, sbus4*2, sbus5*2

pnd1:	.db 60, 58, 71, 58, 0, 0	;the text "DATA" in the mangled 12x16 font

pnd2:	.db "Please supply S.Bus", 0
pnd3:	.db "data to the throttle", 0, 0
pnd4:	.db "input connector.", 0, 0

pnd8:	.dw pnd2*2, pnd3*2, pnd4*2


	;---

PrintSBusValue:

	call PrintFromStringArray
	lrv X1, xoff	
	rvadd Y1, 9
	ret


	;---

PrintPercentage:

	clr xh
	clr yh
	call Print16Signed
	ldi t, '%'
	call PrintChar
	lrv X1, xoff	
	rvadd Y1, 9
	ret


	;---

ShowNoDataDlg:

	call LcdClear12x16

	lrv X1, 22
	ldi t, 67			;the character 'N' in the mangled 12x16 font
	call PrintChar
	ldi t, 68			;the character 'O' in the mangled 12x16 font
	call PrintChar

	lrv X1, 58			;print "DATA"
	ldz pnd1*2
	call PrintString

	lrv FontSelector, f6x8

	lrv X1, 0			;print "Please supply S.Bus data to the throttle input connector."
	lrv Y1, 17
	clr t

pnd11:	push t
	ldz pnd8*2
	call PrintFromStringArray
	lrv X1, 0
	rvadd Y1, 9
	pop t
	inc t
	cpi t, 3
	brne pnd11

	;footer
	call PrintBackFooter

	call LcdUpdate

pnd10:	call GetButtonsBlocking
	cpi t, 0x08			;BACK?
	brne pnd10

	ret


	;---

ClearSBusErrors:

	clr t
	sts FrameLoss, t
	sts FrameLossMax, t
	sts FrameLossCounter, t
	sts FrameCounter, t
	sts Failsafe, t

	lds t, StatusBits		;clear the S.Bus status bits
	andi t, 0x0F
	sts StatusBits, t
	ret


	;---

GetSBusFlags:

	lds t, TimeoutCounter		;RX timeout?
	cpi t, SBusTimeoutLimit
	brlt sbf7

	clr t				;yes, tag S.Bus frame as invalid
	sts flagSBusFrameValid, t
	ser t
	sts flagAlarmOverride, t	;activate the Lost Model alarm
	rjmp sbf6			;exit and set status bit to refuse arming

sbf7:	inc t				;no, increase the timeout counter
	sts TimeoutCounter, t

	cpi t, 1			;is this a new frame?
	brne sbf3

	lds t, FrameCounter		;yes, count new frames only
	inc t
	cpi t, 50
	brne sbf4

	lds t, FrameLossCounter		;check the frame loss counter every 50th frame
	lsl t				;multiply by 2 to get percentage
	sts FrameLoss, t
	lds xl, FrameLossMax
	cp xl, t
	brge sbf8

	sts FrameLossMax, t		;set status bit if frame loss is 15% or more
	cpi t, 15
	brlt sbf8

	setstatusbit CheckSBusStatus

sbf8:	clr t
	sts FrameLossCounter, t

sbf4:	sts FrameCounter, t


	;S.Bus flags (4 bit) are stored in SBusFlags:
	;S.Bus data received:	----4567

sbf3:	cli
	lds xh, SBusFrameValid
	lds xl, SBusFlags
	sei

	sts flagSBusFrameValid, xh
	tst xh				;is S.Bus data frame valid?
	brne sbf5

sbf6:	setstatusbit NoSBusInput	;no, exit and refuse arming
	ret

sbf5:	lds t, StatusBits		;yes, clear the "No S.Bus data" error
	cbr t, NoSBusInput
	sts StatusBits, t

	mov t, xl			;digital channel 17
	andi t, 0x01
	sts Channel17, t

	dec t				;activate alarm when channel 17 is on
	com t
	sts flagAlarmOverride, t

	lsr xl				;digital channel 18
	mov t, xl
	andi t, 0x01
	sts Channel18, t

	lsr xl				;check the 'Frame Lost' flag
	mov t, xl
	andi t, 0x01
	breq sbf2

	lds t, TimeOutCounter		;is this a new frame?
	cpi t, 1
	brne sbf2

	lds t, FrameLossCounter		;yes, increase the frame loss counter
	inc t
	sts FrameLossCounter, t

sbf2:	lsr xl				;set the 'Failsafe' flag if one or more failsafe situations occurred
	andi xl, 0x01
	breq sbf1

	sts Failsafe, xl
	setstatusbit CheckSBusStatus
	ser t
	sts flagAlarmOverride, t	;activate the Lost Model alarm

sbf1:	ret


