


PwmStart:

	;set OCR1A to current time + 0.5ms

	cli
	load xl, tcnt1l	
	load xh, tcnt1h
	sei

	ldi t, low(1250)
	add xl, t
	ldi t, high(1250)
	adc xh, t

	cli
	store ocr1ah, xh
	store ocr1al, xl
	sei

	;set OCR1B to current time + 1.5ms

	ldi t, low(2500)
	add xl, t
	ldi t, high(2500)
	adc xh, t

	cli
	store ocr1bh, xh
	store ocr1bl, xl
	sei


	;turn on OC1a and b interrupt

	;       76543210
	ldi t,0b00000110
	store timsk1, t


	rvsetflagfalse flagPwmEnd


	ret



IsrPwmStart:
	;Generate the rising edge of servo/esc pulses

	load SregSaver, sreg

	lds tt, flagMutePwm
	tst tt
	brmi pwmexit

	sec
	
	lds tt, OutputRateDividerCounter
	dec tt
	brne pwm1
	
		lds tt, OutputRateDivider
		clc	

pwm1:	sts OutputRateDividerCounter, tt
	
	ldi tt, 0xff			;bit pattern for fast and slow update rate
	brcc pwm2
	lds tt, OutputRateBitmask	;bit pattern for fast update rate

pwm2:	lsr tt				;stagger the pin switching to avoid up to 8 pins switching at the same time
	brcc pwm3
	sbi OutputPin1
pwm3:	lsr tt
	brcc pwm4
	sbi OutputPin2
pwm4:	lsr tt
	brcc pwm5
	sbi OutputPin3
pwm5:	lsr tt
	brcc pwm6
	sbi OutputPin4
pwm6:	lsr tt
	brcc pwm7
	sbi OutputPin5
pwm7:	lsr tt
	brcc pwm8
	sbi OutputPin6
pwm8:	lsr tt
	brcc pwm9
	sbi OutputPin7
pwm9:	lsr tt
	brcc pwm12
	sbi OutputPin8 ;<---OBS DEBUG
pwm12:	 

pwmexit:store sreg, SregSaver
	reti





IsrPwmEnd:
	ldi tt, 0xff
	sts flagPwmEnd, tt
	reti





PwmEnd:	b16ldi Temp, 888		;make sure the EscLowLimit is not too high. (hardcoded limit of 20%)
	b16cmp EscLowLimit, Temp
	brlt pwm58
	b16mov EscLowLimit, Temp
pwm58:

	;loop setup

	lrv Index, 0		
	 
	lds t, OutputTypeBitmask
	sts OutputTypeBitmaskCopy, t

	rvflagnot flagInactive, flagArmed	;flagInactive is set to true if outputs should be in inactive state
	;rvflagor flagInactive, flagInactive, flagThrottleZero
	
	;loop body

pwm50:	b16load_array PwmOutput, Out1


	lds t, OutputTypeBitmaskCopy		;ESC or SERVO?
	lsr t
	sts OutputTypeBitmaskCopy, t
	brcc pwm51fix
	rjmp pwm51
pwm51fix:

	;---

	rvbrflagfalse flagInactive, pwm52fix	;SERVO, active or inactive?
	rjmp pwm52
pwm52fix:
	b16load_array Temp, FilteredOut1 	;servo active, apply low pass filter
	b16sub Error, PwmOutput, Temp
	
	b16mul Error, Error, ServoFilter

	b16add PwmOutput, Temp, Error
	b16store_array FilteredOut1, PwmOutput
	
	rjmp pwm55

pwm52:	b16load_array PwmOutput, Offset1	;servo inactive, set to offset value
	rjmp pwm55

	;---

pwm51:	rvbrflagtrue flagInactive, pwm54	;ESC, active or inactive?
	rvbrflagtrue flagThrottleZero, pwm54

	b16cmp PwmOutput, EscLowLimit		;ESC active, limit to EscLowLimit
	brge pwm56
	b16mov PwmOutput, EscLowLimit
pwm56:
	rjmp pwm55

pwm54:	b16clr PwmOutput			;ESC inactive, set to zero 

	;---

pwm55:	b16store_array Out1, PwmOutput


	;loop looper

	rvinc Index
	rvcpi Index, 8
	breq pwm57
	rjmp pwm50
pwm57:

	;scale [0, 4400] to [0, 2500] for the timer
	b16ldi Temp, 0.563

	b16mul Out1, Out1, Temp
	b16mul Out2, Out2, Temp
	b16mul Out3, Out3, Temp
	b16mul Out4, Out4, Temp
	b16mul Out5, Out5, Temp
	b16mul Out6, Out6, Temp
	b16mul Out7, Out7, Temp
	b16mul Out8, Out8, Temp


.def O1L=r0
.def O1H=r1
.def O2L=r2
.def O2H=r3
.def O3L=r4
.def O3H=r5
.def O4L=r6
.def O4H=r7
.def O5L=r8
.def O5H=r17
.def O6L=r18
.def O6H=r19
.def O7L=r20
.def O7H=r21
.def O8L=r22
.def O8H=r23
	
	
	;this part transfers and conditions the OutN values to the 16bit registers ONH:ONL


;call DebugCU		;DEBUG


	b16load Out1
	rcall pwmcond
	mov O1L, xl
	mov O1H, xh

	b16load Out2
	rcall pwmcond
	mov O2L, xl
	mov O2H, xh

	b16load Out3
	rcall pwmcond
	mov O3L, xl
	mov O3H, xh

	b16load Out4
	rcall pwmcond
	mov O4L, xl
	mov O4H, xh

	b16load Out5
	rcall pwmcond
	mov O5L, xl
	mov O5H, xh

	b16load Out6
	rcall pwmcond
	mov O6L, xl
	mov O6H, xh

	b16load Out7
	rcall pwmcond
	mov O7L, xl
	mov O7H, xh

	b16load Out8
	rcall pwmcond
	mov O8L, xl
	mov O8H, xh
		

	;cbi OutputPin8		;OBS DEBUG


	;generate the end of the PWM signal, this part is blocking.

	rvbrflagfalse flagPwmEnd, pwm29
	ldi t, 0				;if IsrPwmEnd is true here, the start of PWM pulse end generation is missed
;	call LogError				;log error
	ret					;and return without generating the end of pwm pulse

pwm29:	rvbrflagfalse flagPwmEnd, pwm29		;wait until IsrPwmEnd has run (flagPwmEnd == true)

	ldi t, 0
	store timsk1, t


	;generate the last 0 to 1ms part of the pwm signal
	ldy 2500

	ldx 0
	store tcnt1h, xh
	store tcnt1l, xl

pwmloop:
	load xl, tcnt1l
	load xh, tcnt1h
	
pwm13:
	cp xl, O1L
	cpc xh, O1H
	brlo pwm14
	cbi OutputPin1
pwm14:
	cp xl, O2L
	cpc xh, O2H
	brlo pwm15
	cbi OutputPin2
pwm15:
	cp xl, O3L
	cpc xh, O3H
	brlo pwm16
	cbi OutputPin3
pwm16:
	cp xl, O4L
	cpc xh, O4H
	brlo pwm17
	cbi OutputPin4
pwm17:
	cp xl, O5L
	cpc xh, O5H
	brlo pwm18
	cbi OutputPin5
pwm18:
	cp xl, O6L
	cpc xh, O6H
	brlo pwm19
	cbi OutputPin6
pwm19:
	cp xl, O7L
	cpc xh, O7H
	brlo pwm20
	cbi OutputPin7
pwm20:
	cp xl, O8L
	cpc xh, O8H
	brlo pwm21
	cbi OutputPin8   ;<___OBS

pwm21:
	cp xl, yl
	cpc xh, yh
	brlo pwmloop

	ret

.undef O1L
.undef O1H
.undef O2L
.undef O2H
.undef O3L
.undef O3H
.undef O4L
.undef O4H
.undef O5L
.undef O5H
.undef O6L
.undef O6H
.undef O7L
.undef O7H
.undef O8L
.undef O8H





pwmcond:
	;asr xh		;divide by 8
	;ror xl
	;asr xh
	;ror xl
	;asr xh
	;ror xl

	ldy 0
	cp  xl, yl
	cpc xh, yh
	brge pwm22	;x < 0 ?
	ldx 0		;yes, set to zero

pwm22:	ldy 2500
	cp  xl, yl
	cpc xh, yh
	brlt pwm23	;x >= 2500 ?
	ldx 2500	;yes, set to 2500

pwm23:	ret







/*
	;       76543210
	ldi t,0b
	store , t
*/
