
IntRoll:
	in SregSaver, sreg

	sbis pind,3			;rising or falling?
	rjmp rx1

	lds tt, tcnt1l			;rising, store the start value
	sts RollStartL, tt
	lds tt, tcnt1h
	sts RollStartH, tt
	
	clr tt
	sts RollDcnt, tt

	out sreg, SregSaver		;exit	
	reti

rx1:	lds tt, tcnt1l			;falling, calculate the pulse length
	lds treg, RollStartL
	sub tt, treg
	sts RollL, tt

	lds tt, tcnt1h
	lds treg, RollStartH
	sbc tt, treg
	sts RollH, tt

	out sreg, SregSaver		;exit	
	reti



IntPitch:
	in SregSaver, sreg

	sbis pind,2			;rising or falling?
	rjmp rx2

	lds tt, tcnt1l			;rising, store the start value
	sts PitchStartL, tt
	lds tt, tcnt1h
	sts PitchStartH, tt

	clr tt
	sts PitchDcnt, tt
	
	out sreg, SregSaver		;exit	
	reti

rx2:	lds tt, tcnt1l			;falling, calculate the pulse length
	lds treg, PitchStartL
	sub tt, treg
	sts PitchL, tt

	lds tt, tcnt1h
	lds treg, PitchStartH
	sbc tt, treg
	sts PitchH, tt

	out sreg, SregSaver		;exit	
	reti



IntThrottle:
	in SregSaver, sreg

	lds tt, flagCppmOn		;CPPM mode?
	tst tt
	brpl rx6
	rjmp cppm

rx6:
	sbis pind,0			;rising or falling?
	rjmp rx3

	lds tt, tcnt1l			;rising, store the start value
	sts ThrottleStartL, tt
	lds tt, tcnt1h
	sts ThrottleStartH, tt
	
	clr tt
	sts ThrottleDcnt, tt

	out sreg, SregSaver		;exit	
	reti

rx3:	lds tt, tcnt1l			;falling, calculate the pulse length
	lds treg, ThrottleStartL
	sub tt, treg
	sts ThrottleL, tt

	lds tt, tcnt1h
	lds treg, ThrottleStartH
	sbc tt, treg
	sts ThrottleH, tt

	out sreg, SregSaver		;exit	
	reti



IntYaw:
	in SregSaver, sreg

	sbis pinb,2			;rising or falling?
	rjmp rx4

	lds tt, tcnt1l			;rising, store the start value
	sts YawStartL, tt
	lds tt, tcnt1h
	sts YawStartH, tt

	clr tt
	sts YawDcnt, tt
	
	out sreg, SregSaver		;exit	
	reti

rx4:	lds tt, tcnt1l			;falling, calculate the pulse length
	lds treg, YawStartL
	sub tt, treg
	sts YawL, tt

	lds tt, tcnt1h
	lds treg, YawStartH
	sbc tt, treg
	sts YawH, tt

	out sreg, SregSaver		;exit	
	reti



IntAux:
	in SregSaver, sreg

	sbis pinb,0			;rising or falling?
	rjmp rx5

	lds tt, tcnt1l			;rising, store the start value
	sts AuxStartL, tt
	lds tt, tcnt1h
	sts AuxStartH, tt

	clr tt
	sts AuxDcnt, tt
	
	out sreg, SregSaver		;exit	
	reti

rx5:	lds tt, tcnt1l			;falling, calculate the pulse length
	lds treg, AuxStartL
	sub tt, treg
	sts AuxL, tt

	lds tt, tcnt1h
	lds treg, AuxStartH
	sbc tt, treg
	sts AuxH, tt

	out sreg, SregSaver		;exit	
	reti


	;--- CPPM ISR ---

cppm:	sbic pind,0			;rising or falling?
	rjmp rx7

	out sreg, SregSaver		;falling, exit	
	reti

rx7:	push xl				;rising, calculate pulse length:
	push xh
	push zl
	push zh
	
	lds xl, tcnt1l			;X = TCNT1 - CppmPulseStart, CppmPulseStart = TCNT1
	lds xh, tcnt1h
	lds zl, CppmPulseStartL
	lds zh, CppmPulseStartH
	sts CppmPulseStartL, xl
	sts CppmPulseStartH, xh
	sub xl, zl
	sbc xh, zh

	brpl rx8			;X = ABS(X)
	ldz 0
	sub zl, xl
	sbc zh, xh
	movw x, z
rx8:	
	ldz 6250			;pulse longer than 2.5ms?
	cp  xl, zl
	cpc xh, zh
	brlo rx11

	ldz CppmChannel1L		;yes, reset cppm sequence and exit
	rjmp rx10

rx11:	lds zl, CppmPulseArrayAddressL	;store channel in channel array.
	lds zh, CppmPulseArrayAddressH

	st z+, xl
	st z+, xh

	ldx CppmChannel9L		;end of array reached?
	cp  zl, xl
	cpc zh, xh
	brlo rx10
	breq rx10

	ldz CppmChannel9L		;yes, limit

rx10:	sts CppmPulseArrayAddressL, zl	;store array pointer
	sts CppmPulseArrayAddressH, zh

	clr tt				;reset timeout counter
	sts CppmTimeoutCounter, tt

	pop zh
	pop zl
	pop xh
	pop xl

	out sreg, SregSaver		;exit	
	reti


	;---


GetRxChannels:

	;--- Roll ---

	rvbrflagfalse flagCppmOn, rx12

	ldz eeCppmRoll
	rcall GetCppmChannel
	rjmp rx13


rx12:	cli				;get roll channel value
	lds xl, RollL
	lds xh, RollH
	sei

rx13:	rcall gt1m1			;sanitize
	clr yh				;store in register
	b16store RxRoll

	
	;--- Pitch

	rvbrflagfalse flagCppmOn, rx14

	ldz eeCppmPitch
	rcall GetCppmChannel
	rjmp rx15

rx14:	cli				;get Pitch channel value
	lds xl, PitchL
	lds xh, PitchH
	sei

rx15:	rcall gt1m1			;sanitize
	clr yh				;store in register
	b16store RxPitch


	;--- Throttle ---

	rvbrflagfalse flagCppmOn, rx16

	ldz eeCppmThrottle
	rcall GetCppmChannel
	rjmp rx17

rx16:	cli				;get Throttle channel value
	lds xl, ThrottleL
	lds xh, ThrottleH
	sei

rx17:	rvsetflagfalse flagThrottleZero

	rcall Xabs			;X = ABS(X)

	ldz 2875			;X = X - 2875 (1.15ms)
	sub xl, zl
	sbc xh, zh

	ldz 0				;X < 0 ?
	cp  xl, zl
	cpc xh, zh
	brge gt8m8

	rjmp rx30			;yes, set to zero

gt8m8:	ldz 3125			;X > 3125? (1.25ms)
	cp  xl, zl
	cpc xh, zh
	brlt gt7m2

rx30:	ldx 0				;Yes, set to zero
	rvsetflagtrue flagThrottleZero

gt7m2:	clr yh				;store in register
	b16store RxThrottle


	;--- Yaw ---

	rvbrflagfalse flagCppmOn, rx18

	ldz eeCppmYaw
	rcall GetCppmChannel
	rjmp rx19

rx18:	cli				;get Yaw channel value
	lds xl, YawL
	lds xh, YawH
	sei

rx19:	rcall gt1m1			;sanitize

	clr yh				;store in register
	b16store RxYaw

	
	;--- AUX ---

	rvbrflagfalse flagCppmOn, rx20

	ldz eeCppmAux
	rcall GetCppmChannel
	rjmp rx21

rx20:	cli				;get Aux channel value
	lds xl, AuxL
	lds xh, AuxH
	sei

rx21:	rcall gt1m1			;sanitize

	rvsetflagfalse flagAuxOn
	tst xh
	brmi gt9m3
	breq gt9m3
	rvsetflagtrue flagAuxOn
	
gt9m3:	clr yh				;store in register
	b16store RxAux


	;--- CamPitch ---

	rvbrflagfalse flagCppmOn, rxcampitch20

	ldz eeCppmCamPitch
	rcall GetCppmChannel
	rjmp rxcampitch21

rxcampitch20:			;no input for this, use middle
	ldx 3750

rxcampitch21:	rcall gt1m1			;sanitize

	clr yh				;store in register
	b16store RxCamPitch


	;--- CamRoll ---

	rvbrflagfalse flagCppmOn, rxcamroll20

	ldz eeCppmCamRoll
	rcall GetCppmChannel
	rjmp rxcamroll21

rxcamroll20:			;no input for this, use middle
	ldx 3750

rxcamroll21:	rcall gt1m1			;sanitize

	clr yh				;store in register
	b16store RxCamRoll


	;--- Check rx ---


	rvsetflagtrue flagRollValid	
	rvsetflagtrue flagPitchValid	
	rvsetflagtrue flagThrottleValid	
	rvsetflagtrue flagYawValid	
	rvsetflagtrue flagAuxValid	

	rvbrflagtrue flagCppmOn, rx22
	rjmp rx24

rx22:	rvinc CppmTimeoutCounter			;CPPM timeout?
	rvcp CppmTimeoutCounter, RxTimeoutLimit
	brlo rx23			
	rvdec CppmTimeoutCounter
	rvsetflagfalse flagRollValid			;yes, set flags to false and values to zero
	rvsetflagfalse flagPitchValid	
	rvsetflagfalse flagThrottleValid	
	rvsetflagfalse flagYawValid	
	rvsetflagfalse flagAuxValid	
	b16clr RxRoll
	b16clr RxPitch
	b16clr RxThrottle
	rvsetflagtrue flagThrottleZero
	b16clr RxYaw
	b16clr RxAux
	rvsetflagfalse flagAuxOn

rx23:	ret


rx24:	rvinc RollDcnt					;signal timed out?
	rvcp RollDcnt, RxTimeoutLimit
	brlo rx25			
	rvdec RollDcnt
	rvsetflagfalse flagRollValid			;Yes, set flag to false and set value to 0
	b16clr RxRoll

rx25:	rvinc PitchDcnt					;signal timed out?
	rvcp PitchDcnt, RxTimeoutLimit
	brlo rx26			
	rvdec PitchDcnt
	rvsetflagfalse flagPitchValid			;Yes, set flag to false and set value to 0
	b16clr RxPitch

rx26:	rvinc ThrottleDcnt				;signal timed out?
	rvcp ThrottleDcnt, RxTimeoutLimit
	brlo rx27			
	rvdec ThrottleDcnt
	rvsetflagfalse flagThrottleValid		;Yes, set flag to false and set value to 0
	b16clr RxThrottle
	rvsetflagtrue flagThrottleZero

rx27:	rvinc YawDcnt					;signal timed out?
	rvcp YawDcnt, RxTimeoutLimit
	brlo rx28			
	rvdec YawDcnt
	rvsetflagfalse flagYawValid			;Yes, set flag to false and set value to 0
	b16clr RxYaw

rx28:	rvinc AuxDcnt					;signal timed out?
	rvcp AuxDcnt, RxTimeoutLimit
	brlo rx29			
	rvdec AuxDcnt
	rvsetflagfalse flagAuxValid			;Yes, set flag to false and set value to 0
	b16clr RxAux
	rvsetflagfalse flagAuxOn

rx29:	ret


	;----

GetCppmChannel:
	call ReadEeprom
	dec t
	mov r0, t
	ldzarray CppmChannel1L, 2, r0
	cli
	ld xl, z+
	ld xh, z
	sei

	rvbrflagfalse flagSumMode, GetCppmChannelEnd
	;SUMD mode: adapt the range to the CPPM range ([8800; 15200] -> [2500; 5000])
	;x = (x >> 1) - (x >> 3) - 750   which is x = ( x / 2.66 ) - 750 => ([8800; 15200] -> [2550; 4950])
	push yl
	push yh
	lsr xh
	ror xl
	mov yh, xh
	mov yl, xl
	lsr xh
	ror xl
	lsr xh
	ror xl
	sub yl, xl
	sbc yh, xh
	mov xl, yl
	mov xh, yh
	ldi yh, 2
	ldi yl, 238
	sub xl, yl
	sbc xh, yh
	pop yh
	pop yl

GetCppmChannelEnd:
	ret

SumDInit:
	; Set baud rate to 115200
	clr t
	sts UBRR0H, t
	ldi t, 10
	sts UBRR0L, t

	; Set frame format: 8data, 1stop bit
	ldi t, (3<<UCSZ00)
	sts UCSR0C, t

	; Disable Transmitter, Enable Receiver and RX Complete Interrupt
	lds t, UCSR0B
	clt
	bld t, TXEN0
	set
	bld t, RXCIE0
	bld t, RXEN0
	sts UCSR0B, t

	clr t
	sts SumDCounter, t
	sts RxFailsafe, t

	ret

IsrSumDReceive:
	in SregSaver, sreg
	push yl
	push yh

	; Get received data from buffer
	lds tt, UDR0

	lds yl, SumDCounter
	inc yl
	sts SumDCounter, yl
	dec yl

	cpi yl, 0
	breq SumD1		;SumDCounter == 0 (check first sync byte)
	cpi yl, 2
	breq SumD2		;SumDCounter == 2 (Length)
	brlo SumD1a		;SumDCounter < 2 (check second sync byte)
	rjmp SumD4		;SumDCounter > 2 (data)

SumD1:
	cpi tt, 0xA8
	breq SumD3

	;first sync char not yet received
	clr yl
	sts SumDCounter, yl
	rjmp SumD3

SumD1a:
	cpi tt, 0x01
	brne SumD1b
	;normal status, no failsafe
	clr tt
	sts RxFailsafe, tt
	rjmp SumD3

SumD1b:
	cpi tt, 0x81
	brne SumD1c
	;failsafe mode
	ser tt
	sts RxFailsafe, tt
	rjmp SumD3

SumD1c:
	;second sync char invalid, check if it is the first sync byte
	ldi yl, 1
	sts SumDCounter, yl
	rjmp SumD1

SumD2:
	sts SumDLength, tt

SumD3:
	pop yh
	pop yl
	out sreg, SregSaver
	reti

SumD3a:
	clr tt				;reset timeout counter and sumd counter
	sts CppmTimeoutCounter, tt
	sts SumDCounter, tt
	rjmp SumD3

SumD4:
	subi yl, 3
	lds yh, SumDLength
	lsl yh
	cp yl, yh
	brge SumD3a		;Length has been reached, checksum is ignored (btw it is CRC-CCITT XModem)...

	sbrc yl, 0
	rjmp SumD5

	;high byte of data, store to SumDTemp and exit
	sts SumDTemp, tt
	rjmp SumD3

SumD5:
	;low byte of data, store together with SumDTemp
	push xl
	push xh
	push zl
	push zh

	clr yh
	ldz CppmChannel1L
	add zl, yl
	adc zh, yh

	ldx CppmChannel9H		;end of array reached?
	cp  xl, zl
	cpc xh, zh
	brlo SumD6

	;mov xl, tt
	lds xh, SumDTemp
	;mov xh, tt

	st z, xh
	subi zl, 1
	sbci zh, 0
	st z, tt

SumD6:
	pop zh
	pop zl
	pop xh
	pop xl
	pop yh
	pop yl

	out sreg, SregSaver
	reti


gt1m1:	rcall Xabs	;X = ABS(X)

	ldz 3750	;X = X - 3750 (1.5ms)
	sub xl, zl
	sbc xh, zh

	ldz -1750	;X < -1750?  (0.7ms)
	cp  xl, zl
	cpc xh, zh
	brlt gt1m2

	ldz 1750	;X > 1750?
	cp  xl, zl
	cpc xh, zh
	brge gt1m2

	ret		;No, exit

gt1m2:	ldx 0		;Yes, set to zero
	ret





Xabs:	tst xh		;X = ABS(X)
	brpl xa1

	com xl
	com xh
	
	ldi t,1
	add xl,t
	clr t
	adc xh,t

xa1:	ret




