/*
 * Decompiled with CFR 0.152.
 */
package avr8_burn_o_mat;

public class AvrdudeProgrammer
implements Comparable<AvrdudeProgrammer> {
    private String m_id;
    private String m_type;
    private String m_desc;

    public AvrdudeProgrammer(String id, String type, String desc) {
        assert (id != null);
        assert (type != null);
        assert (desc != null);
        this.m_id = id;
        this.m_type = type;
        this.m_desc = desc;
    }

    public String toString() {
        return String.format("%s (%s)", this.getShortDesc(), this.getId());
    }

    private String getShortDesc() {
        String desc = this.getDesc();
        if (desc.length() > 60) {
            desc = desc.substring(0, 60);
        }
        return desc;
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        try {
            AvrdudeProgrammer p = (AvrdudeProgrammer)o;
            return this.m_id.equals(p.m_id) && this.m_type.equals(p.m_type) && this.m_desc.equals(p.m_desc);
        }
        catch (ClassCastException ex1) {
            try {
                String s = (String)o;
                return s.equals(this.getId());
            }
            catch (ClassCastException ex2) {
                return false;
            }
        }
    }

    @Override
    public int compareTo(AvrdudeProgrammer p) {
        return this.getId().compareTo(p.getId());
    }

    public String getId() {
        return this.m_id;
    }

    public String getType() {
        return this.m_type;
    }

    public String getDesc() {
        return this.m_desc;
    }

    public boolean isSerial() {
        return this.m_type.trim().equals("serbb");
    }

    public boolean isParallel() {
        return this.m_type.trim().equals("par");
    }
}

