/*
 * Decompiled with CFR 0.152.
 */
package de.lazyzero.kkMulticopterFlashTool.gui;

import avr8_burn_o_mat.AVR;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import de.lazyzero.kkMulticopterFlashTool.KKMulticopterFlashTool;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.TitledBorder;
import lu.tudor.santec.i18n.Translatrix;

public class ControllerPanel
extends JPanel
implements ActionListener {
    private static final long serialVersionUID = 1L;
    public static final String CONTROLLER_CHANGED = "controllerChanged";
    private JComboBox controllerCombobox;
    private AVR controller;
    private Vector<AVR> controllers = new Vector();
    private KKMulticopterFlashTool parent;
    private CellConstraints cc;
    private JLabel controllerLabel;
    private JCheckBox forceCheckbox;

    public ControllerPanel(KKMulticopterFlashTool parent, Vector<AVR> controllers) {
        this.parent = parent;
        this.controllers = controllers;
        this.init();
    }

    private void init() {
        this.cc = new CellConstraints();
        String panelColumns = "pref,3dlu,fill:pref, 3dlu, pref";
        String panelRows = "pref";
        FormLayout panelLayout = new FormLayout(panelColumns, panelRows);
        this.setLayout((LayoutManager)panelLayout);
        this.setBorder(new TitledBorder(Translatrix._("controller.settings")));
        this.controllerLabel = new JLabel(Translatrix._("controller"));
        this.controllerCombobox = new JComboBox<AVR>(this.controllers);
        this.controllerCombobox.setSelectedIndex(0);
        this.controllerCombobox.setToolTipText(Translatrix._("controller.tooltip"));
        this.controller = (AVR)this.controllerCombobox.getSelectedItem();
        this.parent.setController(this.controller);
        this.controllerCombobox.addActionListener(this);
        this.forceCheckbox = new JCheckBox(Translatrix._("controller.force"), false);
        this.forceCheckbox.addActionListener(this);
        this.add((Component)this.controllerLabel, this.cc.xy(1, 1));
        this.add((Component)this.controllerCombobox, this.cc.xy(3, 1));
    }

    @Override
    public void actionPerformed(ActionEvent action) {
        if (action.getSource().equals(this.controllerCombobox)) {
            this.controller = (AVR)this.controllerCombobox.getSelectedItem();
            this.parent.setController(this.controller);
            System.out.println("Controller switched to: " + this.controller.toString());
            this.parent.firePropertyChange(CONTROLLER_CHANGED, 0L, 1L);
        }
        if (action.getSource().equals(this.forceCheckbox)) {
            this.parent.setForceFlashing(this.forceCheckbox.isSelected());
        }
    }

    public void setController(String name) {
        for (AVR avr : this.controllers) {
            if (!avr.getName().equals(name)) continue;
            this.controller = avr;
            this.parent.setController(this.controller);
            this.controllerCombobox.setSelectedItem(this.controller);
            this.parent.firePropertyChange(CONTROLLER_CHANGED, 0L, 1L);
        }
    }
}

