/*
 * Decompiled with CFR 0.152.
 */
package de.lazyzero.kkMulticopterFlashTool.utils;

import de.lazyzero.kkMulticopterFlashTool.KKMulticopterFlashTool;
import de.lazyzero.kkMulticopterFlashTool.utils.FileCorruptException;
import de.lazyzero.kkMulticopterFlashTool.utils.MD5;
import de.lazyzero.kkMulticopterFlashTool.utils.SVN;
import de.lazyzero.kkMulticopterFlashTool.utils.Zip;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Firmware {
    public static final int POT = 1;
    public static final int LCD = 2;
    public static final int PIEZO = 4;
    public static final int MEMS = 8;
    public static final int ACC = 16;
    public static final int CPPM = 32;
    public static final int LVA = 64;
    public static final int TARGET_KK = 0;
    public static final int TARGET_ESC = 1;
    public static final int TARGET_OPENAERO = 3;
    public static final int TARGET_CLOSD = 4;
    public static final int TARGET_RX3S = 5;
    private File file;
    private File eepromFile;
    private String version;
    private String author;
    private String name;
    private String controller;
    private String additionalOptions;
    private URL url;
    private String md5Calculated;
    private String md5;
    private String server;
    private URL zipURL;
    private URL commenturl;
    private String svnUrl;
    private String svnName;
    private int features;
    private int target = 0;
    private String versionName;
    private Logger logger = KKMulticopterFlashTool.getLogger();
    private String fileName;
    private URL eepromUrl;
    private URL eepromZipUrl;
    private String svnEEpromUrl;
    private String svnEEpromName;
    private String eepromMD5;
    private String eepromMD5Calculated;
    private boolean isDeprecated = false;

    public Firmware() {
    }

    public Firmware(File firmwareFile) {
        this.file = firmwareFile;
        try {
            System.out.println(this.getFile().getAbsolutePath());
        }
        catch (FileCorruptException e) {
            e.printStackTrace();
        }
    }

    public Firmware(URL firmwareURL) throws NullPointerException {
        if (firmwareURL != null) {
            this.url = firmwareURL;
        }
    }

    public URL getFileURL() {
        return this.url;
    }

    public URL getZipURL() {
        return this.zipURL;
    }

    public File getFile() throws FileCorruptException {
        if (KKMulticopterFlashTool.isOfflineMode()) {
            if (this.zipURL != null) {
                String filename = null;
                String tmpdir = null;
                String urlPath = this.url.getPath();
                filename = urlPath.substring(urlPath.lastIndexOf("/") + 1);
                System.out.println("Download file: " + filename);
                tmpdir = KKMulticopterFlashTool.getTempFolder();
                File tmpFile = new File(String.valueOf(tmpdir) + filename);
                File fExtract = new File(this.url.toString().substring(7).trim());
                this.file = Zip.unzip(tmpFile, fExtract);
                this.md5Calculated = MD5.getMD5(this.file);
            } else if (this.url != null) {
                String filename = null;
                String tmpdir = null;
                String urlPath = this.url.getPath();
                filename = urlPath.substring(urlPath.lastIndexOf("/") + 1);
                System.out.println("Load file from temp folder: " + filename);
                tmpdir = KKMulticopterFlashTool.getTempFolder();
                this.file = new File(String.valueOf(tmpdir) + filename);
                this.md5Calculated = MD5.getMD5(this.file);
                System.out.println(this.md5Calculated);
            } else if (this.eepromZipUrl != null) {
                String filename = null;
                String tmpdir = null;
                String urlPath = this.eepromUrl.getPath();
                filename = urlPath.substring(urlPath.lastIndexOf("/") + 1);
                System.out.println("Download file: " + filename);
                tmpdir = KKMulticopterFlashTool.getTempFolder();
                File tmpFile = new File(String.valueOf(tmpdir) + filename);
                File fExtract = new File(this.url.toString().substring(7).trim());
                this.eepromFile = Zip.unzip(tmpFile, fExtract);
                this.eepromMD5Calculated = MD5.getMD5(this.eepromFile);
            } else if (this.eepromUrl != null) {
                String filename = null;
                String tmpdir = null;
                String urlPath = this.eepromUrl.getPath();
                filename = urlPath.substring(urlPath.lastIndexOf("/") + 1);
                System.out.println("Load file from temp folder: " + filename);
                tmpdir = KKMulticopterFlashTool.getTempFolder();
                this.eepromFile = new File(String.valueOf(tmpdir) + filename);
                this.eepromMD5Calculated = MD5.getMD5(this.eepromFile);
                System.out.println(this.eepromMD5Calculated);
            }
        } else if (this.zipURL != null) {
            File f = this.downloadFile(this.zipURL);
            File fExtract = new File(this.url.toString().substring(7).trim());
            this.file = Zip.unzip(f, fExtract);
            this.md5Calculated = MD5.getMD5(this.file);
        } else if (this.svnUrl != null) {
            System.out.println("debug svn: " + this.svnUrl.toString());
            try {
                SVN svn = new SVN(this.svnUrl.toString(), this.svnName);
                this.file = svn.getFile();
                this.md5 = svn.getFileMD5();
                this.md5Calculated = MD5.getMD5(this.file);
                this.logger.log(Level.INFO, "MD5 of SVN: " + this.md5 + " MD5 calculated from file: " + this.md5Calculated);
            }
            catch (Exception e) {
                this.logger.log(Level.SEVERE, "Problem during SVN action");
                e.printStackTrace();
                throw new FileCorruptException();
            }
        } else if (this.url != null) {
            this.file = this.downloadFirmware(this.url);
            this.md5Calculated = MD5.getMD5(this.file);
            System.out.println(this.md5Calculated);
        } else if (this.eepromZipUrl != null) {
            File f = this.downloadFile(this.eepromZipUrl);
            File fExtract = new File(this.eepromUrl.toString().substring(7).trim());
            this.eepromFile = Zip.unzip(f, fExtract);
            this.eepromMD5Calculated = MD5.getMD5(this.eepromFile);
        } else if (this.svnEEpromUrl != null) {
            System.out.println("debug svn: " + this.svnEEpromUrl.toString());
            try {
                SVN svn = new SVN(this.svnEEpromUrl.toString(), this.svnEEpromName);
                this.eepromFile = svn.getFile();
                this.eepromMD5 = svn.getFileMD5();
                this.eepromMD5Calculated = MD5.getMD5(this.eepromFile);
                this.logger.log(Level.INFO, "MD5 of SVN: " + this.eepromMD5 + " MD5 calculated from EEPROM file: " + this.eepromMD5Calculated);
            }
            catch (Exception e) {
                this.logger.log(Level.SEVERE, "Problem during SVN action");
                e.printStackTrace();
                throw new FileCorruptException();
            }
        } else if (this.eepromUrl != null) {
            this.eepromFile = this.downloadFirmware(this.eepromUrl);
            this.eepromMD5Calculated = MD5.getMD5(this.eepromFile);
            System.out.println(this.eepromMD5Calculated);
        }
        if (this.md5 != null && !this.md5.equals("")) {
            this.logger.log(Level.INFO, "check MD5");
            this.logger.log(Level.INFO, "MD5: " + this.md5 + " MD5 calculated from file: " + this.md5Calculated);
            if (!this.md5.equals(this.md5Calculated)) {
                this.logger.log(Level.SEVERE, "The file is corrupted.");
                throw new FileCorruptException();
            }
            this.logger.log(Level.INFO, "File is okay.");
        } else {
            this.logger.log(Level.INFO, "check MD5: no MD5 available. Check aborted.");
        }
        if (this.eepromMD5 != null && !this.eepromMD5.equals("")) {
            this.logger.log(Level.INFO, "check EEPROM MD5");
            if (!this.eepromMD5.equals(this.eepromMD5Calculated)) {
                this.logger.log(Level.SEVERE, "The EEPROM file is corrupted.");
                throw new FileCorruptException();
            }
            this.logger.log(Level.INFO, "EEPROM File is okay.");
        } else {
            this.logger.log(Level.INFO, "check EEPROM MD5: no MD5 available. Check aborted.");
        }
        return this.file;
    }

    private File downloadFile(URL url) {
        String filename = null;
        String tmpdir = null;
        boolean forceReload = false;
        String urlPath = url.getPath();
        filename = urlPath.substring(urlPath.lastIndexOf("/") + 1).trim();
        System.out.println("Download file: " + filename);
        tmpdir = KKMulticopterFlashTool.getTempFolder();
        filename = String.valueOf(tmpdir) + filename;
        File tmpFile = new File(filename);
        if (filename.endsWith("tgy-daily.zip")) {
            forceReload = true;
            System.out.println("force reload");
        }
        if (new File(tmpdir).mkdir()) {
            System.out.println("tmpdir created");
        }
        if (!tmpFile.exists() || forceReload) {
            try {
                BufferedInputStream in = new BufferedInputStream(url.openStream());
                FileOutputStream fos = new FileOutputStream(tmpFile);
                BufferedOutputStream bout = new BufferedOutputStream(fos, 1024);
                byte[] data = new byte[1024];
                int x = 0;
                while ((x = in.read(data, 0, 1024)) >= 0) {
                    bout.write(data, 0, x);
                }
                bout.close();
                in.close();
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        } else {
            System.out.println("skip download. File already loaded.");
        }
        System.out.println("Download finished: " + filename);
        return tmpFile;
    }

    private File downloadFirmware(URL firmwareURL) {
        String urlPath = firmwareURL.getPath();
        String filename = urlPath.substring(urlPath.lastIndexOf("/") + 1);
        System.out.println("Download file: " + filename);
        String tmpdir = KKMulticopterFlashTool.getTempFolder();
        filename = String.valueOf(tmpdir) + filename;
        File tmpFile = new File(filename);
        if (new File(tmpdir).mkdir()) {
            System.out.println("tmpdir created");
        }
        if (!tmpFile.exists()) {
            try {
                BufferedInputStream in = new BufferedInputStream(firmwareURL.openStream());
                FileOutputStream fos = new FileOutputStream(tmpFile);
                BufferedOutputStream bout = new BufferedOutputStream(fos, 1024);
                byte[] data = new byte[1024];
                int x = 0;
                while ((x = in.read(data, 0, 1024)) >= 0) {
                    bout.write(data, 0, x);
                }
                bout.close();
                in.close();
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        } else {
            System.out.println("skip download. File already loaded.");
        }
        System.out.println("Download finished: " + filename);
        return tmpFile;
    }

    public String toString() {
        return String.valueOf(this.name) + " ( V" + this.version + " [" + this.controller + "]" + " " + this.author + " )";
    }

    public String toString2() {
        return String.valueOf(this.name) + this.version + this.author;
    }

    public String toHTMLString() {
        return "<html>" + this.name + " (V" + this.version + " [" + this.controller + "])" + "<br>" + this.author;
    }

    public String getController() {
        return this.controller;
    }

    public URL getCommentURL() {
        return this.commenturl;
    }

    public boolean hasCommentURL() {
        System.out.println(this.commenturl);
        return this.commenturl != null;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public void setAuthor(String author) {
        this.author = author;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public void setController(String controller) {
        this.controller = controller;
    }

    public void setMD5(String md5) {
        this.md5 = md5;
    }

    public String getMD5() {
        return this.md5;
    }

    public void setZipURL(URL zipurl) {
        this.zipURL = zipurl;
    }

    public void setCommentURL(URL commenturl) {
        this.commenturl = commenturl;
    }

    public static void main(String[] args) {
        Firmware f = null;
        try {
            f = new Firmware();
            File ff = f.downloadFirmware(new URL("http://www.kkmulticopter.kr/multicopter/firmware/XXcontrol_KR_DualCopter_v1_5.hex"));
            MD5.getMD5(ff);
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
    }

    public static Vector<Firmware> getOfflineAvailableFirmwares(Vector<Firmware> inputFirmwares) {
        Vector<Firmware> firmwares = new Vector<Firmware>();
        String tmpFolder = KKMulticopterFlashTool.getTempFolder();
        for (Firmware firmware : inputFirmwares) {
            String filename;
            String urlPath;
            if (firmware.zipURL != null) {
                urlPath = firmware.zipURL.getPath();
                filename = urlPath.substring(urlPath.lastIndexOf("/") + 1);
                if (!new File(String.valueOf(tmpFolder) + filename).exists()) continue;
                firmwares.add(firmware);
                continue;
            }
            if (firmware.url == null) continue;
            urlPath = firmware.url.getPath();
            filename = urlPath.substring(urlPath.lastIndexOf("/") + 1);
            if (!new File(String.valueOf(tmpFolder) + filename).exists()) continue;
            firmwares.add(firmware);
        }
        return firmwares;
    }

    public static Vector<String> getCategories(Vector<Firmware> firmwares) {
        Vector<String> firmwareTyps = new Vector<String>();
        Enumeration<Firmware> en = firmwares.elements();
        while (en.hasMoreElements()) {
            Firmware firmware = en.nextElement();
            if (firmwareTyps.contains(firmware.getName())) continue;
            firmwareTyps.add(firmware.getName());
        }
        return firmwareTyps;
    }

    public static HashMap<String, Boolean> getCategoriesBooleanHashMap(Vector<Firmware> firmwares) {
        HashMap<String, Boolean> firmwareTyps = new HashMap<String, Boolean>();
        Enumeration<Firmware> en = firmwares.elements();
        while (en.hasMoreElements()) {
            Firmware firmware = en.nextElement();
            if (firmwareTyps.containsKey(firmware.getName())) continue;
            firmwareTyps.put(firmware.getName(), false);
        }
        return firmwareTyps;
    }

    public static Vector<Firmware> filter(String category, Vector<Firmware> firmwares) {
        Vector<Firmware> f = new Vector<Firmware>();
        for (Firmware firmware : firmwares) {
            if (!category.toString().equals(firmware.getName())) continue;
            f.add(firmware);
        }
        return f;
    }

    public void setAdditionalOptions(String additionalOptions) {
        this.additionalOptions = additionalOptions;
    }

    public String getAdditionalOptions() {
        return this.additionalOptions;
    }

    public void setFeatures(int features) {
        this.features = features;
    }

    public int getFeatures() {
        return this.features;
    }

    public String getServer() {
        return this.server;
    }

    public void setServer(String server) {
        this.server = server;
    }

    public void setTargetPlatform(int target) {
        this.target = target;
    }

    public int getTarget() {
        return this.target;
    }

    public String getAuthor() {
        return this.author;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersionName(String versionName) {
        this.versionName = versionName;
    }

    public String getVersionName() {
        return this.versionName;
    }

    public String getSVN() {
        return this.svnUrl;
    }

    public void setSVN(String svnUrl) {
        this.svnUrl = svnUrl;
    }

    public String getSVNname() {
        return this.svnName;
    }

    public void setSVNname(String svnName) {
        this.svnName = svnName;
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName.substring(fileName.lastIndexOf(47) + 1);
    }

    public void setEEpromURL(URL eepromUrl) {
        this.eepromUrl = eepromUrl;
    }

    public void setEEpromZipURL(URL eepromZipUrl) {
        this.eepromZipUrl = eepromZipUrl;
    }

    public void setEEpromSVN(String svnEEpromUrl) {
        this.svnEEpromUrl = svnEEpromUrl;
    }

    public void setEEpromMD5(String md5) {
        this.eepromMD5 = md5;
    }

    public void setEEpromSVNname(String svnEEpromName) {
        this.svnEEpromName = svnEEpromName;
    }

    public void setDeprecated(boolean isDeprecated) {
        this.isDeprecated = isDeprecated;
    }

    public boolean isDeprecated() {
        return this.isDeprecated;
    }
}

