/*
 * Decompiled with CFR 0.152.
 */
package de.lazyzero.kkMulticopterFlashTool.utils;

import de.lazyzero.kkMulticopterFlashTool.KKMulticopterFlashTool;
import gnu.io.CommPortIdentifier;
import java.util.Enumeration;
import java.util.Vector;

public class PortScanner {
    public static Vector<String> listProgrammerPorts() {
        Vector<String> ports = new Vector<String>();
        ports.add("usb");
        ports.addAll(PortScanner.listSerialPorts());
        ports.addAll(PortScanner.listParallelPorts());
        return ports;
    }

    public static Vector<String> listSerialPorts() {
        Vector<String> ports = new Vector<String>();
        if (KKMulticopterFlashTool.ENABLE_PORT_CHECK) {
            Enumeration portEnum = CommPortIdentifier.getPortIdentifiers();
            while (portEnum.hasMoreElements()) {
                CommPortIdentifier portIdentifier = (CommPortIdentifier)portEnum.nextElement();
                if (portIdentifier.getPortType() != 1) continue;
                if (System.getProperty("os.name").toLowerCase().contains("mac")) {
                    if (!portIdentifier.getName().contains("cu")) continue;
                    ports.add(portIdentifier.getName());
                    continue;
                }
                ports.add(portIdentifier.getName());
            }
        }
        return ports;
    }

    public static Vector<String> listParallelPorts() {
        Vector<String> ports = new Vector<String>();
        if (KKMulticopterFlashTool.ENABLE_PORT_CHECK) {
            Enumeration portEnum = CommPortIdentifier.getPortIdentifiers();
            while (portEnum.hasMoreElements()) {
                CommPortIdentifier portIdentifier = (CommPortIdentifier)portEnum.nextElement();
                if (portIdentifier.getPortType() != 2) continue;
                if (System.getProperty("os.name").toLowerCase().contains("windows")) {
                    ports.add(portIdentifier.getName().toLowerCase());
                    continue;
                }
                ports.add(portIdentifier.getName());
            }
        }
        return ports;
    }
}

