/*
 * Decompiled with CFR 0.152.
 */
package org.concord.swing;

import java.awt.Component;
import java.util.HashMap;
import java.util.Map;
import org.concord.swing.ComponentFramework;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class DefaultComponentFramework
implements ComponentFramework {
    protected Map managerMap = new HashMap();
    protected ComponentFramework.Manager defaultManager = new DefaultManager();

    @Override
    public Component loadComponent(Node xmlNode) {
        NamedNodeMap xmlAttributes = xmlNode.getAttributes();
        Node attributeNode = xmlAttributes.getNamedItem("manager");
        String managerClassName = attributeNode.getNodeValue();
        ComponentFramework.Manager manager = this.registerManager(managerClassName);
        Component component = manager.loadComponent(xmlNode);
        manager.registerComponent(component);
        return component;
    }

    @Override
    public Component loadComponent(Node xmlNode, ComponentFramework.Manager manager) {
        return manager.loadComponent(xmlNode);
    }

    @Override
    public Node saveComponent(Document document, Component component) {
        this.defaultManager.registerComponent(component);
        return this.defaultManager.saveComponent(document, component);
    }

    @Override
    public Node saveComponent(Document document, Component component, ComponentFramework.Manager manager) {
        manager.registerComponent(component);
        return manager.saveComponent(document, component);
    }

    @Override
    public Object getSchema(Class objectClass) {
        return null;
    }

    public ComponentFramework.Manager registerManager(String managerClassName) {
        try {
            Class<?> managerClass = Class.forName(managerClassName);
            return this.registerManager(managerClass);
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public ComponentFramework.Manager registerManager(Class managerClass) {
        try {
            ComponentFramework.Manager manager = (ComponentFramework.Manager)this.managerMap.get(managerClass.getName());
            if (manager == null) {
                manager = (ComponentFramework.Manager)managerClass.newInstance();
                this.managerMap.put(managerClass.getName(), manager);
            }
            return manager;
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        return null;
    }

    public class DefaultManager
    implements ComponentFramework.Manager {
        @Override
        public Component loadComponent(Node xmlNode) {
            NamedNodeMap xmlAttributes = xmlNode.getAttributes();
            Node attributeNode = xmlAttributes.getNamedItem("class");
            String className = attributeNode.getNodeValue();
            try {
                Class<?> componentClass = Class.forName(className);
                Component component = (Component)componentClass.newInstance();
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
            catch (InstantiationException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            return null;
        }

        @Override
        public Node saveComponent(Document document, Component component) {
            return null;
        }

        @Override
        public boolean registerComponent(Component component) {
            return false;
        }
    }
}

