/*
 * Decompiled with CFR 0.152.
 */
package org.concord.swing;

import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.JTextField;

public class FormattedText
extends JTextField {
    public static final int ONLY_INTEGER = 0;
    public static final int ONLY_DOUBLE = 1;
    public static final int ONLY_STRING = 2;
    private int inputMode;
    private int intMax = Integer.MAX_VALUE;
    private int intMin;
    private int intValue = this.intMin = Integer.MIN_VALUE;
    private double dbMin = Double.NEGATIVE_INFINITY;
    private double dbMax = Double.POSITIVE_INFINITY;
    private double dbValue = this.dbMin;
    private String strValue = "";
    private String currentText;

    public FormattedText() {
        this.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
            }

            @Override
            public void keyTyped(KeyEvent evt) {
            }

            @Override
            public void keyReleased(KeyEvent evt) {
                switch (FormattedText.this.inputMode) {
                    case 0: {
                        String oldIntText = "" + FormattedText.this.intValue;
                        try {
                            if (FormattedText.this.getText().equals("-")) {
                                return;
                            }
                            if (FormattedText.this.getText().equals("")) {
                                return;
                            }
                            int value = Integer.valueOf(FormattedText.this.getText());
                            if (value >= FormattedText.this.intMin && value <= FormattedText.this.intMax) {
                                int oldValue = FormattedText.this.intValue;
                                FormattedText.this.intValue = value;
                                FormattedText.this.dbValue = FormattedText.this.intValue;
                                FormattedText.this.setText(String.valueOf(value));
                                FormattedText.this.fireActionPerformed();
                                break;
                            }
                            Toolkit.getDefaultToolkit().beep();
                            FormattedText.this.setText(oldIntText);
                        }
                        catch (Exception e) {
                            Toolkit.getDefaultToolkit().beep();
                            FormattedText.this.setText(oldIntText);
                        }
                        break;
                    }
                    case 1: {
                        double oldDbValue = FormattedText.this.dbValue;
                        String oldDbText = "" + FormattedText.this.dbValue;
                        try {
                            if (FormattedText.this.getText().equals("-")) {
                                return;
                            }
                            if (FormattedText.this.getText().equals("")) {
                                return;
                            }
                            double value = Double.valueOf(FormattedText.this.getText());
                            double oldValue = FormattedText.this.dbValue;
                            FormattedText.this.dbValue = value;
                            if (value < FormattedText.this.dbMin || value > FormattedText.this.dbMax) {
                                FormattedText.this.intValue = (int)Math.round(FormattedText.this.dbValue);
                                Toolkit.getDefaultToolkit().beep();
                                FormattedText.this.setText(oldDbText);
                                break;
                            }
                            if (FormattedText.this.getText().toLowerCase().endsWith("d") || FormattedText.this.getText().toLowerCase().endsWith("f")) {
                                Toolkit.getDefaultToolkit().beep();
                                FormattedText.this.setText(oldDbText);
                                break;
                            }
                            FormattedText.this.fireActionPerformed();
                        }
                        catch (Exception e) {
                            Toolkit.getDefaultToolkit().beep();
                            if (oldDbValue == Double.NEGATIVE_INFINITY) {
                                FormattedText.this.setText("-2147483648");
                                break;
                            }
                            if (oldDbValue == Double.POSITIVE_INFINITY) {
                                FormattedText.this.setText("2147483647");
                                break;
                            }
                            FormattedText.this.setText(oldDbText);
                        }
                        break;
                    }
                    case 2: {
                        String oldStrText = FormattedText.this.strValue;
                        try {
                            String value = FormattedText.this.getText();
                            FormattedText.this.strValue = value;
                        }
                        catch (Exception e) {
                            Toolkit.getDefaultToolkit().beep();
                            FormattedText.this.setText(oldStrText);
                        }
                        break;
                    }
                }
            }
        });
    }

    @Override
    protected void fireActionPerformed() {
        super.fireActionPerformed();
    }

    public void setIntValue(int value) {
        if (value >= this.intMin && value <= this.intMax) {
            this.intValue = value;
            this.dbValue = this.intValue;
        }
    }

    public void setDbValue(double value) {
        if (value >= this.dbMin && value <= this.dbMax) {
            this.dbValue = value;
            this.intValue = (int)Math.round(this.dbValue);
        }
    }

    public void setLimitation(int min, int max) {
        System.out.println("Integer");
        if (this.inputMode == 0) {
            this.intMin = min;
            this.intMax = max;
            if (this.intValue < this.intMin) {
                this.setIntValue(this.intMin);
            } else if (this.intValue > this.intMax) {
                this.setIntValue(this.intMax);
            }
        } else if (this.inputMode == 1) {
            this.dbMin = min;
            this.dbMax = max;
            if (this.dbValue < this.dbMin) {
                this.setDbValue(this.dbMin);
            } else if (this.dbValue > this.dbMax) {
                this.setDbValue(this.dbMax);
            }
        } else {
            return;
        }
    }

    public void setLimitation(double min, double max) {
        if (this.inputMode == 0) {
            this.intMin = (int)Math.round(min);
            this.intMax = (int)Math.round(max);
            if (this.intValue < this.intMin) {
                this.setIntValue(this.intMin);
            } else if (this.intValue > this.intMax) {
                this.setIntValue(this.intMax);
            }
        } else if (this.inputMode == 1) {
            this.dbMin = min;
            this.dbMax = max;
            if (this.dbValue < this.dbMin) {
                this.setDbValue(this.dbMin);
            } else if (this.dbValue > this.dbMax) {
                this.setDbValue(this.dbMax);
            }
        } else {
            return;
        }
    }

    public void setInputMode(int i) {
        if (i != 1 && i != 0 && i != 2) {
            return;
        }
        this.inputMode = i;
    }

    public int getInputMode() {
        return this.inputMode;
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(100, 100);
    }
}

