/*
 * Decompiled with CFR 0.152.
 */
package org.concord.swing;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;
import java.awt.image.ColorModel;
import java.awt.image.IndexColorModel;
import java.beans.BeanInfo;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.io.Externalizable;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.net.URL;
import java.util.LinkedList;
import java.util.ListIterator;
import java.util.Vector;
import javax.imageio.ImageIO;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import org.concord.swing.CoordinateTransformer;
import org.concord.swing.Draggable;
import org.concord.swing.JAnnotationImage;
import org.concord.swing.QuickHull;
import org.concord.swing.StateOwner;
import org.concord.swing.StaticAnnotationToolTip;

public class JAnnotationImageModel
implements StateOwner {
    public static final int CHOOSING_MODE_RECTANGLE = 0;
    public static final int CHOOSING_MODE_ELLIPSE = 1;
    public static final int CHOOSING_MODE_POLYGON = 2;
    public static final int CHOOSING_MODE_POINTS = 3;
    public static final int CHOOSING_MODE_MIN = 0;
    public static final int CHOOSING_MODE_MAX = 3;
    private transient Image image;
    transient BufferedImage bim;
    transient BufferedImage bimW;
    transient BufferedImage bimF;
    transient String imageURLString;
    transient AnnotationSpot selectedAnnotationSpot;
    int choosingMode = 0;
    boolean editMode = false;
    String imageResourceString;
    LinkedList annotationSpots = null;
    boolean toolTipMode = false;
    private ModelState state;

    public JAnnotationImageModel() {
    }

    public JAnnotationImageModel(Object state) {
        this();
        this.setState(state);
    }

    public JAnnotationImageModel(String resString) {
        this();
        this.setImageResourceString(resString);
    }

    public JAnnotationImageModel(BufferedImage bim) {
        this();
        this.createImage(bim);
    }

    public void setImageResourceString(String imageResourceString) {
        this.imageResourceString = imageResourceString;
        this.setImageURLString();
    }

    public void setImageResourceString1(String imageResourceString) {
        this.imageResourceString = imageResourceString;
    }

    public String getImageResourceString() {
        return this.imageResourceString;
    }

    public void setEditMode(boolean editMode) {
        this.editMode = editMode;
    }

    public boolean isEditMode() {
        return this.editMode;
    }

    public int getChoosingMode() {
        return this.choosingMode;
    }

    public synchronized void setChoosingMode(int choosingMode) {
        this.choosingMode = choosingMode;
        this.checkChoosingMode();
    }

    public LinkedList getAnnotationSpots() {
        return this.annotationSpots;
    }

    public void setAnnotationSpots(LinkedList annotationSpots) {
        this.annotationSpots = annotationSpots;
    }

    public void clearAnnotationSpots() {
        if (this.annotationSpots != null) {
            ListIterator it = this.annotationSpots.listIterator();
            while (it.hasNext()) {
                AnnotationSpot as = (AnnotationSpot)it.next();
                as.disposeAnnotationToolTip();
            }
            this.annotationSpots.clear();
        }
        this.updateState();
    }

    public void deleteSelectedSpot() {
        if (this.annotationSpots == null || this.selectedAnnotationSpot == null) {
            return;
        }
        this.selectedAnnotationSpot.disposeAnnotationToolTip();
        this.annotationSpots.remove(this.selectedAnnotationSpot);
        this.updateState();
    }

    public String getToolTipText(MouseEvent event) {
        if (this.annotationSpots == null || !this.isToolTipMode()) {
            return null;
        }
        Point pt = event.getPoint();
        ListIterator it = this.annotationSpots.listIterator(this.annotationSpots.size());
        while (it.hasPrevious()) {
            AnnotationSpot as = (AnnotationSpot)it.previous();
            if (!as.contains(pt)) continue;
            return as.getAnnotation();
        }
        return null;
    }

    public void setSelectedAnnotationSpot(AnnotationSpot as) {
        this.selectedAnnotationSpot = as;
    }

    public AnnotationSpot getSelectedAnnotationSpot() {
        return this.selectedAnnotationSpot;
    }

    public AnnotationSpot getAnnotationSpotForPoint(Point pt) {
        AnnotationSpot foundSpot = null;
        if (this.annotationSpots == null) {
            return foundSpot;
        }
        ListIterator it = this.annotationSpots.listIterator(this.annotationSpots.size());
        while (it.hasPrevious()) {
            AnnotationSpot as = (AnnotationSpot)it.previous();
            int asMode = as.startDrag(null, pt);
            if (asMode == 0) continue;
            foundSpot = as;
            break;
        }
        return foundSpot;
    }

    public int getCursorSpotRegionForPoint(Point pt) {
        int cursorSpotRegion = 0;
        if (this.annotationSpots != null) {
            ListIterator it = this.annotationSpots.listIterator(this.annotationSpots.size());
            while (it.hasPrevious()) {
                AnnotationSpot as = (AnnotationSpot)it.previous();
                if (this.isEditMode() && this.selectedAnnotationSpot == as) {
                    Rectangle r = as.getBoundsForAdjustCursor();
                    if (!r.contains(pt)) continue;
                    cursorSpotRegion = as.getSpotRegion(pt.x, pt.y);
                    break;
                }
                if (this.isEditMode() || !as.contains(pt)) continue;
                cursorSpotRegion = 9;
                break;
            }
        }
        return cursorSpotRegion;
    }

    public synchronized void addAnnotationSpot(AnnotationSpot as) {
        this.addAnnotationSpot(as, false);
    }

    public synchronized void addAnnotationSpot(AnnotationSpot as, boolean forceAdd) {
        if (as == null || as.isEmpty() && !forceAdd) {
            return;
        }
        if (this.annotationSpots == null) {
            this.annotationSpots = new LinkedList();
        }
        this.annotationSpots.add(as);
        as.setIndex(this.annotationSpots.size() - 1);
        as.setToolTipMode(this.isToolTipMode());
    }

    public synchronized void removeAnnotationSpot(AnnotationSpot as) {
        if (this.annotationSpots != null && as != null && this.annotationSpots.contains(as)) {
            as.disposeAnnotationToolTip();
            this.annotationSpots.remove(as);
        }
    }

    public boolean isAnnotationSpotPopupVisible() {
        boolean retValue = false;
        if (this.annotationSpots == null) {
            return retValue;
        }
        ListIterator it = this.annotationSpots.listIterator();
        while (it.hasNext()) {
            AnnotationSpot as = (AnnotationSpot)it.next();
            if (!as.isPopupVisible()) continue;
            retValue = true;
            break;
        }
        return retValue;
    }

    public void setToolTipMode(boolean toolTipMode) {
        this.toolTipMode = toolTipMode;
        if (this.annotationSpots != null) {
            ListIterator it = this.annotationSpots.listIterator();
            while (it.hasNext()) {
                AnnotationSpot as = (AnnotationSpot)it.next();
                as.setToolTipMode(this.isToolTipMode());
            }
        }
    }

    public Area getToolTipAreaForClip(Component destination) {
        if (this.isToolTipMode() || this.annotationSpots == null || this.annotationSpots.size() < 1) {
            return null;
        }
        Area area = new Area();
        ListIterator it = this.annotationSpots.listIterator();
        while (it.hasNext()) {
            AnnotationSpot as = (AnnotationSpot)it.next();
            JComponent c = as.getAnnotationToolTip();
            if (c == null) continue;
            Rectangle r = c.getBounds();
            Container parent = c.getParent();
            if (parent == null) continue;
            area.add(new Area(SwingUtilities.convertRectangle(parent, r, destination)));
        }
        return area;
    }

    public boolean isToolTipMode() {
        return this.toolTipMode;
    }

    public void dispose() {
        if (this.image != null) {
            this.image.flush();
        }
        if (this.bim != null) {
            this.bim.flush();
        }
        if (this.bimW != null) {
            this.bimW.flush();
        }
        if (this.bimF != null) {
            this.bimF.flush();
        }
        this.image = null;
        this.bim = null;
        this.bimW = null;
        this.bimF = null;
        this.clearAnnotationSpots();
    }

    @Override
    public Object getState() {
        this.updateState();
        return this.state;
    }

    protected void updateState() {
        if (this.state == null) {
            this.state = new ModelState();
        }
        this.state.choosingMode = this.choosingMode;
        this.state.editMode = this.editMode;
        this.state.imageResourceString = this.imageResourceString;
        this.state.image = this.bim;
        this.state.updateAnnotationSpots(this.annotationSpots);
    }

    @Override
    public void setState(Object s) {
        if (!(s instanceof ModelState)) {
            return;
        }
        this.state = (ModelState)s;
        this.recreateFromState();
    }

    protected void recreateFromState() {
        if (this.state == null) {
            return;
        }
        this.choosingMode = this.state.getChoosingMode();
        this.editMode = this.state.isEditMode();
        this.imageResourceString = this.state.getImageResourceString();
        this.setImageURLString();
        this.annotationSpots = null;
        Vector v = this.state.getAnnotationSpots();
        if (v == null || v.isEmpty()) {
            return;
        }
        if (this.annotationSpots == null) {
            this.annotationSpots = new LinkedList();
        } else {
            this.annotationSpots.clear();
        }
        int i = 0;
        while (i < v.size()) {
            this.annotationSpots.add(new AnnotationSpot(v.elementAt(i)));
            ++i;
        }
    }

    protected void setImageURLString() {
        this.imageURLString = null;
        if (this.imageResourceString == null) {
            return;
        }
        String jarString = this.createJARURLString(this.imageResourceString);
        this.imageURLString = this.checkForResource(jarString) ? jarString : (this.checkForResource(this.imageResourceString) ? this.imageResourceString : "file:" + this.imageResourceString);
        this.createImage();
    }

    protected void checkChoosingMode() {
        if (this.choosingMode >= 0 && this.choosingMode <= 3) {
            return;
        }
        this.choosingMode = 0;
    }

    protected boolean checkForResource(String str) {
        boolean retValue = false;
        if (str == null) {
            return retValue;
        }
        try {
            URL url = new URL(str);
            InputStream is = url.openStream();
            is.close();
            retValue = true;
        }
        catch (Throwable t) {
            retValue = false;
        }
        return retValue;
    }

    protected String createJARURLString(String str) {
        if (str == null) {
            return str;
        }
        StringBuffer sb = new StringBuffer();
        String classItemName = this.getClass().getName().replace('.', '/');
        if (!classItemName.startsWith("/")) {
            sb.append("/");
        }
        sb.append(classItemName);
        sb.append(".class");
        URL urlClass = this.getClass().getResource(sb.toString());
        String externalForm = urlClass.toExternalForm();
        int index = externalForm.lastIndexOf(33);
        if (index < 0) {
            return str;
        }
        String partialPath = externalForm.substring(0, index + 1);
        try {
            sb.setLength(0);
            sb.append(partialPath);
            if (!str.startsWith("/")) {
                sb.append("/");
            }
            sb.append(str);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return sb.toString();
    }

    protected void createImage() {
        this.createImage(null);
    }

    protected void createImage(BufferedImage bufferedImage) {
        if (this.image != null) {
            this.image.flush();
        }
        if (this.bim != null) {
            this.bim.flush();
        }
        if (this.bimW != null) {
            this.bimW.flush();
        }
        if (this.bimF != null) {
            this.bimF.flush();
        }
        this.image = null;
        this.bim = null;
        this.bimW = null;
        this.bimF = null;
        if (bufferedImage == null && this.imageURLString == null) {
            return;
        }
        int width = 0;
        int height = 0;
        if (bufferedImage != null) {
            this.image = bufferedImage;
            width = bufferedImage.getWidth();
            height = bufferedImage.getHeight();
        } else {
            if (!this.checkForResource(this.imageURLString)) {
                System.out.println("resource is unavailable");
                return;
            }
            try {
                URL imageURL = new URL(this.imageURLString);
                this.image = ImageIO.read(imageURL);
                width = this.image.getWidth(null);
                height = this.image.getHeight(null);
            }
            catch (Throwable t) {
                System.out.println("url throwable " + t);
            }
        }
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice gd = ge.getDefaultScreenDevice();
        GraphicsConfiguration gc = gd.getDefaultConfiguration();
        boolean hasAlpha = gc.getColorModel().hasAlpha();
        if (hasAlpha) {
            if (this.image != null) {
                this.bim = gc.createCompatibleImage(width, height);
            }
            this.bimW = gc.createCompatibleImage(width, height);
            this.bimF = gc.createCompatibleImage(width, height);
        } else {
            if (this.image != null) {
                this.bim = new BufferedImage(width, height, 2);
            }
            this.bimW = new BufferedImage(width, height, 2);
            this.bimF = new BufferedImage(width, height, 2);
        }
        Graphics2D g2d = null;
        if (this.image != null) {
            g2d = this.bim.createGraphics();
            g2d.drawImage(this.image, 0, 0, null);
            g2d.dispose();
        }
        g2d = this.bimW.createGraphics();
        g2d.setColor(Color.white);
        g2d.fillRect(0, 0, width, height);
        g2d.drawImage(this.bim, new TranslucentGlassOp(0, 0, -1, -1), 0, 0);
        g2d.dispose();
    }

    protected void removeTransientFields() {
        try {
            Class<?> myClass = this.getClass();
            Field[] fields = myClass.getDeclaredFields();
            Vector<String> transientFields = new Vector<String>();
            int i = 0;
            while (i < fields.length) {
                Field f = fields[i];
                String modifiers = Modifier.toString(f.getModifiers());
                if (modifiers != null && modifiers.toLowerCase().indexOf("transient") >= 0) {
                    transientFields.add(f.getName());
                }
                ++i;
            }
            BeanInfo info = Introspector.getBeanInfo(this.getClass());
            PropertyDescriptor[] propertyDescriptors = info.getPropertyDescriptors();
            int i2 = 0;
            while (i2 < propertyDescriptors.length) {
                PropertyDescriptor pd = propertyDescriptors[i2];
                if (transientFields.contains(pd.getName())) {
                    pd.setValue("transient", Boolean.TRUE);
                }
                ++i2;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    protected void prepareForSerialization() {
        this.removeTransientFields();
        if (this.annotationSpots != null) {
            ListIterator it = this.annotationSpots.listIterator();
            while (it.hasNext()) {
                AnnotationSpot as = (AnnotationSpot)it.next();
                as.prepareForSerialization();
            }
        }
    }

    protected BufferedImage getMainImage() {
        return this.bim;
    }

    protected BufferedImage getMainEditImage() {
        return this.bimW;
    }

    protected BufferedImage getBackgroundImageImage() {
        return this.bimF;
    }

    protected void checkAnnotationToolTips() {
        if (this.annotationSpots != null) {
            ListIterator it = this.annotationSpots.listIterator();
            while (it.hasNext()) {
                AnnotationSpot as = (AnnotationSpot)it.next();
                as.checkAnnotationToolTip();
            }
        }
    }

    public static class AnnotationSpot
    implements Shape,
    Draggable,
    StateOwner {
        public static final int SPOT_REGION_UNKNOWN = 0;
        public static final int SPOT_REGION_TOP_LEFT = 1;
        public static final int SPOT_REGION_TOP_RIGHT = 2;
        public static final int SPOT_REGION_BOTTOM_LEFT = 3;
        public static final int SPOT_REGION_BOTTOM_RIGHT = 4;
        public static final int SPOT_REGION_LEFT = 5;
        public static final int SPOT_REGION_RIGHT = 6;
        public static final int SPOT_REGION_TOP = 7;
        public static final int SPOT_REGION_BOTTOM = 8;
        public static final int SPOT_REGION_ALL = 9;
        public static final int SPOT_REGION_DEFINE = 10;
        public static final int SPOT_REGION_TOOL_TIP = 11;
        static final int VICINITY_CONSTANT = 5;
        String annotation;
        Point2D[] points;
        Rectangle enclosedRectangle;
        boolean toolTipMode = true;
        Point annotationToolTipLocation;
        Rectangle bounds;
        Color spotColor = Color.blue;
        int choosingMode = 0;
        transient double startDragX;
        transient double startDragY;
        transient GeneralPath startDragArea;
        transient int dragMode;
        transient GeneralPath spot;
        transient StaticAnnotationToolTip annotationToolTip;
        transient int index = 0;
        transient boolean draggable = true;
        transient Point annotationTipConnectionPoint;
        private transient boolean choosingModeWasCalled = false;
        Vector pickedPoints = null;
        int pickedPointIndex = -1;
        AnnotationSpotState state;
        JPopupMenu textAreaMenu;
        private JTextArea textArea = new JTextArea();
        JAnnotationImage annotationImage;
        CoordinateTransformer currentTransformer;
        private transient boolean popupMenuVisible = false;

        protected AnnotationSpot(Object state) {
            this();
            this.setState(state);
        }

        public AnnotationSpot() {
        }

        public AnnotationSpot(Shape spot) {
            this("", spot);
        }

        public AnnotationSpot(String annotation, Shape spot) {
            this();
            this.annotation = annotation;
            this.spot = new GeneralPath(spot);
        }

        public JAnnotationImage getAnnotationImage() {
            return this.annotationImage;
        }

        public void setAnnotationImage(JAnnotationImage annotationImage) {
            this.annotationImage = annotationImage;
        }

        public boolean getHtmlSupport() {
            return this.annotationImage == null ? false : this.annotationImage.getHtmlSupport();
        }

        public synchronized boolean isPopupVisible() {
            return this.popupMenuVisible;
        }

        public synchronized void setPopupVisible(boolean val) {
            if (val == this.popupMenuVisible) {
                return;
            }
            if (!this.popupMenuVisible) {
                this.popupMenuVisible = val;
                return;
            }
            Timer swingTimer = new Timer(500, new ActionListener(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void actionPerformed(ActionEvent evt) {
                    AnnotationSpot annotationSpot = AnnotationSpot.this;
                    synchronized (annotationSpot) {
                        AnnotationSpot.this.popupMenuVisible = false;
                    }
                }
            });
            swingTimer.setRepeats(false);
            swingTimer.start();
        }

        @Override
        public Object getState() {
            this.updateState();
            return this.state;
        }

        protected void updateState() {
            this.prepareForSerialization();
            if (this.state == null) {
                this.state = new AnnotationSpotState();
            }
            this.state.index = this.index;
            this.state.choosingMode = this.choosingMode;
            this.state.annotation = this.annotation;
            this.state.annotationToolTipLocation = this.annotationToolTipLocation;
            this.state.bounds = this.bounds;
            this.state.spotColor = this.spotColor;
            this.state.toolTipMode = this.toolTipMode;
            this.state.points = null;
            if (this.points != null) {
                this.state.points = (Point2D[])this.points.clone();
            }
        }

        @Override
        public void setState(Object s) {
            if (!(s instanceof AnnotationSpotState)) {
                return;
            }
            this.state = (AnnotationSpotState)s;
            this.recreateFromState();
        }

        protected void recreateFromState() {
            if (this.state == null) {
                return;
            }
            this.index = this.state.getIndex();
            this.choosingMode = this.state.getChoosingMode();
            this.annotation = this.state.getAnnotation();
            this.spotColor = this.state.getSpotColor();
            this.toolTipMode = this.state.isToolTipMode();
            this.setPoints(this.state.getPoints());
            this.setAnnotationToolTipLocation(this.state.getAnnotationToolTipLocation());
            this.checkAnnotationToolTip();
            this.setBounds(this.state.getBounds());
            this.calculateAnnotationTipConnectionPoint();
        }

        public String toString() {
            this.prepareForSerialization();
            StringBuffer sb = new StringBuffer();
            sb.append("<class>" + this.getClass().getName() + "</class>\n");
            sb.append("<annotation>");
            if (this.annotation != null) {
                sb.append(this.annotation);
            }
            sb.append("</annotation>/n");
            sb.append("<enclosedRectangle>");
            if (this.enclosedRectangle != null) {
                sb.append("<x>" + this.enclosedRectangle.x + "/x\n");
                sb.append("<y>" + this.enclosedRectangle.x + "/y" + "\n");
                sb.append("<width>" + this.enclosedRectangle.x + "/width\n");
                sb.append("<height>" + this.enclosedRectangle.x + "/height\n");
            }
            sb.append("</enclosedRectangle>\n");
            sb.append("<points>");
            if (this.points == null) {
                sb.append("<size>-1</size>\n");
            } else {
                sb.append("<size>" + this.points.length + "</size>\n");
                int i = 0;
                while (i < this.points.length) {
                    sb.append("<point> x=\"" + this.points[i].getX() + "\" y=\"" + this.points[i].getY() + "\"</point>\n");
                    ++i;
                }
            }
            sb.append("</points>\n");
            return sb.toString();
        }

        public int getIndex() {
            return this.index;
        }

        public void setIndex(int index) {
            this.index = index;
        }

        public void setEnclosedRectangle(Rectangle r) {
            this.enclosedRectangle = r;
        }

        public Rectangle getEnclosedRectangle() {
            return this.enclosedRectangle;
        }

        public void setAnnotationToolTip(StaticAnnotationToolTip annotationToolTip) {
            this.annotationToolTip = annotationToolTip;
        }

        public JComponent getAnnotationToolTip() {
            if (this.isToolTipMode()) {
                return null;
            }
            return this.annotationToolTip;
        }

        public void checkAnnotationToolTipPosition() {
            if (this.annotationToolTip == null) {
                this.createAnnotationToolTip();
            }
            if (this.annotationToolTip == null) {
                return;
            }
            Rectangle rb = this.getBounds();
            Rectangle r = this.annotationToolTip.getBounds();
            Point pta = this.annotationToolTip.getLocation();
            this.annotationToolTip.setLocation(rb.x + rb.width / 2 - r.width / 2, rb.y + rb.height / 2 - r.height / 2);
        }

        public void checkAnnotationToolTip() {
            if (this.annotationToolTip == null) {
                this.createAnnotationToolTip();
            }
        }

        protected void calculateAnnotationTipConnectionPoint() {
            if (this.isEmpty()) {
                this.annotationTipConnectionPoint = new Point(Integer.MIN_VALUE, Integer.MIN_VALUE);
                return;
            }
            Rectangle rb = this.getBounds();
            int xc = rb.x + rb.width / 2;
            int yc = rb.y + rb.height / 2;
            this.annotationTipConnectionPoint = new Point(xc, yc);
            if (this.contains(this.annotationTipConnectionPoint)) {
                return;
            }
            PathIterator pit = this.spot.getPathIterator(null);
            double[] tempArray = new double[6];
            double d2 = Double.MAX_VALUE;
            while (!pit.isDone()) {
                double temp;
                int type = pit.currentSegment(tempArray);
                if ((type == 0 || type == 1) && (temp = Point2D.distanceSq(xc, yc, tempArray[0], tempArray[1])) < d2) {
                    d2 = temp;
                    this.annotationTipConnectionPoint = new Point((int)Math.round(tempArray[0]), (int)Math.round(tempArray[1]));
                }
                pit.next();
            }
        }

        public Point getAnnotationTipConnectionPoint() {
            if (this.annotationTipConnectionPoint == null) {
                this.calculateAnnotationTipConnectionPoint();
            }
            if (!(this.isEmpty() || this.annotationTipConnectionPoint == null || this.annotationTipConnectionPoint.x != Integer.MIN_VALUE && this.annotationTipConnectionPoint.y != Integer.MIN_VALUE)) {
                this.calculateAnnotationTipConnectionPoint();
            }
            return this.annotationTipConnectionPoint;
        }

        public void createAnnotationToolTip() {
            if (this.annotationToolTip == null) {
                this.annotationToolTip = new StaticAnnotationToolTip(this.getHtmlSupport());
            }
            this.annotationToolTip.setText(this.annotation);
            this.annotationToolTip.setOwner(this);
            if (this.annotationToolTipLocation == null) {
                this.annotationToolTipLocation = new Point();
            }
            this.setAnnotationToolTipLocation(this.annotationToolTipLocation);
        }

        public void disposeAnnotationToolTip() {
            if (this.annotationToolTip == null) {
                return;
            }
            Container parent = this.annotationToolTip.getParent();
            if (parent != null) {
                parent.remove(this.annotationToolTip);
            }
            this.annotationToolTip = null;
        }

        public Point getAnnotationToolTipLocation() {
            return this.annotationToolTipLocation;
        }

        public void setAnnotationToolTipLocation(Point annotationToolTipLocation) {
            this.annotationToolTipLocation = annotationToolTipLocation;
            if (this.annotationToolTip != null) {
                this.annotationToolTip.setLocation(annotationToolTipLocation);
            }
        }

        public GeneralPath getSpot() {
            return this.spot;
        }

        public int getChoosingMode() {
            return this.choosingMode;
        }

        public synchronized void setChoosingMode(int choosingMode) {
            this.choosingMode = choosingMode;
            if (!this.choosingModeWasCalled) {
                this.choosingModeWasCalled = true;
                this.setBounds(this.bounds);
            }
        }

        public Rectangle getBoundsForAdjustCursor() {
            Rectangle r = this.getBounds();
            if (r == null) {
                return r;
            }
            r.x -= 5;
            r.y -= 5;
            r.width += 10;
            r.height += 10;
            return r;
        }

        public Color getSpotColor() {
            return this.spotColor;
        }

        public void getSpotColor(Color spotColor) {
            this.spotColor = spotColor;
        }

        public String getAnnotation() {
            return this.annotation;
        }

        public void setAnnotation(String annotation) {
            this.annotation = annotation;
            if (this.annotation != null && this.annotationToolTip != null) {
                this.annotationToolTip.setText(annotation);
            }
        }

        public int getSpotRegion(Point pt) {
            return this.getSpotRegion(pt.getX(), pt.getY());
        }

        public int getSpotRegion(double x, double y) {
            Rectangle annotationToolTipBounds;
            Rectangle r = this.getBounds();
            if (r == null) {
                return 0;
            }
            if (this.isEmpty()) {
                return 10;
            }
            if (this.annotationToolTip != null && !this.isToolTipMode() && (annotationToolTipBounds = this.annotationToolTip.getBounds()).contains(x, y)) {
                return 11;
            }
            if (r.width >= 0 && r.height >= 1) {
                int rightX = r.x + r.width;
                int bottomY = r.y + r.height;
                if ((double)r.x > x && (double)r.x - x < 5.0 && (double)r.y > y && (double)r.y - y < 5.0) {
                    return 1;
                }
                if (x > (double)rightX && x - (double)rightX < 5.0 && (double)r.y > y && (double)r.y - y < 5.0) {
                    return 2;
                }
                if ((double)r.x > x && (double)r.x - x < 5.0 && y > (double)bottomY && y - (double)bottomY < 5.0) {
                    return 3;
                }
                if (x > (double)rightX && x - (double)rightX < 5.0 && y > (double)bottomY && y - (double)bottomY < 5.0) {
                    return 4;
                }
                if ((double)r.x > x && (double)r.x - x < 5.0 && y > (double)r.y && y < (double)bottomY) {
                    return 5;
                }
                if (x > (double)rightX && x - (double)rightX < 5.0 && y > (double)r.y && y < (double)bottomY) {
                    return 6;
                }
                if ((double)r.y > y && (double)r.y - y < 5.0 && x > (double)r.x && x < (double)rightX) {
                    return 7;
                }
                if (y > (double)bottomY && y - (double)bottomY < 5.0 && x > (double)r.x && x < (double)rightX) {
                    return 8;
                }
                if (this.spot.contains(x, y)) {
                    return 9;
                }
            }
            return 0;
        }

        @Override
        public int startDrag(CoordinateTransformer transformer, Point pt) {
            if (this.pickedPoints == null) {
                this.pickedPoints = new Vector();
            } else {
                this.pickedPoints.removeAllElements();
            }
            this.pickedPointIndex = -1;
            this.startDragX = pt.getX();
            this.startDragY = pt.getY();
            this.dragMode = this.getSpotRegion(pt);
            this.startDragArea = this.spot != null ? (GeneralPath)this.spot.clone() : null;
            this.currentTransformer = transformer;
            if (this.dragMode < 1 || this.dragMode > 8) {
                this.pickedPointIndex = this.checkClickOnLine(pt, this.pickedPoints);
                this.recreateSpotWithPickedLine(pt);
                if (this.pickedPoints.size() > 0 && this.pickedPointIndex >= 0 && this.dragMode == 0) {
                    this.dragMode = 9;
                }
            }
            return this.dragMode;
        }

        public boolean contains(Point pt) {
            if (pt == null || this.spot == null) {
                return false;
            }
            return this.spot.contains(pt);
        }

        public boolean isEmpty() {
            if (this.spot == null) {
                return true;
            }
            return this.spot.getBounds().isEmpty();
        }

        @Override
        public void doDrag(Point pt) {
            boolean doTransform;
            if (this.dragMode == 0) {
                return;
            }
            double newX = pt.getX();
            double newY = pt.getY();
            if (this.enclosedRectangle != null) {
                if (newX < (double)this.enclosedRectangle.x) {
                    newX = this.enclosedRectangle.x;
                }
                if (newX > (double)(this.enclosedRectangle.x + this.enclosedRectangle.width)) {
                    newX = this.enclosedRectangle.x + this.enclosedRectangle.width;
                }
                if (newY < (double)this.enclosedRectangle.y) {
                    newY = this.enclosedRectangle.y;
                }
                if (newY > (double)(this.enclosedRectangle.y + this.enclosedRectangle.height)) {
                    newY = this.enclosedRectangle.y + this.enclosedRectangle.height;
                }
            }
            double dx = newX - this.startDragX;
            double dy = newY - this.startDragY;
            if (this.dragMode == 10 && this.spot != null) {
                double x0 = Math.min(newX, this.startDragX);
                double y0 = Math.min(newY, this.startDragY);
                double w0 = Math.abs(dx);
                double h0 = Math.abs(dy);
                switch (this.choosingMode) {
                    case 3: {
                        break;
                    }
                    case 2: {
                        this.spot.lineTo((float)newX, (float)newY);
                        break;
                    }
                    case 1: {
                        this.spot.reset();
                        this.spot.append(new GeneralPath(new Ellipse2D.Double(x0, y0, w0, h0)), true);
                        break;
                    }
                    default: {
                        this.spot.reset();
                        this.spot.append(new GeneralPath(new Rectangle2D.Double(x0, y0, w0, h0)), true);
                        break;
                    }
                }
            } else if (this.dragMode == 9) {
                if (this.pickedPointIndex >= 0 && this.pickedPoints != null && this.pickedPoints.size() > 1) {
                    this.recreateSpotWithPickedLine(new Point((int)Math.round(newX), (int)Math.round(newY)));
                    return;
                }
                GeneralPath newSpot = (GeneralPath)this.startDragArea.clone();
                newSpot.transform(AffineTransform.getTranslateInstance(dx, dy));
                if (this.enclosedRectangle == null) {
                    this.spot = newSpot;
                    return;
                }
                if (newSpot.intersects(this.enclosedRectangle)) {
                    this.spot = newSpot;
                }
                return;
            }
            Rectangle startRect = this.startDragArea.getBounds();
            double kx = 0.0;
            double ky = 0.0;
            double w0 = startRect.width;
            double h0 = startRect.height;
            double w = w0;
            double h = h0;
            boolean bl = doTransform = this.spot != null;
            if (doTransform) {
                switch (this.dragMode) {
                    case 1: {
                        kx = 1.0;
                        ky = 1.0;
                        w = (double)startRect.x + w0 - newX;
                        h = (double)startRect.y + h0 - newY;
                        break;
                    }
                    case 2: {
                        ky = 1.0;
                        w = newX - (double)startRect.x;
                        h = (double)startRect.y + h0 - newY;
                        break;
                    }
                    case 3: {
                        kx = 1.0;
                        w = (double)startRect.x + w0 - newX;
                        h = newY - (double)startRect.y;
                        break;
                    }
                    case 4: {
                        w = newX - (double)startRect.x;
                        h = newY - (double)startRect.y;
                        break;
                    }
                    case 5: {
                        kx = 1.0;
                        w = (double)startRect.x + w0 - newX;
                        break;
                    }
                    case 6: {
                        w = newX - (double)startRect.x;
                        break;
                    }
                    case 7: {
                        ky = 1.0;
                        h = (double)startRect.y + h0 - newY;
                        break;
                    }
                    case 8: {
                        h = newY - (double)startRect.y;
                        break;
                    }
                    default: {
                        doTransform = false;
                    }
                }
            }
            if (doTransform) {
                if (w < 5.0) {
                    w = 5.0;
                }
                if (h < 5.0) {
                    h = 5.0;
                }
                double m00 = w / w0;
                double m01 = 0.0;
                double m02 = (w0 - w) * (kx + (double)startRect.x / w0);
                double m10 = 0.0;
                double m11 = h / h0;
                double m12 = (h0 - h) * (ky + (double)startRect.y / h0);
                this.spot = (GeneralPath)this.startDragArea.clone();
                this.spot.transform(new AffineTransform(m00, m10, m01, m11, m02, m12));
            }
        }

        @Override
        public void endDrag(Point pt) {
            this.startDragArea = null;
            this.calculateAnnotationTipConnectionPoint();
            if (this.choosingMode == 3) {
                return;
            }
            if (this.choosingMode == 2 || this.pickedPointIndex >= 0) {
                this.normalize();
            }
        }

        public Point2D[] getPoints() {
            return this.points;
        }

        public void setPoints(Point2D[] points) {
            this.points = points;
            if (this.points == null) {
                return;
            }
            if (this.spot != null) {
                this.spot.reset();
            } else {
                this.spot = new GeneralPath();
            }
            int i = 0;
            while (i < points.length) {
                if (i == 0) {
                    this.spot.moveTo((float)points[i].getX(), (float)points[i].getY());
                } else {
                    this.spot.lineTo((float)points[i].getX(), (float)points[i].getY());
                }
                ++i;
            }
            this.spot.closePath();
        }

        public void setToolTipMode(boolean toolTipMode) {
            this.toolTipMode = toolTipMode;
            if (this.annotationToolTip != null) {
                this.annotationToolTip.setVisible(!toolTipMode);
            }
        }

        public boolean isToolTipMode() {
            return this.toolTipMode;
        }

        @Override
        public void setDraggable(boolean draggable) {
            this.draggable = draggable;
        }

        @Override
        public boolean isDraggable() {
            return this.dragMode != 0 && this.draggable;
        }

        @Override
        public boolean contains(double x, double y) {
            if (this.spot == null) {
                return false;
            }
            return this.spot.contains(x, y);
        }

        @Override
        public boolean contains(double x, double y, double w, double h) {
            if (this.spot == null) {
                return false;
            }
            return this.spot.contains(x, y, w, h);
        }

        @Override
        public boolean contains(Point2D p2d) {
            if (p2d == null || this.spot == null) {
                return false;
            }
            return this.spot.contains(p2d);
        }

        @Override
        public boolean contains(Rectangle2D r2d) {
            if (r2d == null || this.spot == null) {
                return false;
            }
            return this.spot.contains(r2d);
        }

        @Override
        public Rectangle getBounds() {
            this.bounds = this.spot == null ? null : this.spot.getBounds();
            return this.bounds;
        }

        public void setBounds(Rectangle r) {
            if (r == null) {
                return;
            }
            if (this.spot == null) {
                this.spot = new GeneralPath();
            }
            switch (this.choosingMode) {
                case 0: {
                    this.spot.reset();
                    this.spot.append(new GeneralPath(new Rectangle2D.Double(r.x, r.y, r.width, r.height)), true);
                    break;
                }
                case 1: {
                    this.spot.reset();
                    this.spot.append(new GeneralPath(new Ellipse2D.Double(r.x, r.y, r.width, r.height)), true);
                    break;
                }
                case 2: 
                case 3: {
                    if (this.isEmpty()) break;
                    Rectangle rb = this.getBounds();
                    double sx = (double)r.width / (double)rb.width;
                    double sy = (double)r.height / (double)rb.height;
                    if (Math.abs(sx - 1.0) < 1.0E-5 && Math.abs(sy - 1.0) < 1.0E-5) break;
                    GeneralPath newSpot = (GeneralPath)this.spot.clone();
                    newSpot.transform(AffineTransform.getScaleInstance(sx, sy));
                    this.spot = newSpot;
                }
            }
            this.bounds = this.getBounds();
        }

        @Override
        public Rectangle2D getBounds2D() {
            if (this.spot != null) {
                return this.spot.getBounds2D();
            }
            return null;
        }

        @Override
        public PathIterator getPathIterator(AffineTransform at) {
            if (this.spot != null) {
                return this.spot.getPathIterator(at);
            }
            return null;
        }

        @Override
        public PathIterator getPathIterator(AffineTransform at, double flatness) {
            if (this.spot != null) {
                return this.spot.getPathIterator(at, flatness);
            }
            return null;
        }

        @Override
        public boolean intersects(Rectangle2D r2d) {
            if (r2d == null || this.spot == null) {
                return false;
            }
            return this.spot.intersects(r2d);
        }

        @Override
        public boolean intersects(double x, double y, double w, double h) {
            if (this.spot == null) {
                return false;
            }
            return this.spot.intersects(x, y, w, h);
        }

        protected void normalize() {
            if (this.spot == null) {
                return;
            }
            PathIterator pit = this.spot.getPathIterator(null);
            double[] tempArray = new double[6];
            Vector<Point> ptsv = new Vector<Point>();
            while (!pit.isDone()) {
                int type = pit.currentSegment(tempArray);
                if (type == 0 || type == 1) {
                    ptsv.add(new Point((int)Math.round(tempArray[0]), (int)Math.round(tempArray[1])));
                }
                pit.next();
            }
            Point[] pts = new Point[ptsv.size()];
            int i = 0;
            while (i < pts.length) {
                pts[i] = (Point)ptsv.elementAt(i);
                ++i;
            }
            QuickHull qh = new QuickHull(pts);
            Polygon pol = new Polygon();
            int i2 = 0;
            while (i2 < qh.hullPoints.size()) {
                Point pt = (Point)qh.hullPoints.elementAt(i2);
                pol.addPoint(pt.x, pt.y);
                ++i2;
            }
            this.spot.reset();
            this.spot.append(new GeneralPath(pol), true);
        }

        void recreateSpotWithPickedLine(Point pt) {
            if (this.pickedPoints.size() < 1 || this.pickedPointIndex < 0) {
                return;
            }
            this.spot.reset();
            this.pickedPoints.remove(this.pickedPointIndex);
            this.pickedPoints.insertElementAt(pt, this.pickedPointIndex);
            int i = 1;
            while (i < this.pickedPoints.size()) {
                Line2D.Double line = new Line2D.Double((Point)this.pickedPoints.elementAt(i - 1), (Point)this.pickedPoints.elementAt(i));
                this.spot.append(line, true);
                ++i;
            }
        }

        protected int checkClickOnLine(Point pt, Vector ptsv) {
            int pointIndex = -1;
            if (pt == null || this.isEmpty() || ptsv == null) {
                return pointIndex;
            }
            ptsv.removeAllElements();
            PathIterator pit = this.spot.getPathIterator(null);
            double[] tempArray = new double[6];
            while (!pit.isDone()) {
                int type = pit.currentSegment(tempArray);
                if (type == 0 || type == 1) {
                    ptsv.add(new Point((int)Math.round(tempArray[0]), (int)Math.round(tempArray[1])));
                }
                pit.next();
            }
            int nPoints = ptsv.size();
            Point2D.Double p2d = new Point2D.Double(pt.x, pt.y);
            if (nPoints >= 2) {
                Point ptE;
                Point ptS = (Point)ptsv.elementAt(0);
                if (!ptS.equals(ptE = (Point)ptsv.elementAt(nPoints - 1))) {
                    ptsv.add(ptS);
                    ++nPoints;
                }
                int i = 1;
                while (i < nPoints) {
                    Line2D.Double line = new Line2D.Double((Point)ptsv.elementAt(i - 1), (Point)ptsv.elementAt(i));
                    if (p2d.distance(line.getP1()) < 3.0) {
                        pointIndex = i - 1;
                    } else if (p2d.distance(line.getP2()) < 3.0) {
                        pointIndex = i;
                    } else if (line.ptSegDist(p2d) < 3.0) {
                        ptsv.insertElementAt(pt, i);
                        pointIndex = i;
                    }
                    if (pointIndex >= 0) break;
                    ++i;
                }
            }
            return pointIndex;
        }

        protected void prepareForSerialization() {
            if (this.spot == null) {
                return;
            }
            PathIterator pit = this.spot.getPathIterator(null);
            double[] tempArray = new double[6];
            Vector<Point2D.Double> ptsv = new Vector<Point2D.Double>();
            while (!pit.isDone()) {
                int type = pit.currentSegment(tempArray);
                if (type == 0 || type == 1) {
                    ptsv.add(new Point2D.Double(tempArray[0], tempArray[1]));
                }
                pit.next();
            }
            this.points = new Point2D.Double[ptsv.size()];
            int i = 0;
            while (i < this.points.length) {
                this.points[i] = (Point2D)ptsv.elementAt(i);
                ++i;
            }
        }

        protected void setAnnotationFromPopUp(JPopupMenu pm) {
            if (pm == null) {
                return;
            }
            Component jc = pm.getComponent(0);
            if (!(jc instanceof JScrollPane)) {
                return;
            }
            JScrollPane sp = (JScrollPane)jc;
            Component view = sp.getViewport().getView();
            if (!(view instanceof JTextArea)) {
                return;
            }
            this.setAnnotation(((JTextArea)view).getText());
            this.textAreaMenu = null;
        }

        protected void setupPopupMenu() {
            if (this.isEmpty() || this.annotationImage == null || !this.annotationImage.isEditMode()) {
                return;
            }
            this.textAreaMenu = new JPopupMenu();
            this.textAreaMenu.addPopupMenuListener(new PopupMenuListener(){

                @Override
                public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
                    AnnotationSpot.this.setPopupVisible(true);
                }

                @Override
                public void popupMenuCanceled(PopupMenuEvent e) {
                }

                @Override
                public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
                    AnnotationSpot.this.setPopupVisible(false);
                    Object obj = e.getSource();
                    if (!(obj instanceof JPopupMenu)) {
                        return;
                    }
                    JPopupMenu pm = (JPopupMenu)obj;
                    AnnotationSpot.this.setAnnotationFromPopUp((JPopupMenu)obj);
                }
            });
            this.textAreaMenu.setBackground(new Color(200, 200, 200));
            this.textAreaMenu.setOpaque(true);
            this.textArea.setText(this.getAnnotation());
            JScrollPane scrollPane = new JScrollPane(this.textArea);
            scrollPane.setPreferredSize(new Dimension(200, 200));
            this.textAreaMenu.add(scrollPane);
            this.textAreaMenu.pack();
            Point ptMenu = this.annotationToolTipLocation;
            ptMenu = ptMenu == null ? new Point(this.getBounds().x, this.getBounds().y) : SwingUtilities.convertPoint(this.annotationImage.getParent(), ptMenu, this.annotationImage);
            this.textAreaMenu.show(this.annotationImage, ptMenu.x, ptMenu.y);
            this.textArea.requestFocus();
        }

        public static class AnnotationSpotState
        implements Externalizable {
            static final long serialVersionUID = -3924729488905394223L;
            int index;
            int choosingMode;
            String annotation;
            Point annotationToolTipLocation;
            Rectangle bounds;
            Color spotColor;
            boolean toolTipMode;
            Point2D[] points;

            public int getIndex() {
                return this.index;
            }

            public void setIndex(int index) {
                this.index = index;
            }

            public int getChoosingMode() {
                return this.choosingMode;
            }

            public void setChoosingMode(int choosingMode) {
                this.choosingMode = choosingMode;
            }

            public String getAnnotation() {
                return this.annotation;
            }

            public void setAnnotation(String annotation) {
                this.annotation = annotation;
            }

            public Point getAnnotationToolTipLocation() {
                return this.annotationToolTipLocation;
            }

            public void setAnnotationToolTipLocation(Point annotationToolTipLocation) {
                this.annotationToolTipLocation = annotationToolTipLocation;
            }

            public Rectangle getBounds() {
                return this.bounds;
            }

            public void setBounds(Rectangle bounds) {
                this.bounds = bounds;
            }

            public Color getSpotColor() {
                return this.spotColor;
            }

            public void setSpotColor(Color spotColor) {
                this.spotColor = spotColor;
            }

            public boolean isToolTipMode() {
                return this.toolTipMode;
            }

            public void setToolTipMode(boolean toolTipMode) {
                this.toolTipMode = toolTipMode;
            }

            public Point2D[] getPoints() {
                return this.points;
            }

            public void setPoints(Point2D[] points) {
                this.points = (Point2D[])points.clone();
            }

            @Override
            public void writeExternal(ObjectOutput out) throws IOException {
                out.writeInt(this.index);
                out.writeInt(this.choosingMode);
                out.writeUTF(this.annotation);
                out.writeObject(this.annotationToolTipLocation);
                out.writeObject(this.bounds);
                out.writeObject(this.spotColor);
                out.writeBoolean(this.toolTipMode);
                if (this.points == null) {
                    out.writeInt(-1);
                } else {
                    out.writeInt(this.points.length);
                    int i = 0;
                    while (i < this.points.length) {
                        Point2D pt = this.points[i];
                        out.writeDouble(pt.getX());
                        out.writeDouble(pt.getY());
                        ++i;
                    }
                }
            }

            @Override
            public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
                this.index = in.readInt();
                this.choosingMode = in.readInt();
                this.annotation = in.readUTF();
                this.annotationToolTipLocation = (Point)in.readObject();
                this.bounds = (Rectangle)in.readObject();
                this.spotColor = (Color)in.readObject();
                this.toolTipMode = in.readBoolean();
                int nPoints = in.readInt();
                this.points = null;
                if (nPoints >= 0) {
                    this.points = new Point2D[nPoints];
                    int i = 0;
                    while (i < nPoints) {
                        double x = in.readDouble();
                        double y = in.readDouble();
                        this.points[i] = new Point2D.Double(x, y);
                        ++i;
                    }
                }
            }
        }
    }

    public static class ModelState
    implements Serializable {
        static final long serialVersionUID = -1118530011344190681L;
        int choosingMode;
        boolean editMode;
        String imageResourceString;
        Vector annotationSpots;
        transient BufferedImage image;

        protected void updateAnnotationSpots(LinkedList list) {
            if (this.annotationSpots == null) {
                this.annotationSpots = new Vector();
            }
            this.annotationSpots.removeAllElements();
            if (list != null) {
                ListIterator it = list.listIterator();
                while (it.hasNext()) {
                    AnnotationSpot as = (AnnotationSpot)it.next();
                    this.annotationSpots.add(as.getState());
                }
            }
        }

        public int getChoosingMode() {
            return this.choosingMode;
        }

        public void setChoosingMode(int choosingMode) {
            this.choosingMode = choosingMode;
        }

        public boolean isEditMode() {
            return this.editMode;
        }

        public void setEditMode(boolean editMode) {
            this.editMode = editMode;
        }

        public String getImageResourceString() {
            return this.imageResourceString;
        }

        public void setImageResourceString(String imageResourceString) {
            this.imageResourceString = imageResourceString;
        }

        public Vector getAnnotationSpots() {
            return this.annotationSpots;
        }

        public void setAnnotationSpots(Vector annotationSpots) {
            this.annotationSpots = (Vector)annotationSpots.clone();
        }

        public BufferedImage getImage() {
            return this.image;
        }

        public void setImage(BufferedImage image) {
            this.image = image;
        }
    }

    class TranslucentGlassOp
    implements BufferedImageOp {
        int x;
        int y;
        int w = -1;
        int h = -1;

        TranslucentGlassOp(int x, int y, int w, int h) {
            this.x = x;
            this.y = y;
            this.w = w;
            this.h = h;
        }

        @Override
        public synchronized BufferedImage filter(BufferedImage src, BufferedImage dest) {
            if (dest == null) {
                dest = this.createCompatibleDestImage(src, null);
            }
            int iw = src.getWidth();
            int ih = src.getHeight();
            int ix = 0;
            while (ix < iw) {
                int iy = 0;
                while (iy < ih) {
                    int px = src.getRGB(ix, iy);
                    if (ix < this.x || ix >= this.x + this.w || iy < this.y || iy >= this.y + this.h) {
                        px = 0x44000000 | px & 0xFFFFFF;
                    }
                    dest.setRGB(ix, iy, px);
                    ++iy;
                }
                ++ix;
            }
            return dest;
        }

        @Override
        public Rectangle2D getBounds2D(BufferedImage src) {
            return src.getRaster().getBounds();
        }

        @Override
        public BufferedImage createCompatibleDestImage(BufferedImage src, ColorModel destCM) {
            if (destCM == null && (destCM = src.getColorModel()) instanceof IndexColorModel) {
                destCM = ColorModel.getRGBdefault();
            }
            int w = src.getWidth();
            int h = src.getHeight();
            return new BufferedImage(destCM, destCM.createCompatibleWritableRaster(w, h), destCM.isAlphaPremultiplied(), null);
        }

        @Override
        public Point2D getPoint2D(Point2D srcPt, Point2D dstPt) {
            if (dstPt == null) {
                dstPt = new Point2D.Float();
            }
            dstPt.setLocation(srcPt);
            return dstPt;
        }

        @Override
        public RenderingHints getRenderingHints() {
            return null;
        }

        public void setX(int x) {
            this.x = x;
        }

        public void setY(int y) {
            this.y = y;
        }

        public void setW(int w) {
            this.w = w;
        }

        public void setH(int h) {
            this.h = h;
        }

        public int getX() {
            return this.x;
        }

        public int getY() {
            return this.y;
        }

        public int getW() {
            return this.w;
        }

        public int getH() {
            return this.h;
        }
    }
}

