/*
 * Decompiled with CFR 0.152.
 */
package org.concord.swing;

import java.awt.Component;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseEvent;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.swing.JPanel;
import javax.swing.JViewport;
import org.concord.swing.Selectable;
import org.concord.swing.SelectableContainer;
import org.concord.swing.SelectableItem;
import org.concord.swing.SelectionManager;

public class NullLayoutPane
extends JPanel
implements SelectableContainer {
    private static final long serialVersionUID = -3548766787761400582L;
    public static final Point ORIGIN = new Point(0, 0);
    protected boolean editable = false;
    protected SelectionManager selectionManager;
    protected Map itemMap = new HashMap();
    protected List selectableItemFreeList = new Vector();
    protected JPanel cover = new JPanel();
    protected JViewport viewport;
    protected ComponentAdapter paneListener = new ComponentAdapter(){

        @Override
        public void componentMoved(ComponentEvent event) {
            NullLayoutPane.this.setLocation(NullLayoutPane.this.getLocation());
        }

        @Override
        public void componentResized(ComponentEvent event) {
            NullLayoutPane.this.setSize(NullLayoutPane.this.getSize());
        }

        @Override
        public void componentHidden(ComponentEvent event) {
            NullLayoutPane.this.setVisible(false);
        }

        @Override
        public void componentShown(ComponentEvent event) {
            NullLayoutPane.this.setVisible(true);
        }
    };

    public NullLayoutPane() {
        this.setLayout(null);
        this.setOpaque(false);
        this.cover.setOpaque(false);
        this.setEditable(true);
    }

    @Override
    public final void setLayout(LayoutManager manager) {
    }

    protected JViewport getViewport() {
        Container parent = this.getParent();
        while (parent != null) {
            if (parent instanceof JViewport) {
                return (JViewport)parent;
            }
            parent = parent.getParent();
        }
        return null;
    }

    @Override
    public Point getOffset() {
        if (this.viewport instanceof JViewport) {
            return this.viewport.getViewPosition();
        }
        return ORIGIN;
    }

    @Override
    public void addNotify() {
        super.addNotify();
        this.viewport = this.getViewport();
        Rectangle bounds = this.getBounds();
        this.cover.setBounds(bounds);
    }

    public boolean isEditable() {
        return this.editable;
    }

    public void setEditable(boolean value) {
        this.editable = value;
        if (this.editable) {
            if (this.selectionManager == null) {
                this.selectionManager = new SelectionManager();
                this.selectionManager.setSelectableContainer(this);
            }
            this.add((Component)this.cover, 0);
            this.cover.addComponentListener(this.paneListener);
            this.cover.addMouseListener(this.selectionManager);
            this.cover.addMouseMotionListener(this.selectionManager);
        } else {
            this.remove(this.cover);
            this.cover.removeComponentListener(this.paneListener);
            this.cover.removeMouseListener(this.selectionManager);
            this.cover.removeMouseMotionListener(this.selectionManager);
        }
    }

    @Override
    public Component add(Component item) {
        SelectableItem selectable = (SelectableItem)this.itemMap.get(item);
        if (selectable == null) {
            if (this.selectableItemFreeList.isEmpty()) {
                selectable = new SelectableItem(this);
            } else {
                selectable = (SelectableItem)this.selectableItemFreeList.get(0);
                this.selectableItemFreeList.remove(selectable);
            }
            this.itemMap.put(item, selectable);
        }
        super.add(item);
        selectable.setComponent(item);
        this.repaint();
        return item;
    }

    @Override
    public void remove(Component item) {
        Selectable selectable = (Selectable)this.itemMap.get(item);
        if (selectable != null) {
            this.itemMap.remove(item);
            super.remove(item);
            if (selectable instanceof SelectableItem) {
                this.selectableItemFreeList.add(selectable);
            }
            this.repaint();
        }
    }

    @Override
    protected void paintComponent(Graphics g) {
        for (SelectableItem item : this.itemMap.values()) {
            item.draw(g);
        }
    }

    @Override
    public Selectable findSelectable(MouseEvent event, int x, int y) {
        for (SelectableItem item : this.itemMap.values()) {
            if (!item.contains(x, y)) continue;
            return item;
        }
        return null;
    }

    @Override
    public void select(Selectable selectable, boolean multiple) {
        if (!multiple) {
            this.deselect();
        }
        selectable.setSelected(true);
        this.repaint();
    }

    @Override
    public void deselect() {
        for (SelectableItem item : this.itemMap.values()) {
            item.setSelected(false);
        }
        this.repaint();
    }

    public void moveAction(int dx, int dy, Selectable selectable) {
        SelectableItem item = (SelectableItem)selectable;
        SelectableItem.Boundary boundary = item.getBoundary();
        if (selectable.isSelected()) {
            Rectangle b = boundary.getBounds();
            boundary.setLocation(b.x + dx, b.y + dy);
        }
    }

    @Override
    public void dragAction(int dx, int dy, Selectable selectable) {
        SelectableItem item = (SelectableItem)selectable;
        SelectableItem.Boundary boundary = item.getBoundary();
        SelectableItem.Handle handle = boundary.getSelectedHandle();
        if (selectable != null && handle != null) {
            if (handle.getPosition() == 8) {
                this.moveAction(dx, dy, selectable);
            } else {
                handle.scale(dx, dy);
            }
        } else {
            Iterator selectables = this.itemMap.values().iterator();
            while (selectables.hasNext()) {
                this.moveAction(dx, dy, (Selectable)selectables.next());
            }
        }
        this.repaint();
    }

    @Override
    public void dragActionDone(Selectable selectable) {
        this.repaint();
    }

    @Override
    public Selectable getActiveObject() {
        return this.selectionManager.getActiveObject();
    }
}

