/*
 * Decompiled with CFR 0.152.
 */
package org.concord.swing;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.beans.XMLDecoder;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import javax.swing.JComponent;
import javax.swing.JLabel;
import org.concord.swing.Selectable;
import org.concord.swing.SelectionManager;

public class PageComponent
extends JComponent {
    private static final long serialVersionUID = 2278470225463856026L;
    protected Object object;
    protected Component component = new JLabel("Object");
    protected Cover cover = new Cover();
    protected SelectionManager selectionManager;
    protected boolean editable = true;

    public PageComponent(URL url) {
        this.setLayout(null);
        try {
            InputStream input = url.openStream();
            XMLDecoder decoder = new XMLDecoder(input);
            this.object = decoder.readObject();
            if (this.object instanceof Component) {
                this.component = (Component)this.object;
                this.cover.setComponent(this.component);
                this.add((Component)this.cover, 0);
                this.add(this.component, 1);
                this.component.setLocation(0, 0);
                this.validate();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void addNotify() {
        super.addNotify();
        Dimension size = this.component.getSize();
        this.cover.setSize(size);
        this.setSize(size);
    }

    public void setEditable(boolean value) {
        this.editable = value;
        if (this.editable) {
            this.add((Component)this.cover, 0);
        } else {
            this.remove(this.cover);
        }
        this.validate();
    }

    public void setSelectionManager(SelectionManager manager) {
        if (this.selectionManager != null) {
            this.cover.removeMouseListener(this.selectionManager);
            this.cover.removeMouseMotionListener(this.selectionManager);
        }
        this.selectionManager = manager;
        if (this.selectionManager != null) {
            this.cover.addMouseListener(this.selectionManager);
            this.cover.addMouseMotionListener(this.selectionManager);
        }
    }

    public Component getComponent() {
        if (this.object instanceof Component) {
            return (Component)this.object;
        }
        return this.component;
    }

    public Object getObject() {
        return this.object;
    }

    @Override
    public void setBounds(int x, int y, int width, int height) {
        super.setBounds(x, y, width, height);
        this.component.setBounds(0, 0, width, height);
        this.cover.setBounds(0, 0, width, height);
    }

    @Override
    public Dimension getMinimumSize() {
        return this.component.getMinimumSize();
    }

    @Override
    public Dimension getMaximumSize() {
        return this.component.getMaximumSize();
    }

    @Override
    public Dimension getPreferredSize() {
        return this.component.getPreferredSize();
    }

    public static class Cover
    extends JComponent
    implements ComponentListener,
    Selectable {
        protected Component component;
        protected boolean selected = false;

        public Cover() {
            this.setOpaque(false);
        }

        protected void draw(Graphics g) {
        }

        @Override
        public void paintComponent(Graphics g) {
            if (this.selected) {
                Rectangle b = this.getBounds();
                g.setXORMode(Color.white);
                g.fillRect(b.x, b.y, b.width, b.height);
                g.setPaintMode();
            }
        }

        @Override
        public Component getComponent() {
            return this.component;
        }

        public void setComponent(Component c) {
            this.component = c;
        }

        @Override
        public void componentHidden(ComponentEvent e) {
        }

        @Override
        public void componentMoved(ComponentEvent e) {
            this.setLocation(this.component.getLocation());
        }

        @Override
        public void componentResized(ComponentEvent e) {
            this.setSize(this.component.getSize());
        }

        @Override
        public void componentShown(ComponentEvent e) {
        }

        @Override
        public Dimension getPreferredSize() {
            return this.component.getPreferredSize();
        }

        @Override
        public boolean isActive() {
            return this.getParent() == null;
        }

        @Override
        public boolean isSelected() {
            return this.selected;
        }

        @Override
        public void setSelected(boolean value) {
            this.selected = value;
            this.repaint();
        }

        @Override
        public void toggleSelected() {
            this.selected = !this.selected;
            this.repaint();
        }
    }
}

