/*
 * Decompiled with CFR 0.152.
 */
package org.concord.swing;

import java.util.Hashtable;
import java.util.StringTokenizer;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;

public class PathTree
extends JTree {
    public static final int SINGLE_SELECTION = 0;
    public static final int MULTIPLE_SELECTION = 1;
    protected Hashtable objectTable = new Hashtable();
    protected String separator = "/";
    protected DefaultMutableTreeNode top;
    protected String rootName = "Root";
    protected Hashtable nodeTable = new Hashtable();

    public PathTree(String rootName) {
        this.rootName = rootName;
        this.top = new DefaultMutableTreeNode(rootName);
        ((DefaultTreeModel)this.treeModel).setRoot(this.top);
        this.getSelectionModel().setSelectionMode(1);
    }

    public void setSeparator(String sep) {
        this.separator = sep;
    }

    public String getSeparator() {
        return this.separator;
    }

    public void setSelectionMode(int selectionMode) {
        if (selectionMode == 0) {
            this.getSelectionModel().setSelectionMode(1);
        } else if (selectionMode == 1) {
            this.getSelectionModel().setSelectionMode(4);
        }
    }

    public String getPathName() {
        String pathName = "";
        TreePath treePath = this.getSelectionPath();
        if (treePath instanceof TreePath) {
            Object[] path = treePath.getPath();
            int i = 1;
            while (i < path.length) {
                pathName = String.valueOf(pathName) + this.separator + path[i].toString();
                ++i;
            }
        }
        return pathName.substring(1);
    }

    public Object getPathObject() {
        return this.objectTable.get(this.getPathName());
    }

    public void addPathObject(Object pathObject) {
        StringTokenizer tokens = new StringTokenizer(pathObject.toString(), "\\/.");
        String[] pathElements = new String[tokens.countTokens()];
        int n = 0;
        while (tokens.hasMoreTokens()) {
            pathElements[n] = tokens.nextToken();
            ++n;
        }
        this.objectTable.put(pathObject.toString(), pathObject);
        String currentPath = this.rootName;
        int i = 0;
        while (i < n) {
            String parentPath = currentPath;
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.nodeTable.get(currentPath = String.valueOf(currentPath) + this.separator + pathElements[i]);
            if (node == null) {
                node = new DefaultMutableTreeNode(pathElements[i]);
                this.nodeTable.put(currentPath, node);
                if (parentPath.equals(this.rootName)) {
                    this.top.add(node);
                } else {
                    DefaultMutableTreeNode parent = (DefaultMutableTreeNode)this.nodeTable.get(parentPath);
                    parent.add(node);
                }
            }
            ++i;
        }
    }
}

