/*
 * Decompiled with CFR 0.152.
 */
package org.concord.swing.about;

import java.io.IOException;
import java.io.InputStream;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.concord.swing.about.ParseErrorHandler;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class AboutTextFromXML {
    static String TYPE = "text/html";

    public static JTabbedPane getTabbedPane(String filename) {
        JTabbedPane tabbedPane = new JTabbedPane();
        Document mydoc = AboutTextFromXML.read(filename);
        AboutTextFromXML.parseTopLevelNode(tabbedPane, mydoc);
        return tabbedPane;
    }

    private static Document read(String filename) {
        Document document = null;
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        try {
            InputStream urlStream = AboutTextFromXML.class.getResourceAsStream(filename);
            factory.setValidating(true);
            DocumentBuilder builder = factory.newDocumentBuilder();
            builder.setEntityResolver(new EntityResolver(){

                @Override
                public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
                    try {
                        return new InputSource(AboutTextFromXML.class.getResourceAsStream("xml/about.dtd"));
                    }
                    catch (Throwable t) {
                        System.out.println(t);
                        return null;
                    }
                }
            });
            builder.setErrorHandler(new ParseErrorHandler());
            document = builder.parse(urlStream);
        }
        catch (Exception parseException) {
            System.err.println("Parse Exception " + parseException);
            System.err.println(parseException.getMessage());
            parseException.printStackTrace();
        }
        return document;
    }

    private static void parseTopLevelNode(JTabbedPane tabbedPane, Node aNode) {
        NodeList nlist = aNode.getChildNodes();
        int length = nlist.getLength();
        int i = 0;
        while (i < length) {
            Node tNode = nlist.item(i);
            if (tNode.getNodeName().equals("about")) {
                AboutTextFromXML.parseTopLevelNode(tabbedPane, tNode);
            } else if (tNode.getNodeName().equals("tab")) {
                AboutTextFromXML.parseTab(tabbedPane, tNode);
            }
            ++i;
        }
    }

    private static JComponent parseTab(JTabbedPane parent, Node aNode) {
        JEditorPane retval = null;
        String tabName = "";
        Node attributeNode = aNode.getAttributes().getNamedItem("name");
        if (attributeNode != null) {
            tabName = attributeNode.getNodeValue();
        }
        String contents = "<html>" + AboutTextFromXML.parseContents(aNode) + "</html>";
        retval = new JEditorPane(TYPE, contents);
        retval.setEditable(false);
        JScrollPane scroll = new JScrollPane(retval, 20, 31);
        if (parent != null) {
            parent.add(tabName, scroll);
        }
        return retval;
    }

    private static String parseContents(Node aNode) {
        NodeList nlist = aNode.getChildNodes();
        int length = nlist.getLength();
        StringBuffer contents = new StringBuffer();
        String name = aNode.getNodeName();
        if (name.equals("#text")) {
            contents.append(aNode.getNodeValue());
            return contents.toString();
        }
        if (!name.equals("foo")) {
            int i = 0;
            while (i < length) {
                Node tNode = nlist.item(i);
                if (tNode.getNodeName().equals("#text")) {
                    contents.append(tNode.getNodeValue());
                } else {
                    contents.append(AboutTextFromXML.parseContents(tNode));
                }
                ++i;
            }
        }
        String retval = name.equals("tab") ? contents.toString() : "<" + name + ">" + contents.toString() + "</" + name + ">";
        return retval;
    }

    public static void main(String[] args) {
        JFrame frame = new JFrame("About Box");
        JTabbedPane contents = AboutTextFromXML.getTabbedPane("SampleAboutText.xml");
        frame.getContentPane().add(contents);
        frame.pack();
        frame.show();
    }
}

