/*
 * Decompiled with CFR 0.152.
 */
package org.concord.swing.map;

import java.awt.Color;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.image.ImageObserver;
import java.util.Vector;
import org.concord.swing.map.ArcItem;
import org.concord.swing.map.MapContainer;
import org.concord.swing.map.NodeItem;

public abstract class MapItem
implements MapContainer {
    protected String name;
    protected Vector nestedNodeItems = new Vector();
    protected Vector nestedArcItems = new Vector();
    protected MapContainer parent;
    protected Image image;
    protected ImageObserver observer;
    protected Rectangle imageBounds = new Rectangle(0, 0, 50, 50);
    protected Color textColor = Color.black;
    protected int textX = 0;
    protected int textY = 0;
    protected Object data;

    protected MapItem(MapContainer container) {
        this.parent = container;
    }

    public abstract void delete();

    @Override
    public void setName(String itemName) {
        this.name = itemName;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getPathName() {
        MapContainer root = this;
        String path = "";
        while (root != null) {
            if (path.length() > 0) {
                path = "/" + path;
            }
            path = String.valueOf(root.getName()) + path;
            if (root == root.getItemParent()) break;
            root = root.getItemParent();
        }
        return path;
    }

    public abstract int getID();

    @Override
    public MapContainer getItemParent() {
        return this.parent;
    }

    public Object getData() {
        return this.data;
    }

    public void setData(Object data) {
        this.data = data;
    }

    public void setItemParent(MapContainer container) {
        this.parent = container;
    }

    public void setImage(Image image, ImageObserver observer) {
        this.observer = observer;
        this.image = image.getScaledInstance(-1, this.imageBounds.height, 4);
        this.imageBounds.width = this.image.getWidth(observer);
        this.imageBounds.height = this.image.getHeight(observer);
    }

    public abstract void translate(int var1, int var2);

    public abstract Rectangle getBounds();

    @Override
    public void initializeNode(NodeItem node, String name, int x, int y) {
        node.setName(name);
        node.setLocation(x, y);
        this.nestedNodeItems.addElement(node);
    }

    @Override
    public NodeItem createNodeItem(String name, int x, int y) {
        NodeItem node = new NodeItem(this);
        this.initializeNode(node, name, x, y);
        return node;
    }

    @Override
    public void initializeArc(ArcItem arc, NodeItem source, NodeItem sink, int x, int y) {
        if (source == null && sink == null) {
            arc.setSourceLocation(x, y);
            arc.setSinkLocation(x + 50, y + 50);
        } else {
            if (source instanceof NodeItem) {
                arc.setSourceNode(source);
            } else {
                arc.setSourceLocation(x, y);
            }
            if (sink instanceof NodeItem) {
                arc.setSinkNode(sink);
            } else {
                arc.setSinkLocation(x, y);
            }
        }
        this.nestedArcItems.addElement(arc);
    }

    @Override
    public ArcItem createArcItem(NodeItem source, NodeItem sink, int x, int y) {
        ArcItem arc = new ArcItem(this);
        this.initializeArc(arc, source, sink, x, y);
        return arc;
    }

    @Override
    public Vector getArcItems() {
        return this.nestedArcItems;
    }

    @Override
    public Vector getNodeItems() {
        return this.nestedNodeItems;
    }

    @Override
    public void removeArcItem(ArcItem arc) {
        this.nestedArcItems.removeElement(arc);
    }

    @Override
    public void removeNodeItem(NodeItem node) {
        this.nestedNodeItems.removeElement(node);
    }
}

