/*
 * Decompiled with CFR 0.152.
 */
package org.concord.swing.util;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.image.BufferedImage;
import java.io.File;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Vector;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import org.concord.swing.CCJFileChooser;
import org.concord.swing.util.ComponentScreenshot;
import org.concord.swing.util.ImageFileFilter;

public class Util {
    public static int getIntColorFromStringColor(String linkColor) {
        if (linkColor == null) {
            return 0;
        }
        String str = linkColor;
        if (linkColor.length() > 6) {
            str = linkColor.substring(0, 6);
        } else if (linkColor.length() < 6) {
            int addZero = 6 - linkColor.length();
            int i = 0;
            while (i < addZero) {
                str = String.valueOf(str) + "0";
                ++i;
            }
        }
        int color = 0;
        int rColor = Util.getIntFromHexString(str.substring(0, 2));
        color |= (rColor <<= 16);
        int gColor = Util.getIntFromHexString(str.substring(2, 4));
        color |= (gColor <<= 8);
        int bColor = Util.getIntFromHexString(str.substring(4, 6));
        return color |= bColor;
    }

    public static float getFloatFromString(String str) {
        float retValue = 0.0f;
        try {
            retValue = Float.valueOf(str).floatValue();
        }
        catch (Exception te) {
            retValue = Float.NaN;
        }
        return retValue;
    }

    public static int getIntFromString(String str) {
        return Util.getIntFromString(str, 0);
    }

    public static int getIntFromString(String str, int defValue) {
        int retValue = defValue;
        try {
            retValue = Integer.parseInt(str);
        }
        catch (Exception te) {
            retValue = defValue;
        }
        return retValue;
    }

    public static boolean getBooleanFromString(String str) {
        if (str == null) {
            return false;
        }
        return str.equals("true");
    }

    public static int getIntFromHexString(String str) {
        int retValue = 0;
        if (str == null || str.length() < 1) {
            return retValue;
        }
        int multiplayer = 1;
        int i = str.length() - 1;
        while (i >= 0) {
            retValue += multiplayer * Util.getIntFromHexChar(str.charAt(i));
            multiplayer <<= 4;
            --i;
        }
        return retValue;
    }

    public static int getIntFromHexChar(char c) {
        if (c >= '0' && c <= '9') {
            return c - 48;
        }
        if (c >= 'a' && c <= 'f') {
            return 10 + (c - 97);
        }
        if (c >= 'A' && c <= 'F') {
            return 10 + (c - 65);
        }
        return 0;
    }

    public static boolean equalWithTolerance(float a, float b, float eps) {
        if (a == 0.0f) {
            return Math.abs(a) < eps;
        }
        return Math.abs((a - b) / a) < eps;
    }

    public static boolean equalWithTolerance(double a, double b, double eps) {
        if (a == 0.0) {
            return Math.abs(a) < eps;
        }
        return Math.abs((a - b) / a) < eps;
    }

    public static void setAntialisingWithReflection(Graphics g, boolean on) {
        try {
            Class<?> clss1 = Class.forName("java.awt.RenderingHints");
            Class<?> clss2 = Class.forName("java.awt.RenderingHints$Key");
            Method m = g.getClass().getMethod("setRenderingHint", clss2, Object.class);
            Field f1 = clss1.getField("KEY_ANTIALIASING");
            Field f2 = on ? clss1.getField("VALUE_ANTIALIAS_ON") : clss1.getField("VALUE_ANTIALIAS_OFF");
            m.invoke((Object)g, f1.get(null), f2.get(null));
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static String getSharedFolderPath() {
        int kSharedUserDataFolder = 1935958388;
        return Util.getFolderPath(kSharedUserDataFolder);
    }

    public static String getApplicationFolderPath() {
        int kApplicationFolder = 1634758771;
        return Util.getFolderPath(kApplicationFolder);
    }

    public static String getGlobalApplicationFolderPath() {
        int kApplicationFolder = 1634758771;
        short kSystemDomain = -32766;
        return Util.getFolderPath(kSystemDomain, kApplicationFolder);
    }

    public static String getFolderPath(int folderKind) {
        try {
            Class<?> clazz = Class.forName("com.apple.eio.FileManager");
            Method m = clazz.getMethod("findFolder", Integer.TYPE);
            return (String)m.invoke(null, new Integer(folderKind));
        }
        catch (Throwable clazz) {
            try {
                Class<?> clazz2 = Class.forName("com.apple.mrj.MRJFileUtils");
                Class<?> macOsTypeClazz = Class.forName("com.apple.mrj.MRJOSType");
                Constructor<?> c = macOsTypeClazz.getConstructor(Integer.TYPE);
                Object macOsType = c.newInstance(new Integer(folderKind));
                Method m = clazz2.getMethod("findFolder", macOsTypeClazz);
                return ((File)m.invoke(null, macOsType)).getCanonicalPath();
            }
            catch (Throwable throwable) {
                return null;
            }
        }
    }

    public static String getFolderPath(short domain, int folderKind) {
        try {
            Class<?> clazz = Class.forName("com.apple.eio.FileManager");
            Method m = clazz.getMethod("findFolder", Short.TYPE, Integer.TYPE);
            return (String)m.invoke(null, new Short(domain), new Integer(folderKind));
        }
        catch (Throwable clazz) {
            try {
                Class<?> clazz2 = Class.forName("com.apple.mrj.MRJFileUtils");
                Class<?> macOsTypeClazz = Class.forName("com.apple.mrj.MRJOSType");
                Constructor<?> c = macOsTypeClazz.getConstructor(Integer.TYPE);
                Object macOsType = c.newInstance(new Integer(folderKind));
                Method m = clazz2.getMethod("findFolder", Short.TYPE, macOsTypeClazz);
                return ((File)m.invoke(null, new Short(domain), macOsType)).getCanonicalPath();
            }
            catch (Throwable throwable) {
                return null;
            }
        }
    }

    public static void sortInsert(Vector list, Object item) {
        int n = list.size();
        int i = 0;
        while (i < n) {
            Object element = list.elementAt(i);
            if (item.toString().compareTo(element.toString()) <= 0) {
                list.insertElementAt(item, i);
                return;
            }
            ++i;
        }
        list.addElement(item);
    }

    public static void makeScreenShot(Component component) {
        Util.makeScreenShot(component, 1.0f, 1.0f);
    }

    public static void makeScreenShot(Component component, float xScaleArg, float yScaleArg) {
        if (component == null) {
            return;
        }
        if (component instanceof JFrame) {
            component = ((JFrame)component).getContentPane();
        }
        final Component compForPicture = component;
        final float xScale = xScaleArg;
        final float yScale = yScaleArg;
        boolean dispatchThread = SwingUtilities.isEventDispatchThread();
        Runnable screenShotRunnable = new Runnable(){

            @Override
            public void run() {
                CCJFileChooser chooser = new CCJFileChooser(compForPicture.getClass().getName());
                chooser.setMultiSelectionEnabled(false);
                chooser.setFileFilter(new ImageFileFilter());
                int retValue = chooser.showSaveDialog(SwingUtilities.getRoot(compForPicture));
                if (retValue == 0) {
                    File fileToSave = chooser.getSelectedFile();
                    if (!fileToSave.getName().toLowerCase().endsWith(".png")) {
                        fileToSave = new File(String.valueOf(fileToSave.getAbsolutePath()) + ".png");
                    }
                    if (!fileToSave.exists() || this.checkForReplace(fileToSave)) {
                        try {
                            BufferedImage bim = ComponentScreenshot.makeComponentImageAlpha(compForPicture, xScale, yScale);
                            ComponentScreenshot.saveImageAsFile(bim, fileToSave, "png");
                        }
                        catch (Throwable t) {
                            System.out.println("make screenshot Throwable " + t);
                        }
                    }
                }
            }

            boolean checkForReplace(File file) {
                if (file == null || !file.exists()) {
                    return false;
                }
                Object[] options = new Object[]{"Yes", "No"};
                return JOptionPane.showOptionDialog(null, "The file '" + file.getName() + "' already exists.  " + "Replace existing file?", "Warning", 0, 2, null, options, options[1]) == 0;
            }
        };
        if (dispatchThread) {
            screenShotRunnable.run();
        } else {
            try {
                SwingUtilities.invokeAndWait(screenShotRunnable);
            }
            catch (Throwable t) {
                System.out.println("makeScreenShot throwable " + t);
            }
        }
    }
}

