/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.wc;

import java.io.File;
import java.util.ArrayList;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNProperties;
import org.tmatesoft.svn.core.SVNPropertyValue;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.auth.ISVNAuthenticationProvider;
import org.tmatesoft.svn.core.auth.SVNAuthentication;
import org.tmatesoft.svn.core.auth.SVNPasswordAuthentication;
import org.tmatesoft.svn.core.auth.SVNSSHAuthentication;
import org.tmatesoft.svn.core.auth.SVNSSLAuthentication;
import org.tmatesoft.svn.core.auth.SVNUserNameAuthentication;
import org.tmatesoft.svn.core.internal.util.SVNHashMap;
import org.tmatesoft.svn.core.internal.util.jna.SVNJNAUtil;
import org.tmatesoft.svn.core.internal.wc.DefaultSVNOptions;
import org.tmatesoft.svn.core.internal.wc.ISVNAuthenticationStorageOptions;
import org.tmatesoft.svn.core.internal.wc.ISVNGnomeKeyringPasswordProvider;
import org.tmatesoft.svn.core.internal.wc.ISVNHostOptions;
import org.tmatesoft.svn.core.internal.wc.ISVNHostOptionsProvider;
import org.tmatesoft.svn.core.internal.wc.ISVNPersistentAuthenticationProvider;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.core.internal.wc.SVNFileListUtil;
import org.tmatesoft.svn.core.internal.wc.SVNFileUtil;
import org.tmatesoft.svn.core.internal.wc.SVNWCProperties;
import org.tmatesoft.svn.util.SVNLogType;

public class DefaultSVNPersistentAuthenticationProvider
implements ISVNAuthenticationProvider,
ISVNPersistentAuthenticationProvider {
    public static final String WINDOWS_CRYPTO_API_PASSWORD_STORAGE = "windows-cryptoapi";
    public static final String MAC_OS_KEYCHAIN_PASSWORD_STORAGE = "keychain";
    public static final String GNOME_KEYRING_PASSWORD_STORAGE = "gnome-keyring";
    public static final String SIMPLE_PASSTYPE = "simple";
    public static final String WIN_CRYPT_PASSTYPE = "wincrypt";
    public static final String MAC_OS_KEYCHAIN_PASSTYPE = "keychain";
    public static final String GNOME_KEYRING_PASSTYPE = "gnome-keyring";
    private File myDirectory;
    private String myUserName;
    private IPasswordStorage[] myPasswordStorages;
    private ISVNAuthenticationStorageOptions myAuthOptions;
    private DefaultSVNOptions myDefaultOptions;
    private ISVNHostOptionsProvider myHostOptionsProvider;

    protected DefaultSVNPersistentAuthenticationProvider(File directory, String userName, ISVNAuthenticationStorageOptions authOptions, DefaultSVNOptions defaultOptions, ISVNHostOptionsProvider hostOptionsProvider) {
        this.myDirectory = directory;
        this.myUserName = userName;
        this.myAuthOptions = authOptions;
        this.myDefaultOptions = defaultOptions;
        this.myHostOptionsProvider = hostOptionsProvider;
        this.myPasswordStorages = this.createPasswordStorages(defaultOptions);
    }

    protected IPasswordStorage[] createPasswordStorages(DefaultSVNOptions options) {
        ArrayList<IPasswordStorage> storages = new ArrayList<IPasswordStorage>();
        String[] passwordStorageTypes = options.getPasswordStorageTypes();
        for (int i = 0; i < passwordStorageTypes.length; ++i) {
            String passwordStorageType = passwordStorageTypes[i];
            if (WINDOWS_CRYPTO_API_PASSWORD_STORAGE.equals(passwordStorageType) && SVNJNAUtil.isWinCryptEnabled()) {
                storages.add(new WinCryptPasswordStorage());
            }
            if ("keychain".equals(passwordStorageType) && SVNJNAUtil.isMacOsKeychainEnabled()) {
                storages.add(new MacOsKeychainPasswordStorage());
            }
            if (!"gnome-keyring".equals(passwordStorageType) || !SVNJNAUtil.isGnomeKeyringEnabled()) continue;
            storages.add(new GnomeKeyringPasswordStorage());
        }
        storages.add(new SimplePasswordStorage());
        return storages.toArray(new IPasswordStorage[storages.size()]);
    }

    private IPasswordStorage getPasswordStorage(String passType) {
        if (passType == null) {
            return null;
        }
        for (int i = 0; i < this.myPasswordStorages.length; ++i) {
            IPasswordStorage passwordStorage = this.myPasswordStorages[i];
            if (!passwordStorage.getPassType().equals(passType)) continue;
            return passwordStorage;
        }
        return null;
    }

    private SVNPasswordAuthentication readSSLPassphrase(String kind, String realm, boolean storageAllowed, SVNURL url) {
        File dir = new File(this.myDirectory, kind);
        if (!dir.isDirectory()) {
            return null;
        }
        File[] files = SVNFileListUtil.listFiles(dir);
        SVNHashMap matchedAuths = new SVNHashMap();
        for (int i = 0; files != null && i < files.length; ++i) {
            File authFile = files[i];
            if (!authFile.isFile()) continue;
            SVNWCProperties props = new SVNWCProperties(authFile, "");
            try {
                SVNPasswordAuthentication auth = this.readSSLPassphrase(realm, props);
                if (auth == null) continue;
                matchedAuths.put(auth.getUserName(), auth);
                continue;
            }
            catch (SVNException e) {
                // empty catch block
            }
        }
        if (matchedAuths.isEmpty()) {
            return null;
        }
        SVNPasswordAuthentication matchedAuth = (SVNPasswordAuthentication)matchedAuths.values().iterator().next();
        if (matchedAuths.containsKey(realm)) {
            matchedAuth = (SVNPasswordAuthentication)matchedAuths.get(realm);
        }
        if (matchedAuth != null) {
            return new SVNPasswordAuthentication("", matchedAuth.getPassword(), storageAllowed, url, false);
        }
        return null;
    }

    private SVNPasswordAuthentication readSSLPassphrase(String expectedCertificatePath, SVNWCProperties props) throws SVNException {
        File storedPath;
        SVNProperties values = props.asMap();
        String storedRealm = values.getStringValue("svn:realmstring");
        if (storedRealm == null || !SVNSSLAuthentication.isCertificatePath(storedRealm)) {
            return null;
        }
        File expectedPath = new File(expectedCertificatePath.replace(File.separatorChar, '/')).getAbsoluteFile();
        if (!expectedPath.equals(storedPath = new File(storedRealm.replace(File.separatorChar, '/')).getAbsoluteFile())) {
            return null;
        }
        String passType = SVNPropertyValue.getPropertyAsString(values.getSVNPropertyValue("passtype"));
        IPasswordStorage passwordStorage = this.getPasswordStorage(passType);
        if (passType != null && passwordStorage == null) {
            return null;
        }
        String passphrase = passwordStorage != null ? passwordStorage.readPassphrase(storedRealm, values) : SVNPropertyValue.getPropertyAsString(values.getSVNPropertyValue("passphrase"));
        return new SVNPasswordAuthentication(storedRealm, passphrase, false, null, false);
    }

    private String readPassword(String realm, String userName, IPasswordStorage passwordStorage, SVNProperties authValues) throws SVNException {
        if (passwordStorage != null) {
            return passwordStorage.readPassword(realm, userName, authValues);
        }
        return SVNPropertyValue.getPropertyAsString(authValues.getSVNPropertyValue("password"));
    }

    private String readPassphrase(String realm, IPasswordStorage passwordStorage, SVNProperties authValues) throws SVNException {
        if (passwordStorage != null) {
            return passwordStorage.readPassphrase(realm, authValues);
        }
        return SVNPropertyValue.getPropertyAsString(authValues.getSVNPropertyValue("passphrase"));
    }

    public SVNAuthentication requestClientAuthentication(String kind, SVNURL url, String realm, SVNErrorMessage errorMessage, SVNAuthentication previousAuth, boolean authMayBeStored) {
        block26: {
            File dir;
            if ("svn.ssl.client-passphrase".equals(kind)) {
                if (SVNSSLAuthentication.isCertificatePath(realm)) {
                    return this.readSSLPassphrase(kind, realm, authMayBeStored, url);
                }
                ISVNHostOptions hostOptions = this.myHostOptionsProvider.getHostOptions(url);
                String sslClientCert = hostOptions.getSSLClientCertFile();
                if (sslClientCert != null && !"".equals(sslClientCert)) {
                    SVNPasswordAuthentication passphrase;
                    if (this.isMSCapi(sslClientCert)) {
                        String alias = null;
                        if (sslClientCert.lastIndexOf(59) > 0) {
                            alias = sslClientCert.substring(sslClientCert.lastIndexOf(59) + 1);
                        }
                        return new SVNSSLAuthentication("MSCAPI", alias, authMayBeStored, url, false);
                    }
                    String sslClientCertPassword = hostOptions.getSSLClientCertPassword();
                    File clientCertFile = sslClientCert != null ? new File(sslClientCert) : null;
                    SVNSSLAuthentication sslAuth = new SVNSSLAuthentication(clientCertFile, sslClientCertPassword, authMayBeStored, url, false);
                    if ((sslClientCertPassword == null || "".equals(sslClientCertPassword)) && (passphrase = this.readSSLPassphrase(kind, sslClientCert, authMayBeStored, url)) != null && passphrase.getPassword() != null) {
                        sslAuth = new SVNSSLAuthentication(clientCertFile, passphrase.getPassword(), authMayBeStored, url, false);
                    }
                    sslAuth.setCertificatePath(sslClientCert);
                    return sslAuth;
                }
            }
            if (!(dir = new File(this.myDirectory, kind)).isDirectory()) {
                return null;
            }
            String fileName = SVNFileUtil.computeChecksum(realm);
            File authFile = new File(dir, fileName);
            if (authFile.exists()) {
                SVNWCProperties props = new SVNWCProperties(authFile, "");
                try {
                    SVNProperties values = props.asMap();
                    String storedRealm = values.getStringValue("svn:realmstring");
                    String passType = SVNPropertyValue.getPropertyAsString(values.getSVNPropertyValue("passtype"));
                    IPasswordStorage passwordStorage = this.getPasswordStorage(passType);
                    if (passType != null && passwordStorage == null) {
                        return null;
                    }
                    if (storedRealm == null || !storedRealm.equals(realm)) {
                        return null;
                    }
                    String userName = SVNPropertyValue.getPropertyAsString(values.getSVNPropertyValue("username"));
                    if (!"svn.ssl.client-passphrase".equals(kind)) {
                        if (userName == null || "".equals(userName.trim())) {
                            return null;
                        }
                        if (this.myUserName != null && !this.myUserName.equals(userName)) {
                            return null;
                        }
                    }
                    String path = SVNPropertyValue.getPropertyAsString(values.getSVNPropertyValue("key"));
                    String port = SVNPropertyValue.getPropertyAsString(values.getSVNPropertyValue("port"));
                    port = port == null ? "" + this.myDefaultOptions.getDefaultSSHPortNumber() : port;
                    String sslKind = SVNPropertyValue.getPropertyAsString(values.getSVNPropertyValue("ssl-kind"));
                    if ("svn.simple".equals(kind)) {
                        String password = this.readPassword(realm, userName, passwordStorage, values);
                        if (password == null) {
                            return new SVNPasswordAuthentication(userName, password, authMayBeStored, null, true);
                        }
                        return new SVNPasswordAuthentication(userName, password, authMayBeStored, url, false);
                    }
                    if ("svn.ssh".equals(kind)) {
                        int portNumber;
                        try {
                            portNumber = Integer.parseInt(port);
                        }
                        catch (NumberFormatException nfe) {
                            portNumber = this.myDefaultOptions.getDefaultSSHPortNumber();
                        }
                        if (path != null) {
                            String passphrase = this.readPassphrase(storedRealm, passwordStorage, values);
                            return new SVNSSHAuthentication(userName, new File(path), passphrase, portNumber, authMayBeStored, url, false);
                        }
                        String password = this.readPassword(realm, userName, passwordStorage, values);
                        if (password != null) {
                            return new SVNSSHAuthentication(userName, password, portNumber, authMayBeStored, url, false);
                        }
                        break block26;
                    }
                    if ("svn.username".equals(kind)) {
                        return new SVNUserNameAuthentication(userName, authMayBeStored, url, false);
                    }
                    if ("svn.ssl.client-passphrase".equals(kind)) {
                        SVNPasswordAuthentication passphraseAuth;
                        if (this.isMSCapi(sslKind)) {
                            String alias = SVNPropertyValue.getPropertyAsString(values.getSVNPropertyValue("alias"));
                            return new SVNSSLAuthentication("MSCAPI", alias, authMayBeStored, url, false);
                        }
                        String passphrase = this.readPassphrase(storedRealm, passwordStorage, values);
                        SVNSSLAuthentication sslAuth = new SVNSSLAuthentication(new File(path), passphrase, authMayBeStored, url, false);
                        if ((passphrase == null || "".equals(passphrase)) && (passphraseAuth = this.readSSLPassphrase(kind, path, authMayBeStored, url)) != null && passphraseAuth.getPassword() != null) {
                            sslAuth = new SVNSSLAuthentication(new File(path), passphraseAuth.getPassword(), authMayBeStored, url, false);
                        }
                        sslAuth.setCertificatePath(path);
                        return sslAuth;
                    }
                }
                catch (SVNException e) {
                    // empty catch block
                }
            }
        }
        return null;
    }

    public boolean isMSCapi(String filepath) {
        return filepath != null && filepath.startsWith("MSCAPI");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveAuthentication(SVNAuthentication auth, String kind, String realm) throws SVNException {
        File dir = new File(this.myDirectory, kind);
        if (!dir.exists()) {
            dir.mkdirs();
        }
        if (!dir.isDirectory()) {
            SVNErrorMessage error = SVNErrorMessage.create(SVNErrorCode.IO_ERROR, "Cannot create directory ''{0}''", (Object)dir.getAbsolutePath());
            SVNErrorManager.error(error, SVNLogType.DEFAULT);
        }
        if (!"svn.ssl.client-passphrase".equals(kind) && ("".equals(auth.getUserName()) || auth.getUserName() == null)) {
            return;
        }
        SVNProperties values = new SVNProperties();
        values.put("svn:realmstring", realm);
        if ("svn.simple".equals(kind)) {
            this.savePasswordCredential(values, auth, realm);
        } else if ("svn.ssh".equals(kind)) {
            this.saveSSHCredential(values, auth, realm);
        } else if ("svn.ssl.client-passphrase".equals(kind)) {
            if (!this.saveSSLCredential(values, auth, realm)) {
                return;
            }
        } else if ("svn.username".equals(kind)) {
            this.saveUserNameCredential(values, auth);
        }
        String fileName = SVNFileUtil.computeChecksum(realm);
        File authFile = new File(dir, fileName);
        if (authFile.isFile()) {
            SVNWCProperties props = new SVNWCProperties(authFile, "");
            try {
                if (values.equals(props.asMap())) {
                    return;
                }
            }
            catch (SVNException e) {
                // empty catch block
            }
        }
        File tmpFile = SVNFileUtil.createUniqueFile(dir, "auth", ".tmp", true);
        try {
            SVNWCProperties.setProperties(values, authFile, tmpFile, "END");
        }
        finally {
            SVNFileUtil.deleteFile(tmpFile);
        }
    }

    public int acceptServerAuthentication(SVNURL url, String r, Object serverAuth, boolean resultMayBeStored) {
        return 2;
    }

    private void saveUserNameCredential(SVNProperties values, SVNAuthentication auth) {
        values.put("username", auth.getUserName());
    }

    private void savePasswordCredential(SVNProperties values, SVNAuthentication auth, String realm) throws SVNException {
        String userName = auth.getUserName();
        values.put("username", userName);
        boolean storePasswords = this.myHostOptionsProvider.getHostOptions(auth.getURL()).isStorePasswords();
        if (storePasswords) {
            SVNPasswordAuthentication passwordAuth = (SVNPasswordAuthentication)auth;
            for (int i = 0; i < this.myPasswordStorages.length; ++i) {
                IPasswordStorage passwordStorage = this.myPasswordStorages[i];
                boolean saved = passwordStorage.savePassword(realm, passwordAuth.getPassword(), passwordAuth, values);
                if (!saved) continue;
                values.put("passtype", passwordStorage.getPassType());
                break;
            }
        }
    }

    private void saveSSHCredential(SVNProperties values, SVNAuthentication auth, String realm) throws SVNException {
        values.put("username", auth.getUserName());
        SVNSSHAuthentication sshAuth = (SVNSSHAuthentication)auth;
        boolean storePasswords = this.myHostOptionsProvider.getHostOptions(auth.getURL()).isStorePasswords();
        IPasswordStorage storage = null;
        if (storePasswords) {
            for (int i = 0; i < this.myPasswordStorages.length; ++i) {
                IPasswordStorage passwordStorage = this.myPasswordStorages[i];
                boolean saved = passwordStorage.savePassword(realm, sshAuth.getPassword(), auth, values);
                if (!saved) continue;
                values.put("passtype", passwordStorage.getPassType());
                storage = passwordStorage;
                break;
            }
        }
        int port = sshAuth.getPortNumber();
        if (sshAuth.getPortNumber() < 0) {
            port = this.myDefaultOptions.getDefaultSSHPortNumber();
        }
        values.put("port", Integer.toString(port));
        if (sshAuth.getPrivateKeyFile() != null) {
            String path = sshAuth.getPrivateKeyFile().getAbsolutePath();
            if (storage != null) {
                storage.savePassphrase(realm, sshAuth.getPassphrase(), sshAuth, values, true);
            } else {
                for (int i = 0; i < this.myPasswordStorages.length; ++i) {
                    IPasswordStorage passwordStorage = this.myPasswordStorages[i];
                    boolean saved = passwordStorage.savePassphrase(realm, sshAuth.getPassphrase(), sshAuth, values, false);
                    if (!saved) continue;
                    values.put("passtype", passwordStorage.getPassType());
                    break;
                }
            }
            values.put("key", path);
        }
    }

    private boolean saveSSLCredential(SVNProperties values, SVNAuthentication auth, String realm) throws SVNException {
        boolean storePassphrases = this.myHostOptionsProvider.getHostOptions(auth.getURL()).isStoreSSLClientCertificatePassphrases();
        boolean modified = false;
        Object passphrase = auth instanceof SVNPasswordAuthentication ? ((SVNPasswordAuthentication)auth).getPassword() : (this.myAuthOptions.isSSLPassphrasePromptSupported() ? null : (auth instanceof SVNSSLAuthentication ? ((SVNSSLAuthentication)auth).getPassword() : null));
        if (storePassphrases && passphrase != null) {
            for (int i = 0; i < this.myPasswordStorages.length; ++i) {
                IPasswordStorage passwordStorage = this.myPasswordStorages[i];
                boolean saved = passwordStorage.savePassphrase(realm, (String)passphrase, auth, values, false);
                if (!saved) continue;
                values.put("passtype", passwordStorage.getPassType());
                modified = true;
                break;
            }
        }
        if (auth instanceof SVNSSLAuthentication) {
            SVNSSLAuthentication sslAuth = (SVNSSLAuthentication)auth;
            if ("SSL".equals(sslAuth.getSSLKind())) {
                if (sslAuth.getCertificateFile() != null) {
                    String path = sslAuth.getCertificatePath();
                    values.put("key", path);
                    modified = true;
                }
            } else if ("MSCAPI".equals(sslAuth.getSSLKind())) {
                values.put("ssl-kind", sslAuth.getSSLKind());
                values.put("alias", sslAuth.getAlias());
                modified = true;
            }
        }
        return modified;
    }

    public byte[] loadFingerprints(String realm) {
        File dir = new File(this.myDirectory, "svn.ssh.server");
        if (!dir.isDirectory()) {
            return null;
        }
        File file = new File(dir, SVNFileUtil.computeChecksum(realm));
        if (!file.isFile()) {
            return null;
        }
        SVNWCProperties props = new SVNWCProperties(file, "");
        try {
            SVNProperties values = props.asMap();
            String storedRealm = values.getStringValue("svn:realmstring");
            if (!realm.equals(storedRealm)) {
                return null;
            }
            return values.getBinaryValue("hostkey");
        }
        catch (SVNException e) {
            return null;
        }
    }

    public void saveFingerprints(String realm, byte[] fingerprints) {
        File dir = new File(this.myDirectory, "svn.ssh.server");
        if (!dir.isDirectory()) {
            dir.mkdirs();
        }
        File file = new File(dir, SVNFileUtil.computeChecksum(realm));
        SVNProperties values = new SVNProperties();
        values.put("svn:realmstring", realm);
        values.put("hostkey", fingerprints);
        try {
            SVNWCProperties.setProperties(values, file, null, "END");
        }
        catch (SVNException e) {
            // empty catch block
        }
    }

    protected class GnomeKeyringPasswordStorage
    implements IPasswordStorage {
        protected GnomeKeyringPasswordStorage() {
        }

        public String getPassType() {
            return "gnome-keyring";
        }

        public boolean savePassword(String realm, String password, SVNAuthentication auth, SVNProperties authParameters) throws SVNException {
            if (password == null) {
                return false;
            }
            boolean nonInteractive = DefaultSVNPersistentAuthenticationProvider.this.myAuthOptions.isNonInteractive();
            ISVNGnomeKeyringPasswordProvider keyringPasswordProvider = DefaultSVNPersistentAuthenticationProvider.this.myAuthOptions.getGnomeKeyringPasswordProvider();
            return SVNJNAUtil.addPasswordToGnomeKeyring(realm, auth.getUserName(), password, nonInteractive, keyringPasswordProvider);
        }

        public String readPassword(String realm, String userName, SVNProperties authParameters) throws SVNException {
            boolean nonInteractive = DefaultSVNPersistentAuthenticationProvider.this.myAuthOptions.isNonInteractive();
            ISVNGnomeKeyringPasswordProvider keyringPasswordProvider = DefaultSVNPersistentAuthenticationProvider.this.myAuthOptions.getGnomeKeyringPasswordProvider();
            return SVNJNAUtil.getPasswordFromGnomeKeyring(realm, userName, nonInteractive, keyringPasswordProvider);
        }

        public boolean savePassphrase(String realm, String passphrase, SVNAuthentication auth, SVNProperties authParameters, boolean force) throws SVNException {
            if (passphrase == null) {
                return false;
            }
            boolean nonInteractive = DefaultSVNPersistentAuthenticationProvider.this.myAuthOptions.isNonInteractive();
            ISVNGnomeKeyringPasswordProvider keyringPasswordProvider = DefaultSVNPersistentAuthenticationProvider.this.myAuthOptions.getGnomeKeyringPasswordProvider();
            return SVNJNAUtil.addPasswordToGnomeKeyring(realm, null, passphrase, nonInteractive, keyringPasswordProvider);
        }

        public String readPassphrase(String realm, SVNProperties authParameters) throws SVNException {
            boolean nonInteractive = DefaultSVNPersistentAuthenticationProvider.this.myAuthOptions.isNonInteractive();
            ISVNGnomeKeyringPasswordProvider keyringPasswordProvider = DefaultSVNPersistentAuthenticationProvider.this.myAuthOptions.getGnomeKeyringPasswordProvider();
            return SVNJNAUtil.getPasswordFromGnomeKeyring(realm, null, nonInteractive, keyringPasswordProvider);
        }
    }

    protected class MacOsKeychainPasswordStorage
    implements IPasswordStorage {
        protected MacOsKeychainPasswordStorage() {
        }

        public String getPassType() {
            return "keychain";
        }

        public boolean savePassword(String realm, String password, SVNAuthentication auth, SVNProperties authParameters) throws SVNException {
            if (password == null) {
                return false;
            }
            return SVNJNAUtil.addPasswordToMacOsKeychain(realm, auth.getUserName(), password, DefaultSVNPersistentAuthenticationProvider.this.myAuthOptions.isNonInteractive());
        }

        public String readPassword(String realm, String userName, SVNProperties authParameters) throws SVNException {
            return SVNJNAUtil.getPasswordFromMacOsKeychain(realm, userName, DefaultSVNPersistentAuthenticationProvider.this.myAuthOptions.isNonInteractive());
        }

        public boolean savePassphrase(String realm, String passphrase, SVNAuthentication auth, SVNProperties authParameters, boolean force) throws SVNException {
            if (passphrase == null) {
                return false;
            }
            return SVNJNAUtil.addPasswordToMacOsKeychain(realm, null, passphrase, DefaultSVNPersistentAuthenticationProvider.this.myAuthOptions.isNonInteractive());
        }

        public String readPassphrase(String realm, SVNProperties authParameters) throws SVNException {
            return SVNJNAUtil.getPasswordFromMacOsKeychain(realm, null, DefaultSVNPersistentAuthenticationProvider.this.myAuthOptions.isNonInteractive());
        }
    }

    protected class WinCryptPasswordStorage
    implements IPasswordStorage {
        protected WinCryptPasswordStorage() {
        }

        public String getPassType() {
            return DefaultSVNPersistentAuthenticationProvider.WIN_CRYPT_PASSTYPE;
        }

        public boolean savePassword(String realm, String password, SVNAuthentication auth, SVNProperties authParameters) {
            if (password == null) {
                return false;
            }
            String encrypted = SVNJNAUtil.encrypt(password);
            if (encrypted == null) {
                return false;
            }
            authParameters.put("password", encrypted);
            return true;
        }

        public String readPassword(String realm, String userName, SVNProperties authParameters) {
            String encrypted = SVNPropertyValue.getPropertyAsString(authParameters.getSVNPropertyValue("password"));
            return SVNJNAUtil.decrypt(encrypted);
        }

        public boolean savePassphrase(String realm, String passphrase, SVNAuthentication auth, SVNProperties authParameters, boolean force) {
            if (passphrase == null) {
                return false;
            }
            String encrypted = SVNJNAUtil.encrypt(passphrase);
            if (encrypted == null) {
                return false;
            }
            authParameters.put("passphrase", encrypted);
            return true;
        }

        public String readPassphrase(String realm, SVNProperties authParameters) {
            String encrypted = SVNPropertyValue.getPropertyAsString(authParameters.getSVNPropertyValue("passphrase"));
            return SVNJNAUtil.decrypt(encrypted);
        }
    }

    protected class SimplePasswordStorage
    implements IPasswordStorage {
        protected SimplePasswordStorage() {
        }

        public String getPassType() {
            return DefaultSVNPersistentAuthenticationProvider.SIMPLE_PASSTYPE;
        }

        public boolean savePassword(String realm, String password, SVNAuthentication auth, SVNProperties authParameters) throws SVNException {
            if (password == null || auth == null) {
                return false;
            }
            ISVNHostOptions opts = DefaultSVNPersistentAuthenticationProvider.this.myHostOptionsProvider.getHostOptions(auth == null ? null : auth.getURL());
            if (opts.isStorePlainTextPasswords(realm, auth)) {
                authParameters.put("password", password);
                return true;
            }
            return false;
        }

        public String readPassword(String realm, String userName, SVNProperties authParameters) {
            return SVNPropertyValue.getPropertyAsString(authParameters.getSVNPropertyValue("password"));
        }

        public boolean savePassphrase(String realm, String passphrase, SVNAuthentication auth, SVNProperties authParameters, boolean force) throws SVNException {
            if (passphrase == null || auth == null) {
                return false;
            }
            ISVNHostOptions opts = DefaultSVNPersistentAuthenticationProvider.this.myHostOptionsProvider.getHostOptions(auth == null ? null : auth.getURL());
            if (force || opts.isStorePlainTextPassphrases(realm, auth)) {
                authParameters.put("passphrase", passphrase);
                return true;
            }
            return false;
        }

        public String readPassphrase(String realm, SVNProperties authParameters) {
            return SVNPropertyValue.getPropertyAsString(authParameters.getSVNPropertyValue("passphrase"));
        }
    }

    public static interface IPasswordStorage {
        public String getPassType();

        public boolean savePassword(String var1, String var2, SVNAuthentication var3, SVNProperties var4) throws SVNException;

        public String readPassword(String var1, String var2, SVNProperties var3) throws SVNException;

        public boolean savePassphrase(String var1, String var2, SVNAuthentication var3, SVNProperties var4, boolean var5) throws SVNException;

        public String readPassphrase(String var1, SVNProperties var2) throws SVNException;
    }
}

