/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.wc2.ng;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import org.tmatesoft.svn.core.SVNCommitInfo;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNMergeInfoInheritance;
import org.tmatesoft.svn.core.SVNMergeRangeList;
import org.tmatesoft.svn.core.SVNNodeKind;
import org.tmatesoft.svn.core.SVNProperties;
import org.tmatesoft.svn.core.SVNPropertyValue;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.internal.util.SVNMergeInfoUtil;
import org.tmatesoft.svn.core.internal.util.SVNPathUtil;
import org.tmatesoft.svn.core.internal.util.SVNURLUtil;
import org.tmatesoft.svn.core.internal.wc.SVNCommitUtil;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.core.internal.wc.SVNExternal;
import org.tmatesoft.svn.core.internal.wc.SVNFileUtil;
import org.tmatesoft.svn.core.internal.wc17.SVNCommitter17;
import org.tmatesoft.svn.core.internal.wc17.SVNWCContext;
import org.tmatesoft.svn.core.internal.wc17.SVNWCUtils;
import org.tmatesoft.svn.core.internal.wc17.db.ISVNWCDb;
import org.tmatesoft.svn.core.internal.wc17.db.Structure;
import org.tmatesoft.svn.core.internal.wc17.db.StructureFields;
import org.tmatesoft.svn.core.internal.wc2.SvnWcGeneration;
import org.tmatesoft.svn.core.internal.wc2.ng.SvnNgCommitUtil;
import org.tmatesoft.svn.core.internal.wc2.ng.SvnNgOperationRunner;
import org.tmatesoft.svn.core.io.ISVNEditor;
import org.tmatesoft.svn.core.io.SVNRepository;
import org.tmatesoft.svn.core.wc.SVNRevision;
import org.tmatesoft.svn.core.wc2.SvnCommitItem;
import org.tmatesoft.svn.core.wc2.SvnCommitPacket;
import org.tmatesoft.svn.core.wc2.SvnCopySource;
import org.tmatesoft.svn.core.wc2.SvnRemoteCopy;
import org.tmatesoft.svn.core.wc2.hooks.ISvnCommitHandler;
import org.tmatesoft.svn.util.SVNLogType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SvnNgWcToReposCopy
extends SvnNgOperationRunner<SVNCommitInfo, SvnRemoteCopy>
implements SvnNgCommitUtil.ISvnUrlKindCallback {
    @Override
    public boolean isApplicable(SvnRemoteCopy operation, SvnWcGeneration wcGeneration) throws SVNException {
        return this.areAllSourcesLocal(operation) && !operation.getFirstTarget().isLocal();
    }

    private boolean areAllSourcesLocal(SvnRemoteCopy operation) {
        for (SvnCopySource source : operation.getSources()) {
            if (source.getSource().isFile() && (source.getRevision() == SVNRevision.WORKING || source.getRevision() == SVNRevision.UNDEFINED)) continue;
            return false;
        }
        return true;
    }

    @Override
    protected SVNCommitInfo run(SVNWCContext context) throws SVNException {
        SVNCommitInfo info = null;
        try {
            info = this.doRun(context, ((SvnRemoteCopy)this.getOperation()).getFirstTarget().getURL());
        }
        catch (SVNException e) {
            SVNErrorCode code = e.getErrorMessage().getErrorCode();
            if (!(((SvnRemoteCopy)this.getOperation()).isFailWhenDstExists() || ((SvnRemoteCopy)this.getOperation()).getSources().size() != 1 || code != SVNErrorCode.ENTRY_EXISTS && code != SVNErrorCode.FS_ALREADY_EXISTS)) {
                SvnCopySource source = ((SvnRemoteCopy)this.getOperation()).getSources().iterator().next();
                SVNURL target = ((SvnRemoteCopy)this.getOperation()).getFirstTarget().getURL();
                target = target.appendPath(source.getSource().getFile().getName(), false);
                info = this.doRun(context, target);
            }
            throw e;
        }
        if (info != null) {
            ((SvnRemoteCopy)this.getOperation()).receive(((SvnRemoteCopy)this.getOperation()).getFirstTarget(), info);
        }
        return info;
    }

    protected SVNCommitInfo doRun(SVNWCContext context, SVNURL target) throws SVNException {
        if (((SvnRemoteCopy)this.getOperation()).isMove()) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.UNSUPPORTED_FEATURE, "Moves between the working copy and the repository are not supported");
            SVNErrorManager.error(err, SVNLogType.WC);
        }
        Collection<SvnCopySource> sources = ((SvnRemoteCopy)this.getOperation()).getSources();
        ArrayList<SvnCopyPair> copyPairs = new ArrayList<SvnCopyPair>();
        if (sources.size() > 1) {
            for (SvnCopySource copySource : sources) {
                SvnCopyPair copyPair = new SvnCopyPair();
                copyPair.source = copySource.getSource().getFile();
                String baseName = copyPair.source.getName();
                copyPair.dst = target;
                copyPair.dst = copyPair.dst.appendPath(baseName, false);
                copyPairs.add(copyPair);
            }
        } else if (sources.size() == 1) {
            SvnCopyPair copyPair = new SvnCopyPair();
            SvnCopySource source = sources.iterator().next();
            copyPair.source = source.getSource().getFile();
            copyPair.dst = target;
            copyPairs.add(copyPair);
        }
        return this.copy(copyPairs, ((SvnRemoteCopy)this.getOperation()).isMakeParents(), ((SvnRemoteCopy)this.getOperation()).getRevisionProperties(), ((SvnRemoteCopy)this.getOperation()).getCommitMessage(), ((SvnRemoteCopy)this.getOperation()).getCommitHandler());
    }

    private SVNCommitInfo copy(Collection<SvnCopyPair> copyPairs, boolean makeParents, SVNProperties revisionProperties, String commitMessage, ISvnCommitHandler commitHandler) throws SVNException {
        SvnCopyPair firstPair = copyPairs.iterator().next();
        SVNURL topDstUrl = firstPair.dst.removePathTail();
        for (SvnCopyPair pair : copyPairs) {
            topDstUrl = SVNURLUtil.getCommonURLAncestor(topDstUrl, pair.dst);
        }
        File topSrcPath = this.getCommonCopyAncestor(copyPairs);
        SVNRepository repository = this.getRepositoryAccess().createRepository(topDstUrl, topSrcPath);
        topDstUrl = repository.getLocation();
        Collection<SVNURL> parents = null;
        if (makeParents) {
            parents = this.findMissingParents(topDstUrl, repository);
        }
        for (SvnCopyPair pair : copyPairs) {
            String path = SVNURLUtil.getRelativeURL(repository.getLocation(), pair.dst, false);
            if (repository.checkPath(path, -1L) == SVNNodeKind.NONE) continue;
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.FS_ALREADY_EXISTS, "Path ''{0}'' already exists", (Object)pair.dst);
            SVNErrorManager.error(err, SVNLogType.WC);
        }
        SvnCommitItem[] items = new SvnCommitItem[(parents != null ? parents.size() : 0) + copyPairs.size()];
        int index = 0;
        if (makeParents && parents != null) {
            for (SVNURL parent : parents) {
                SvnCommitItem parentItem = new SvnCommitItem();
                parentItem.setUrl(parent);
                parentItem.setFlags(1);
                parentItem.setKind(SVNNodeKind.DIR);
                items[index++] = parentItem;
            }
        }
        for (SvnCopyPair svnCopyPair : copyPairs) {
            SvnCommitItem item = new SvnCommitItem();
            item.setUrl(svnCopyPair.dst);
            item.setPath(svnCopyPair.source);
            item.setFlags(1);
            item.setKind(SVNNodeKind.DIR);
            items[index++] = item;
        }
        commitMessage = ((SvnRemoteCopy)this.getOperation()).getCommitHandler().getCommitMessage(commitMessage, items);
        if (commitMessage == null) {
            return SVNCommitInfo.NULL;
        }
        revisionProperties = ((SvnRemoteCopy)this.getOperation()).getCommitHandler().getRevisionProperties(commitMessage, items, revisionProperties);
        if (revisionProperties == null) {
            return SVNCommitInfo.NULL;
        }
        SvnCommitPacket packet = new SvnCommitPacket();
        SVNURL repositoryRoot = repository.getRepositoryRoot(true);
        if (parents != null) {
            for (SVNURL parent : parents) {
                String parentPath = SVNURLUtil.getRelativeURL(repositoryRoot, parent, false);
                packet.addItem(null, SVNNodeKind.DIR, repositoryRoot, parentPath, -1L, null, -1L, 1);
            }
        }
        for (SvnCopyPair svnCopyPair : copyPairs) {
            Map<String, SVNMergeRangeList> wcMergeInfo;
            HashMap<File, String> externals = ((SvnRemoteCopy)this.getOperation()).getExternalsHandler() != null ? new HashMap<File, String>() : null;
            SvnNgCommitUtil.harvestCopyCommitables(this.getWcContext(), svnCopyPair.source, svnCopyPair.dst, packet, this, ((SvnRemoteCopy)this.getOperation()).getCommitParameters(), externals);
            SvnCommitItem item = packet.getItem(svnCopyPair.source);
            if (item == null) continue;
            Map<String, SVNMergeRangeList> mergeInfo = this.calculateTargetMergeInfo(svnCopyPair.source, -1L, repository);
            String mergeInfoProperty = this.getWcContext().getProperty(svnCopyPair.source, "svn:mergeinfo");
            Map<String, SVNMergeRangeList> map = wcMergeInfo = mergeInfoProperty != null ? SVNMergeInfoUtil.parseMergeInfo(new StringBuffer(mergeInfoProperty), null) : null;
            if (wcMergeInfo != null && mergeInfo != null) {
                mergeInfo = SVNMergeInfoUtil.mergeMergeInfos(mergeInfo, wcMergeInfo);
            } else if (mergeInfo == null) {
                mergeInfo = wcMergeInfo;
            }
            String extendedMergeInfoValue = null;
            if (wcMergeInfo != null) {
                extendedMergeInfoValue = SVNMergeInfoUtil.formatMergeInfoToString(wcMergeInfo, null);
                item.addOutgoingProperty("svn:mergeinfo", SVNPropertyValue.create(extendedMergeInfoValue));
            }
            if (externals == null || externals.isEmpty()) continue;
            this.includeExternalsChanges(repository, packet, externals, svnCopyPair);
        }
        if (((SvnRemoteCopy)this.getOperation()).isDisableLocalModifications()) {
            SvnCommitPacket oldPacket = packet;
            if ((packet = this.filterLocalModifications(packet)).isEmpty()) {
                SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.ILLEGAL_TARGET, this.buildErrorMessageWithDebugInformation(oldPacket));
                SVNErrorManager.error(err, SVNLogType.DEFAULT);
            }
        }
        TreeMap<String, SvnCommitItem> committables = new TreeMap<String, SvnCommitItem>();
        SVNURL url = SvnNgCommitUtil.translateCommitables(packet.getItems(packet.getRepositoryRoots().iterator().next()), committables);
        repository.setLocation(url, false);
        ISVNEditor commitEditor = repository.getCommitEditor(commitMessage, null, false, revisionProperties, null);
        SVNCommitter17 committer = new SVNCommitter17(this.getWcContext(), committables, repositoryRoot, null, null, null);
        SVNCommitUtil.driveCommitEditor(committer, committables.keySet(), commitEditor, -1L);
        committer.sendTextDeltas(commitEditor);
        SVNCommitInfo info = commitEditor.closeEdit();
        this.deleteDeleteFiles(committer, ((SvnRemoteCopy)this.getOperation()).getCommitParameters());
        return info;
    }

    private String buildErrorMessageWithDebugInformation(SvnCommitPacket oldPacket) {
        StringBuilder stringBuilder = new StringBuilder("Unable to perform wc to remote copy without local modifications:").append('\n');
        stringBuilder.append("Commit packet was:").append('\n');
        Collection<SVNURL> repositoryRoots = oldPacket.getRepositoryRoots();
        for (SVNURL oldRoot : repositoryRoots) {
            stringBuilder.append(oldRoot).append("  :").append('\n');
            Collection<SvnCommitItem> oldItems = oldPacket.getItems(oldRoot);
            if (oldItems == null) continue;
            for (SvnCommitItem oldItem : oldItems) {
                stringBuilder.append("path=").append(oldItem.getPath()).append('\n');
                stringBuilder.append("kind=").append(oldItem.getKind()).append('\n');
                stringBuilder.append("url=").append(oldItem.getUrl()).append('\n');
                stringBuilder.append("revision=").append(oldItem.getRevision()).append('\n');
                stringBuilder.append("copyUrl=").append(oldItem.getCopyFromUrl()).append('\n');
                stringBuilder.append("copyRevision=").append(oldItem.getCopyFromRevision()).append('\n');
                stringBuilder.append("flags=").append(oldItem.getFlags()).append('\n');
            }
        }
        return stringBuilder.toString();
    }

    private SvnCommitPacket filterLocalModifications(SvnCommitPacket packet) throws SVNException {
        SvnCommitPacket filteredPacket = new SvnCommitPacket();
        filteredPacket.setLockTokens(packet.getLockTokens());
        filteredPacket.setLockingContext(packet.getRunner(), packet.getLockingContext());
        Collection<SVNURL> repositoryRoots = packet.getRepositoryRoots();
        for (SVNURL repositoryRoot : repositoryRoots) {
            Collection<SvnCommitItem> items = packet.getItems(repositoryRoot);
            for (SvnCommitItem item : items) {
                if (item.hasFlag(2)) continue;
                if (item.hasFlag(1)) {
                    ISVNWCDb.WCDbBaseInfo baseInfo;
                    SVNURL copyFromUrl;
                    if (!item.hasFlag(16) || (copyFromUrl = item.getCopyFromUrl()) == null) continue;
                    try {
                        baseInfo = this.getWcContext().getDb().getBaseInfo(item.getPath(), ISVNWCDb.WCDbBaseInfo.BaseInfoField.reposRootUrl, ISVNWCDb.WCDbBaseInfo.BaseInfoField.reposRelPath);
                    }
                    catch (SVNException e) {
                        if (e.getErrorMessage().getErrorCode() == SVNErrorCode.WC_PATH_NOT_FOUND) continue;
                        throw e;
                    }
                    SVNURL url = baseInfo.reposRootUrl.appendPath(SVNFileUtil.getFilePath(baseInfo.reposRelPath), false);
                    if (!copyFromUrl.equals(url)) continue;
                }
                item.setFlags(item.getFlags() & 0xFFFFFFFB & 0xFFFFFFF7);
                filteredPacket.addItem(item, repositoryRoot);
            }
        }
        return filteredPacket;
    }

    private void includeExternalsChanges(SVNRepository repos, SvnCommitPacket packet, Map<File, String> externalsStorage, SvnCopyPair svnCopyPair) throws SVNException {
        for (File externalHolder : externalsStorage.keySet()) {
            String externalsPropString = externalsStorage.get(externalHolder);
            SVNExternal[] externals = SVNExternal.parseExternals(externalHolder.getAbsolutePath(), externalsPropString);
            boolean introduceVirtualExternalChange = false;
            ArrayList<String> newExternals = new ArrayList<String>();
            SVNURL ownerURL = this.getWcContext().getNodeUrl(externalHolder);
            if (ownerURL == null) continue;
            long ownerRev = this.getWcContext().getNodeBaseRev(externalHolder);
            File ownerReposRelPath = this.getWcContext().getNodeReposRelPath(externalHolder);
            File sourceReposRelPath = this.getWcContext().getNodeReposRelPath(svnCopyPair.source);
            String relativePath = SVNWCUtils.getPathAsChild(sourceReposRelPath, ownerReposRelPath);
            SVNURL targetURL = svnCopyPair.dst.appendPath(relativePath, false);
            for (int k = 0; k < externals.length; ++k) {
                SVNRevision[] revs;
                File externalWC = new File(externalHolder, externals[k].getPath());
                SVNRevision externalsWCRevision = SVNRevision.UNDEFINED;
                try {
                    long rev = this.getWcContext().getNodeBaseRev(externalWC);
                    if (rev >= 0L) {
                        externalsWCRevision = SVNRevision.create(rev);
                    }
                }
                catch (SVNException e) {
                    // empty catch block
                }
                SVNURL resolvedURL = externals[k].resolveURL(repos.getRepositoryRoot(true), ownerURL);
                String unresolvedURL = externals[k].getUnresolvedUrl();
                if (unresolvedURL != null && !SVNPathUtil.isURL(unresolvedURL) && unresolvedURL.startsWith("../")) {
                    unresolvedURL = SVNURLUtil.getRelativeURL(repos.getRepositoryRoot(true), resolvedURL, true);
                    unresolvedURL = unresolvedURL.startsWith("/") ? "^" + unresolvedURL : "^/" + unresolvedURL;
                }
                if ((revs = ((SvnRemoteCopy)this.getOperation()).getExternalsHandler().handleExternal(externalWC, resolvedURL, externals[k].getRevision(), externals[k].getPegRevision(), externals[k].getRawValue(), externalsWCRevision)) != null && revs.length == 2 && !revs[0].equals(externals[k].getRevision())) {
                    SVNExternal newExternal = new SVNExternal(externals[k].getPath(), unresolvedURL, revs[1], revs[0], true, externals[k].isPegRevisionExplicit(), externals[k].isNewFormat());
                    newExternals.add(newExternal.toString());
                    if (introduceVirtualExternalChange) continue;
                    introduceVirtualExternalChange = true;
                    continue;
                }
                if (revs == null) continue;
                newExternals.add(externals[k].getRawValue());
            }
            if (!introduceVirtualExternalChange) continue;
            String newExternalsProp = "";
            for (String external : newExternals) {
                newExternalsProp = newExternalsProp + external + '\n';
            }
            SvnCommitItem itemWithExternalsChanges = packet.getItem(externalHolder);
            if (itemWithExternalsChanges == null) {
                itemWithExternalsChanges = packet.addItem(externalHolder, repos.getRepositoryRoot(true), SVNNodeKind.DIR, targetURL, -1L, ownerURL, ownerRev, 8);
            }
            itemWithExternalsChanges.addOutgoingProperty("svn:externals", SVNPropertyValue.create(newExternalsProp));
        }
    }

    private Collection<SVNURL> findMissingParents(SVNURL targetURL, SVNRepository repository) throws SVNException {
        SVNNodeKind kind = repository.checkPath("", -1L);
        ArrayList<SVNURL> parents = new ArrayList<SVNURL>();
        while (kind == SVNNodeKind.NONE) {
            parents.add(targetURL);
            targetURL = targetURL.removePathTail();
            repository.setLocation(targetURL, false);
            kind = repository.checkPath("", -1L);
        }
        if (kind != SVNNodeKind.DIR) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.FS_ALREADY_EXISTS, "Path ''{0}'' already exists, but it is not a directory", (Object)targetURL);
            SVNErrorManager.error(err, SVNLogType.WC);
        }
        return parents;
    }

    private File getCommonCopyAncestor(Collection<SvnCopyPair> copyPairs) {
        File ancestor = null;
        for (SvnCopyPair svnCopyPair : copyPairs) {
            if (ancestor == null) {
                ancestor = svnCopyPair.source;
                continue;
            }
            String ancestorPath = ancestor.getAbsolutePath().replace(File.separatorChar, '/');
            String sourcePath = svnCopyPair.source.getAbsolutePath().replace(File.separatorChar, '/');
            ancestorPath = SVNPathUtil.getCommonPathAncestor(ancestorPath, sourcePath);
            ancestor = new File(ancestorPath);
        }
        return ancestor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Map<String, SVNMergeRangeList> calculateTargetMergeInfo(File srcFile, long srcRevision, SVNRepository repository) throws SVNException {
        SVNURL url = null;
        SVNURL oldLocation = null;
        Structure<StructureFields.NodeOriginInfo> nodeOrigin = this.getWcContext().getNodeOrigin(srcFile, false, StructureFields.NodeOriginInfo.revision, StructureFields.NodeOriginInfo.reposRelpath, StructureFields.NodeOriginInfo.reposRootUrl);
        if (nodeOrigin != null && nodeOrigin.get(StructureFields.NodeOriginInfo.reposRelpath) != null) {
            url = (SVNURL)nodeOrigin.get(StructureFields.NodeOriginInfo.reposRootUrl);
            url = SVNWCUtils.join(url, (File)nodeOrigin.get(StructureFields.NodeOriginInfo.reposRelpath));
            srcRevision = nodeOrigin.lng(StructureFields.NodeOriginInfo.revision);
        }
        if (url == null) return null;
        Map<String, SVNMergeRangeList> targetMergeInfo = null;
        SVNRepository repos = repository;
        try {
            String mergeInfoPath = this.getRepositoryAccess().getPathRelativeToSession(url, null, repos);
            if (mergeInfoPath == null) {
                oldLocation = repos.getLocation();
                repos.setLocation(url, false);
                mergeInfoPath = "";
            }
            targetMergeInfo = this.getRepositoryAccess().getReposMergeInfo(repos, mergeInfoPath, srcRevision, SVNMergeInfoInheritance.INHERITED, true);
            if (repository == null) {
                repos.closeSession();
                return targetMergeInfo;
            }
            if (oldLocation == null) return targetMergeInfo;
        }
        catch (Throwable throwable) {
            if (repository == null) {
                repos.closeSession();
                throw throwable;
            } else {
                if (oldLocation == null) throw throwable;
                repos.setLocation(oldLocation, false);
            }
            throw throwable;
        }
        repos.setLocation(oldLocation, false);
        return targetMergeInfo;
    }

    @Override
    public SVNNodeKind getUrlKind(SVNURL url, long revision) throws SVNException {
        return this.getRepositoryAccess().createRepository(url, null).checkPath("", revision);
    }

    private static class SvnCopyPair {
        File source;
        SVNURL dst;

        private SvnCopyPair() {
        }
    }
}

