/*
 * Decompiled with CFR 0.152.
 */
package de.lazyzero.kkMulticopterFlashTool.gui;

import de.lazyzero.kkMulticopterFlashTool.KKMulticopterFlashTool;
import de.lazyzero.kkMulticopterFlashTool.gui.widgets.FirmwareFilePanel;
import de.lazyzero.kkMulticopterFlashTool.gui.widgets.FirmwareRepositoryPanel;
import de.lazyzero.kkMulticopterFlashTool.utils.ButtonsStateListener;
import de.lazyzero.kkMulticopterFlashTool.utils.XmlReaderFirmwares;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import javax.swing.JTabbedPane;
import javax.swing.border.TitledBorder;
import lu.tudor.santec.i18n.Translatrix;

public class FirmwarePanel
extends JTabbedPane
implements ButtonsStateListener,
PropertyChangeListener {
    private static final long serialVersionUID = 1L;
    private XmlReaderFirmwares firmwareLoader;
    private KKMulticopterFlashTool parent;
    private boolean buttonsEnabled = true;
    private FirmwareFilePanel firmwarefilePanel;
    private FirmwareRepositoryPanel firmwareRepositoryPanel;

    public FirmwarePanel(KKMulticopterFlashTool parent, XmlReaderFirmwares firmwareLoader) {
        this.parent = parent;
        this.firmwareLoader = firmwareLoader;
        this.init();
        this.addPropertyChangeListener(this);
    }

    private void init() {
        this.firmwarefilePanel = new FirmwareFilePanel(this.parent);
        this.firmwareRepositoryPanel = new FirmwareRepositoryPanel(this.parent, this.firmwareLoader);
        this.addTab(Translatrix._("firmwarepanel.repository"), this.firmwareRepositoryPanel);
        this.addTab(Translatrix._("firmwarepanel.file"), this.firmwarefilePanel);
        this.setBorder(new TitledBorder(String.valueOf(Translatrix._("Flashing")) + "..."));
        this.setSelectedIndex(0);
    }

    @Override
    public void setButtonsEnabled(boolean b) {
        this.buttonsEnabled = b;
    }

    @Override
    public void updateButtons() {
        this.firmwarefilePanel.setButtonsEnabled(this.buttonsEnabled);
        this.firmwareRepositoryPanel.setButtonsEnabled(this.buttonsEnabled);
        this.firmwarefilePanel.updateButtons();
        this.firmwareRepositoryPanel.updateButtons();
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName().equals("controllerChanged")) {
            this.firmwareRepositoryPanel.firePropertyChange("controllerChanged", 0, 1);
        }
    }

    public void setHexFile(File file, boolean clearContent) {
        this.firmwarefilePanel.setHexFile(file, clearContent);
        this.setSelectedIndex(this.indexOfTab(Translatrix._("firmwarepanel.file")));
    }
}

