/*
 * Decompiled with CFR 0.152.
 */
package de.lazyzero.kkMulticopterFlashTool.gui.widgets;

import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import de.lazyzero.kkMulticopterFlashTool.utils.EEprom.EEprom;
import de.lazyzero.kkMulticopterFlashTool.utils.EEprom.EEpromBooleanItem;
import de.lazyzero.kkMulticopterFlashTool.utils.EEprom.EEpromDataItem;
import de.lazyzero.kkMulticopterFlashTool.utils.EEprom.EEpromUInt8Item;
import de.lazyzero.kkMulticopterFlashTool.utils.EEprom.EEpromValueException;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.LinkedHashMap;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import lu.tudor.santec.i18n.Translatrix;

public class EEpromItemPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private CellConstraints cc;
    private EEpromDataItem item;
    public static final int BOOLEAN_ITEM = 0;
    public static final int UINT8_ITEM = 1;

    public EEpromItemPanel(EEpromDataItem item) {
        this.item = item;
        switch (item.getDataType()) {
            case 0: {
                this.createBooleanItem();
                break;
            }
            case 1: {
                this.createUInt8Item();
                break;
            }
        }
    }

    private void createUInt8Item() {
        int value = 0;
        this.cc = new CellConstraints();
        String panelColumns = "3dlu,pref,3dlu,fill:pref:grow,3dlu";
        String panelRows = "3dlu,pref,3dlu";
        FormLayout panelLayout = new FormLayout(panelColumns, panelRows);
        this.setLayout((LayoutManager)panelLayout);
        this.setBorder(new TitledBorder(Translatrix._(this.item.getType())));
        value = ((EEpromUInt8Item)this.item).getValue();
        JLabel label = new JLabel(Translatrix._(this.item.getLabel()));
        final JTextField field = new JTextField(String.valueOf(value));
        field.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                System.out.println(e.getSource());
                try {
                    boolean bl = ((EEpromUInt8Item)EEpromItemPanel.this.item).setValue(Integer.valueOf(field.getText()));
                }
                catch (NumberFormatException e1) {
                    e1.printStackTrace();
                }
                catch (EEpromValueException e1) {
                    e1.printStackTrace();
                }
            }
        });
        this.add((Component)label, this.cc.xy(2, 2));
        this.add((Component)label, this.cc.xy(4, 2));
    }

    private void createBooleanItem() {
        boolean isSelected = false;
        this.cc = new CellConstraints();
        String panelColumns = "3dlu,fill:pref:grow,3dlu";
        String panelRows = "3dlu,pref,3dlu";
        FormLayout panelLayout = new FormLayout(panelColumns, panelRows);
        this.setLayout((LayoutManager)panelLayout);
        this.setBorder(new TitledBorder(Translatrix._(this.item.getType())));
        try {
            isSelected = ((EEpromBooleanItem)this.item).getValue();
        }
        catch (EEpromValueException e) {
            e.printStackTrace();
        }
        final JCheckBox checkBox = new JCheckBox(Translatrix._(this.item.getLabel()), isSelected);
        checkBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                System.out.println(e.getSource());
                boolean updated = ((EEpromBooleanItem)EEpromItemPanel.this.item).setValue(checkBox.isSelected());
            }
        });
        this.add((Component)checkBox, this.cc.xy(2, 2));
    }

    public static void main(String[] args) {
        EEprom eeprom = new EEprom("./eeprom_readout/eeprom.txt");
        LinkedHashMap<Short, String> dataMapping = new LinkedHashMap<Short, String>();
        dataMapping.put((short)127, "true");
        dataMapping.put((short)255, "false");
        EEpromBooleanItem eeDataItem = new EEpromBooleanItem(eeprom, "Gyro", 0, 1, EEpromBooleanItem.BOOLEAN, dataMapping, "Yaw gyro inverted");
        EEpromItemPanel eei = new EEpromItemPanel(eeDataItem);
        JFrame jf = new JFrame();
        jf.add(eei);
        jf.pack();
        jf.setVisible(true);
    }
}

