/*
 * Decompiled with CFR 0.152.
 */
package de.lazyzero.kkMulticopterFlashTool.gui.widgets;

import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import de.lazyzero.kkMulticopterFlashTool.KKMulticopterFlashTool;
import de.lazyzero.kkMulticopterFlashTool.gui.widgets.FirmwareListCellRenderer;
import de.lazyzero.kkMulticopterFlashTool.utils.ButtonsStateListener;
import de.lazyzero.kkMulticopterFlashTool.utils.Firmware;
import de.lazyzero.kkMulticopterFlashTool.utils.Icons;
import de.lazyzero.kkMulticopterFlashTool.utils.XmlReaderFirmwares;
import java.awt.Color;
import java.awt.Component;
import java.awt.Desktop;
import java.awt.Font;
import java.awt.GridBagLayout;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Timer;
import java.util.TimerTask;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.border.TitledBorder;
import lu.tudor.santec.i18n.Translatrix;

public class FirmwareRepositoryPanel
extends JPanel
implements ActionListener,
PropertyChangeListener,
ButtonsStateListener {
    private static final long serialVersionUID = 1L;
    private XmlReaderFirmwares firmwareLoader;
    private KKMulticopterFlashTool parent;
    private JComboBox firmwareCombobox;
    private JComboBox firmwareCategoryCombobox;
    private JButton reload;
    private JButton flash;
    private Vector<Firmware> firmwares = new Vector();
    private TitledBorder firmwareBorder;
    private CellConstraints cc;
    private JLabel firmwareLabel;
    private Vector<String> categories = new Vector();
    private JButton info;
    private Logger logger = KKMulticopterFlashTool.getLogger();
    private boolean buttonsEnabled = true;
    private int item;

    public FirmwareRepositoryPanel(KKMulticopterFlashTool parent, XmlReaderFirmwares firmwareLoader) {
        this.parent = parent;
        this.firmwareLoader = firmwareLoader;
        this.init();
        this.addPropertyChangeListener(this);
    }

    private void init() {
        this.cc = new CellConstraints();
        String panelColumns = "pref,3dlu,fill:pref:grow,3dlu,pref,3dlu,pref";
        String panelRows = "pref,3dlu,pref,3dlu,pref:grow,3dlu,top:pref:grow";
        FormLayout panelLayout = new FormLayout(panelColumns, panelRows);
        this.setLayout((LayoutManager)panelLayout);
        JLabel helpLabel = new JLabel(Translatrix._("firmware.help"));
        this.firmwareLabel = new JLabel(Translatrix._("firmware"));
        this.firmwareLabel.setToolTipText(Translatrix._("firmware.FirmwareCombobox.tip"));
        this.setBorder(new TitledBorder(Translatrix._("firmware.settings")));
        this.categories.add(Translatrix._("firmware.allCategories"));
        this.categories.addAll(Firmware.getCategories(this.firmwareLoader.getFirmwares()));
        this.firmwareCategoryCombobox = new JComboBox<String>(this.categories);
        this.firmwareCategoryCombobox.setSelectedIndex(0);
        this.firmwareCategoryCombobox.addActionListener(this);
        this.firmwareCategoryCombobox.setToolTipText(Translatrix._("firmware.CategoryCombobox.tip"));
        this.firmwareCombobox = new JComboBox();
        this.firmwareCombobox.setModel(new DefaultComboBoxModel());
        this.firmwareCombobox.setBorder(this.firmwareBorder);
        this.firmwareCombobox.setToolTipText(Translatrix._("firmware.FirmwareCombobox.tip"));
        this.firmwareCombobox.addActionListener(this);
        this.firmwareCombobox.setRenderer(new FirmwareListCellRenderer());
        this.reload = new JButton(Icons.getIcon16("agt_reload.png"));
        this.reload.setMnemonic(82);
        this.reload.addActionListener(this);
        this.reload.setToolTipText(Translatrix._("reload.tip"));
        this.flash = new JButton(Icons.getIcon16("runit.png"));
        this.flash.setMnemonic(70);
        this.flash.addActionListener(this);
        this.flash.setEnabled(false);
        this.flash.setToolTipText(Translatrix._("firmware.flash.tip"));
        this.info = new JButton(Icons.getIcon16("info.png"));
        this.info.setMnemonic(73);
        this.info.addActionListener(this);
        this.info.setEnabled(false);
        this.info.setToolTipText(Translatrix._("firmware.info.tip"));
        this.add((Component)helpLabel, this.cc.xyw(1, 1, 7));
        this.add((Component)this.firmwareCategoryCombobox, this.cc.xy(3, 5));
        this.add((Component)this.firmwareLabel, this.cc.xy(1, 7));
        this.add((Component)this.firmwareCombobox, this.cc.xy(3, 7));
        this.add((Component)this.reload, this.cc.xy(5, 5));
        this.add((Component)this.flash, this.cc.xy(7, 7));
        this.add((Component)this.info, this.cc.xy(5, 7));
    }

    @Override
    public void actionPerformed(ActionEvent action) {
        block20: {
            if (action.getSource().equals(this.firmwareCategoryCombobox)) {
                this.item = this.firmwareCategoryCombobox.getSelectedIndex();
                this.parent.clearText();
                this.updateComboboxes();
            } else if (action.getSource().equals(this.reload)) {
                this.item = this.firmwareCategoryCombobox.getSelectedIndex();
                this.parent.clearText();
                this.parent.println(Translatrix._("messages.reloadList"));
                try {
                    this.firmwareLoader.reloadXmlFile(this.firmwareLoader.getURL());
                }
                catch (Exception e) {
                    this.parent.println(Translatrix._("messages.reloadList.error"));
                    e.printStackTrace();
                    return;
                }
                this.updateComboboxes();
            } else if (action.getSource().equals(this.firmwareCombobox)) {
                try {
                    if (!KKMulticopterFlashTool.isOfflineMode() && ((Firmware)this.firmwareCombobox.getSelectedItem()).hasCommentURL()) {
                        this.info.setEnabled(true);
                        break block20;
                    }
                    this.info.setEnabled(false);
                }
                catch (Exception e) {}
            } else if (action.getSource().equals(this.flash)) {
                this.parent.clearText();
                if (KKMulticopterFlashTool.getCountdown() > 0) {
                    this.countdown(KKMulticopterFlashTool.getCountdown());
                } else {
                    this.flash();
                }
            } else if (action.getSource().equals(this.info)) {
                if (Desktop.isDesktopSupported() && Desktop.getDesktop().isSupported(Desktop.Action.BROWSE)) {
                    try {
                        Desktop.getDesktop().browse(((Firmware)this.firmwareCombobox.getSelectedItem()).getCommentURL().toURI());
                    }
                    catch (Exception e) {
                        this.logger.log(Level.WARNING, e.getMessage());
                    }
                } else {
                    JOptionPane.showMessageDialog(null, String.valueOf(Translatrix._("error.commentURL")) + ((Firmware)this.firmwareCombobox.getSelectedItem()).getCommentURL().toExternalForm());
                }
            }
        }
    }

    private void flash() {
        this.parent.println(Translatrix._("messages.flashRepository"));
        this.parent.setFirmware((Firmware)this.firmwareCombobox.getSelectedItem());
        if (this.parent.getController().getCaption().equals("wii_eeprom")) {
            this.parent.flashEEprom(null);
        } else {
            this.parent.flashAVR();
        }
    }

    private void updateComboboxes() {
        String controllerName = this.parent.getController().getCaption();
        this.firmwares = this.firmwareLoader.getFirmwares(controllerName);
        this.firmwareCategoryCombobox.removeAllItems();
        this.categories = new Vector();
        this.categories.add(Translatrix._("firmware.allCategories"));
        this.categories.addAll(Firmware.getCategories(this.firmwares));
        int i = 0;
        while (i < this.categories.size()) {
            this.firmwareCategoryCombobox.addItem(this.categories.get(i));
            ++i;
        }
        if (this.firmwareCategoryCombobox.getItemCount() > 0) {
            this.firmwareCategoryCombobox.setSelectedIndex(0);
        }
        if (this.item > 0) {
            this.firmwareCategoryCombobox.setSelectedIndex(this.item);
        }
        if (KKMulticopterFlashTool.isOfflineMode()) {
            this.firmwares = Firmware.getOfflineAvailableFirmwares(this.firmwares);
        }
        if (!this.firmwareCategoryCombobox.getSelectedItem().equals(Translatrix._("firmware.allCategories"))) {
            this.firmwares = Firmware.filter((String)this.firmwareCategoryCombobox.getSelectedItem(), this.firmwares);
        }
        this.parent.println(Translatrix._("messages.reloadList.done"));
        this.firmwareCombobox.removeAllItems();
        System.out.println("firmwares loaded: " + this.firmwares.size());
        i = 0;
        while (i < this.firmwares.size()) {
            this.firmwareCombobox.addItem(this.firmwares.get(i));
            ++i;
        }
        if (this.firmwareCombobox.getItemCount() > 0) {
            this.firmwareCombobox.setSelectedIndex(0);
            this.flash.setEnabled(true);
        } else {
            this.flash.setEnabled(false);
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName().equals("controllerChanged")) {
            if (Boolean.valueOf("" + evt.getNewValue()).booleanValue() || Boolean.valueOf("" + evt.getOldValue()).booleanValue()) {
                this.parent.clearText();
            }
            this.updateComboboxes();
        }
    }

    private void countdown(int countdown) {
        this.logger.log(Level.INFO, "start Countdown from " + countdown);
        final JPanel glass = (JPanel)this.parent.getMainframe().getGlassPane();
        glass.setLayout(new GridBagLayout());
        final JLabel number = new JLabel("countdown");
        number.setForeground(Color.RED);
        number.setFont(new Font("SansSerif", 1, 120));
        number.setOpaque(false);
        glass.add(number);
        glass.setVisible(true);
        Timer timer = new Timer();
        TimerTask task = new TimerTask(countdown){
            int count;
            {
                this.count = n;
            }

            @Override
            public void run() {
                if (this.count == -1) {
                    this.cancel();
                    glass.setVisible(false);
                    FirmwareRepositoryPanel.this.flash();
                }
                glass.removeAll();
                number.setText(String.valueOf(this.count));
                glass.add(number);
                number.repaint();
                FirmwareRepositoryPanel.this.logger.log(Level.INFO, String.valueOf(this.count));
                --this.count;
            }
        };
        timer.schedule(task, 0L, 1000L);
        try {
            timer.wait();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        this.parent.getMainframe().repaint();
    }

    @Override
    public void setButtonsEnabled(boolean b) {
        this.buttonsEnabled = b;
    }

    @Override
    public void updateButtons() {
        this.flash.setEnabled(this.buttonsEnabled);
        this.reload.setEnabled(this.buttonsEnabled);
    }
}

