/*
 * Decompiled with CFR 0.152.
 */
package de.lazyzero.kkMulticopterFlashTool.gui.widgets.FirmwareSettings;

import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import de.lazyzero.kkMulticopterFlashTool.KKMulticopterFlashTool;
import de.lazyzero.kkMulticopterFlashTool.gui.widgets.EEpromFirmwareSettings;
import de.lazyzero.kkMulticopterFlashTool.gui.widgets.EEpromItemPanel;
import de.lazyzero.kkMulticopterFlashTool.utils.EEprom.EEpromBooleanItem;
import java.awt.Component;
import java.awt.LayoutManager;
import java.util.LinkedHashMap;
import java.util.logging.Logger;
import javax.swing.JLabel;
import javax.swing.JPanel;
import lu.tudor.santec.i18n.Translatrix;

public class KKQuadSettings
extends EEpromFirmwareSettings {
    Logger logger = KKMulticopterFlashTool.getLogger();
    private EEpromBooleanItem rollGyro;
    private EEpromBooleanItem nickGyro;
    private EEpromBooleanItem yawGyro;
    private EEpromBooleanItem potDirection;

    public KKQuadSettings(KKMulticopterFlashTool parent) {
        super(parent);
    }

    @Override
    public String toString() {
        return "KapteinKuk Quadrocopter \u22644.7";
    }

    @Override
    protected JPanel addEEpromDataItems() {
        this.readEEprom(this);
        JPanel settingsPanel = new JPanel();
        LinkedHashMap<Short, String> dataMapping = new LinkedHashMap<Short, String>();
        dataMapping.put((short)127, "true");
        dataMapping.put((short)255, "false");
        this.wait4EEprom();
        CellConstraints cc = new CellConstraints();
        String panelColumns = "fill:pref:grow,3dlu,fill:pref:grow,3dlu,fill:pref:grow";
        String panelRows = "pref,3dlu,pref";
        FormLayout panelLayout = new FormLayout(panelColumns, panelRows);
        settingsPanel.setLayout((LayoutManager)panelLayout);
        if (this.eeprom != null) {
            this.rollGyro = new EEpromBooleanItem(this.eeprom, "Roll gyro", 0, 1, EEpromBooleanItem.BOOLEAN, dataMapping, "inverted");
            this.nickGyro = new EEpromBooleanItem(this.eeprom, "Nick gyro", 1, 1, EEpromBooleanItem.BOOLEAN, dataMapping, "inverted");
            this.yawGyro = new EEpromBooleanItem(this.eeprom, "Yaw gyro", 2, 1, EEpromBooleanItem.BOOLEAN, dataMapping, "inverted");
            this.potDirection = new EEpromBooleanItem(this.eeprom, "Pot direction", 3, 1, EEpromBooleanItem.BOOLEAN, dataMapping, "inverted");
            settingsPanel.add((Component)new EEpromItemPanel(this.rollGyro), cc.xy(1, 1));
            settingsPanel.add((Component)new EEpromItemPanel(this.nickGyro), cc.xy(3, 1));
            settingsPanel.add((Component)new EEpromItemPanel(this.yawGyro), cc.xy(5, 1));
            settingsPanel.add((Component)new EEpromItemPanel(this.potDirection), cc.xy(1, 3));
        } else {
            settingsPanel.add((Component)new JLabel(Translatrix._("EEPromSettingsPanel.failed2read")), cc.xyw(1, 1, 5));
        }
        return settingsPanel;
    }

    @Override
    public void flashSettings() {
        if (this.rollGyro != null && this.nickGyro != null && this.yawGyro != null) {
            this.logger.info("Write back settings to eeprom object.");
            this.eeprom = this.rollGyro.updateEEprom(this.eeprom);
            this.eeprom = this.nickGyro.updateEEprom(this.eeprom);
            this.eeprom = this.yawGyro.updateEEprom(this.eeprom);
            this.eeprom = this.potDirection.updateEEprom(this.eeprom);
            this.writeEEprom(this);
        }
    }
}

