/*
 * Decompiled with CFR 0.152.
 */
package de.lazyzero.kkMulticopterFlashTool.gui.widgets;

import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import de.lazyzero.kkMulticopterFlashTool.KKMulticopterFlashTool;
import de.lazyzero.kkMulticopterFlashTool.gui.widgets.GithubPanelListener;
import de.lazyzero.kkMulticopterFlashTool.utils.Zip;
import de.lazyzero.kkMulticopterFlashTool.utils.download.Download;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collections;
import java.util.Comparator;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import lu.tudor.santec.i18n.Translatrix;
import org.apache.commons.io.FileExistsException;
import org.kohsuke.github.GHRepository;
import org.kohsuke.github.GHTag;
import org.kohsuke.github.GitHub;
import org.kohsuke.github.PagedIterable;

public class GithubPanel
extends JPanel
implements ActionListener {
    private static final long serialVersionUID = 1L;
    public static final int TARGET_CHANGED = 9999;
    private String repositoryName;
    private GitHub github;
    private GHRepository repository;
    private PagedIterable<GHTag> tags;
    private Vector<String> versions = new Vector();
    private Vector<String> targets = new Vector();
    private JComboBox<String> versionsCombobox;
    private JComboBox<String> targetsCombobox;
    private JButton downloadVersion;
    private Vector<GithubPanelListener> githubPanelListeners = new Vector();

    public GithubPanel(String repositoryName) {
        this.repositoryName = repositoryName;
        try {
            this.github = GitHub.connectAnonymously();
            this.repository = this.github.getRepository(this.repositoryName);
            this.loadVersions();
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
        this.initGUI();
    }

    private void loadVersions() throws IOException {
        this.versions.removeAllElements();
        this.versions.add(this.repository.getMasterBranch());
        this.tags = this.repository.listTags();
        for (GHTag tag : this.tags) {
            System.out.println(String.valueOf(tag.getName()) + "/" + tag.getOwner() + "/" + tag.getCommit().getSHA1());
            System.out.println(String.valueOf(this.repository.getUrl()) + "/archive/" + tag.getName() + ".zip");
            this.versions.add(tag.getName());
        }
    }

    private void initGUI() {
        CellConstraints cc = new CellConstraints();
        String panelColumns = "pref,3dlu,fill:pref:grow, 3dlu,pref";
        String panelRows = "pref,3dlu,pref,3dlu,pref";
        FormLayout panelLayout = new FormLayout(panelColumns, panelRows);
        this.setLayout((LayoutManager)panelLayout);
        JLabel repositoryNameLabel = new JLabel(String.valueOf(Translatrix._("github.repository.intro")) + " " + this.repositoryName);
        JLabel versionLabel = new JLabel(Translatrix._("github.selectversion"));
        this.versionsCombobox = new JComboBox<String>(this.versions);
        this.downloadVersion = new JButton(Translatrix._("downloads.download"));
        this.downloadVersion.addActionListener(this);
        this.targetsCombobox = new JComboBox<String>(this.targets);
        this.targetsCombobox.addActionListener(this);
        this.add((Component)repositoryNameLabel, cc.xyw(1, 1, 5));
        this.add((Component)versionLabel, cc.xy(1, 3));
        this.add(this.versionsCombobox, cc.xy(3, 3));
        this.add((Component)this.downloadVersion, cc.xy(5, 3));
        this.add(this.targetsCombobox, cc.xy(3, 5));
    }

    private void downloadArchive(String version) throws MalformedURLException, FileExistsException {
        Download dl;
        URL zipURL = new URL(String.valueOf(this.repository.getUrl()) + "/archive/" + version + ".zip");
        int counter = 0;
        do {
            dl = new Download(zipURL, version);
            while (dl.getStatus() == 0) {
                this.notifyGithubPanelListener(0);
                System.out.println("downloading :" + dl.getProgress());
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        } while (dl.getStatus() == 4 && ++counter < 3);
        if (dl.getStatus() == 2) {
            String tmpFolder = KKMulticopterFlashTool.getTempFolder();
            File zipFile = new File(tmpFolder, String.valueOf(version) + ".zip");
            File toFolder = new File(tmpFolder, "github");
            Zip.unzip2folder(zipFile, toFolder);
            this.updateTargets();
            this.notifyGithubPanelListener(2);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource().equals(this.downloadVersion)) {
            System.out.println("download: " + (String)this.versionsCombobox.getSelectedItem());
            try {
                this.downloadArchive((String)this.versionsCombobox.getSelectedItem());
            }
            catch (FileExistsException e1) {
                e1.printStackTrace();
            }
            catch (MalformedURLException e1) {
                e1.printStackTrace();
            }
        } else if (e.getSource().equals(this.targetsCombobox)) {
            this.notifyGithubPanelListener(9999);
        }
    }

    private void updateTargets() {
        File f = new File(this.getPath());
        String[] fileList = f.list(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.toLowerCase().endsWith(".inc");
            }
        });
        this.targets.removeAllElements();
        String[] stringArray = fileList;
        int n = fileList.length;
        int n2 = 0;
        while (n2 < n) {
            String name = stringArray[n2];
            if (!name.startsWith("boot")) {
                this.targets.add(name.split(".inc")[0]);
            }
            ++n2;
        }
        Collections.sort(this.targets, new Comparator<String>(){

            @Override
            public int compare(String s1, String s2) {
                return s1.compareTo(s2);
            }
        });
        this.targetsCombobox.setSelectedIndex(0);
    }

    private void notifyGithubPanelListener(int state) {
        System.out.println("notifyGithubPanelListener: " + state);
        for (GithubPanelListener githubPanelListener : this.githubPanelListeners) {
            githubPanelListener.githubPanelChanged(state);
        }
    }

    public void addGithubPanelListener(GithubPanelListener githubPanelListener) {
        this.githubPanelListeners.add(githubPanelListener);
    }

    public String getPath() {
        return String.valueOf(KKMulticopterFlashTool.getTempFolder()) + "github" + File.separatorChar + "tgy-" + (String)this.versionsCombobox.getSelectedItem();
    }

    public String getVersion() {
        return (String)this.versionsCombobox.getSelectedItem();
    }

    public String getTarget() {
        return (String)this.targetsCombobox.getSelectedItem();
    }
}

