/*
 * Decompiled with CFR 0.152.
 */
package de.lazyzero.kkMulticopterFlashTool.utils;

import de.lazyzero.kkMulticopterFlashTool.gui.SeriealListener;
import gnu.io.CommPort;
import gnu.io.CommPortIdentifier;
import gnu.io.SerialPort;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.LinkedHashMap;

public class SerialReader
extends Thread {
    private SerialPort serialPort;
    private InputStream in;
    private int baud = 9600;
    private String port;
    InputStreamReader isr;
    BufferedReader br;
    private final LinkedHashMap<String, String> data = new LinkedHashMap();
    String line;
    private SeriealListener listener;

    public SerialReader(int baud, String port, SeriealListener listener) {
        this.baud = baud;
        this.port = port;
        this.listener = listener;
        try {
            this.openPort();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void openPort() throws Exception {
        CommPortIdentifier portIdentifier = CommPortIdentifier.getPortIdentifier(this.port);
        CommPort commPort = portIdentifier.open("LightController", 2000);
        if (commPort instanceof SerialPort) {
            this.serialPort = (SerialPort)commPort;
            this.serialPort.setSerialPortParams(this.baud, 8, 1, 0);
            this.in = this.serialPort.getInputStream();
            this.isr = new InputStreamReader(this.in);
            this.br = new BufferedReader(this.isr);
        }
    }

    @Override
    public void run() {
        try {
            while ((this.line = this.br.readLine()) != null && !this.isInterrupted()) {
                String[] values = this.line.trim().split("=");
                if (values.length <= 1 || values[0].length() <= 0) continue;
                this.data.put(values[0], values[1]);
                this.listener.dataReceived(this.data);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public LinkedHashMap<String, String> getData() {
        return this.data;
    }

    public void close() throws IOException {
        this.in.close();
        this.serialPort.removeEventListener();
        this.serialPort.close();
    }

    public static void main(String[] args) {
    }
}

