/*
 * Decompiled with CFR 0.152.
 */
package de.lazyzero.kkMulticopterFlashTool.utils.avra;

import de.lazyzero.kkMulticopterFlashTool.KKMulticopterFlashTool;
import de.lazyzero.kkMulticopterFlashTool.utils.avra.AvraCommandLine;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.util.Vector;
import lu.tudor.santec.i18n.Translatrix;

public class Avra {
    private KKMulticopterFlashTool parent;
    private AvraCommandLine commandLine;

    public Avra(KKMulticopterFlashTool parent, AvraCommandLine commandline) {
        this.parent = parent;
        this.commandLine = commandline;
    }

    public boolean compile() {
        boolean success = true;
        try {
            int exitValue = this.runCommand();
            if (exitValue != 0) {
                success = false;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            success = false;
        }
        return success;
    }

    public void clean() {
        try {
            this.commandLine.clean();
        }
        catch (IOException e) {
            this.parent.print(Translatrix._("compile.avra.unable2delete"));
            e.printStackTrace();
        }
    }

    private int runCommand() throws Exception {
        this.parent.println("working dir: " + this.commandLine.getWorkingDir().getAbsolutePath());
        Vector<String> cmd = this.commandLine.getCommandLine();
        for (String s : cmd) {
            this.parent.print(String.valueOf(s) + " ");
        }
        this.parent.println("");
        String[] cmdArray = new String[cmd.size()];
        cmd.toArray(cmdArray);
        final Process p = Runtime.getRuntime().exec(cmdArray, null, this.commandLine.getWorkingDir());
        new Thread(){

            @Override
            public void run() {
                BufferedInputStream bis = new BufferedInputStream(p.getErrorStream());
                try {
                    int line;
                    while ((line = bis.read()) != -1) {
                        Avra.this.parent.print(String.valueOf((char)line));
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }.start();
        new Thread(){

            @Override
            public void run() {
                BufferedInputStream bis = new BufferedInputStream(p.getInputStream());
                try {
                    int line;
                    while ((line = bis.read()) != -1) {
                        Avra.this.parent.print(String.valueOf((char)line));
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }.start();
        p.waitFor();
        return p.exitValue();
    }

    public File getHexFile() {
        try {
            return this.commandLine.getHexFile();
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }
}

