/*
 * Decompiled with CFR 0.152.
 */
package org.concord.swing;

import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.util.prefs.Preferences;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import org.concord.swing.CCFilenameFilter;

public class CCFileDialog
extends FileDialog {
    public static final String PREFERENCE_DOMAIN = "org/concord/swing/CCFileDialog";
    public static final String DEFAULT_NAME = "org.concord.swing.CCFileDialog";
    public static final int FILES_ONLY = 1;
    public static final int FILES_AND_DIRECTORIES = 2;
    public static final int DIRECTORIES_ONLY = 3;
    private String preferencesKey;
    private boolean preferencesKeyWasSet = false;
    private int fileSelectionMode = 1;

    public CCFileDialog() {
        this(DEFAULT_NAME);
    }

    public CCFileDialog(String preferencesKey) {
        super(new Frame());
        this.setPreferencesKey(preferencesKey);
        this.checkingPreferences();
    }

    public CCFileDialog(Frame parent) {
        this(parent, null, DEFAULT_NAME);
    }

    public CCFileDialog(Frame parent, String title) {
        this(parent, title, DEFAULT_NAME);
    }

    public CCFileDialog(Frame parent, String title, String preferencesKey) {
        super(parent, title);
        this.setPreferencesKey(preferencesKey);
        this.settingPreferences();
    }

    public CCFileDialog(Frame parent, String title, int mode) {
        this(parent, title, mode, DEFAULT_NAME);
    }

    public CCFileDialog(Frame parent, String title, int mode, String preferencesKey) {
        super(parent, title, mode);
        this.setPreferencesKey(preferencesKey);
        this.settingPreferences();
    }

    @Override
    public void setDirectory(String dir) {
        super.setDirectory(dir);
        if (this.preferencesKeyWasSet) {
            this.settingPreferences();
        }
    }

    protected void setPreferencesKey(String preferencesKey) {
        this.preferencesKey = preferencesKey == null ? DEFAULT_NAME : preferencesKey;
        this.preferencesKeyWasSet = true;
    }

    protected void checkingPreferences() {
        File suggestedFile;
        Preferences userPreferences = Preferences.userRoot();
        Preferences dialogPreferences = null;
        try {
            dialogPreferences = userPreferences.node(PREFERENCE_DOMAIN);
        }
        catch (Throwable t) {
            dialogPreferences = null;
        }
        if (dialogPreferences == null) {
            return;
        }
        String suggestedPath = dialogPreferences.get(this.preferencesKey, null);
        if (suggestedPath == null) {
            try {
                suggestedPath = new File(this.getDirectory()).getCanonicalPath();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            if (suggestedPath == null) {
                suggestedPath = System.getProperty("user.dir");
            }
        }
        if ((suggestedFile = new File(suggestedPath)) != null && suggestedFile.exists() && suggestedFile.isDirectory()) {
            try {
                super.setDirectory(suggestedFile.getCanonicalPath());
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    protected void settingPreferences() {
        if (this.preferencesKey == null) {
            this.preferencesKey = DEFAULT_NAME;
        }
        String dir = this.getDirectory();
        File currDirectory = null;
        if (dir == null) {
            this.checkingPreferences();
            dir = this.getDirectory();
        }
        if (dir != null) {
            currDirectory = new File(dir);
        }
        String canonicalPath = null;
        try {
            if (currDirectory != null) {
                canonicalPath = currDirectory.getCanonicalPath();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (canonicalPath == null) {
            canonicalPath = System.getProperty("user.dir");
        }
        Preferences userPreferences = Preferences.userRoot();
        Preferences dialogPreferences = null;
        try {
            dialogPreferences = userPreferences.node(PREFERENCE_DOMAIN);
        }
        catch (Throwable t) {
            dialogPreferences = null;
        }
        if (dialogPreferences == null) {
            return;
        }
        dialogPreferences.put(this.preferencesKey, canonicalPath);
    }

    public void setFileSelectionMode(int fileSelectionMode) {
        if (fileSelectionMode != 1 && fileSelectionMode != 2 && fileSelectionMode != 3) {
            throw new IllegalArgumentException("Must be either CCFileDialog.FILES_ONLY, CCFileDialog.FILES_AND_DIRECTORIES, or CCFileDialog.DIRECTORIES_ONLY");
        }
        this.fileSelectionMode = fileSelectionMode;
    }

    public int getFileSelectionMode() {
        return this.fileSelectionMode;
    }

    @Override
    public void show() {
        if (this.fileSelectionMode == 3) {
            String message = "Since you are supposed to open a folder,\n all the acceptable files in the same folder\n will be selected.";
            JOptionPane.showMessageDialog(null, message, "FYI", 1);
        }
        super.show();
    }

    @Override
    public String getFile() {
        if (this.fileSelectionMode == 3) {
            return super.getDirectory();
        }
        return super.getFile();
    }

    public static void main(String[] args) {
        JFrame frame = new JFrame("CCFileDialog Test");
        JButton openButton = new JButton("Open");
        openButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CCFileDialog fileDialog = new CCFileDialog();
                CCFilenameFilter filenameFilter = new CCFilenameFilter();
                filenameFilter.setAcceptableExtension("jnlp");
                fileDialog.setFilenameFilter(filenameFilter);
                fileDialog.setFileSelectionMode(3);
                fileDialog.show();
                System.out.println("dir: " + fileDialog.getFile());
                String dir = fileDialog.getFile();
                File fd = new File(dir);
                File[] fs = fd.listFiles();
                int i = 0;
                while (i < fs.length) {
                    String filename = fs[i].getName();
                    if (filename.lastIndexOf(".") == -1) {
                        return;
                    }
                    String ext = filename.substring(filename.lastIndexOf(".") + 1, filename.length());
                    if (ext.equalsIgnoreCase(filenameFilter.getAcceptableExtension())) {
                        System.out.println(fs[i].getName());
                    }
                    ++i;
                }
            }
        });
        frame.getContentPane().add(openButton);
        frame.pack();
        frame.show();
        frame.setDefaultCloseOperation(3);
    }
}

