/*
 * Decompiled with CFR 0.152.
 */
package org.concord.swing;

import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.ByteArrayOutputStream;
import java.io.PrintWriter;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

public class ErrorDialog
extends JDialog
implements ActionListener {
    protected JTextArea messageArea;
    protected JTextArea exceptionText;
    protected JTextArea expTraceArea;
    protected JScrollPane expTraceScroll;
    protected JPanel buttonPanel;
    protected JPanel messagePanel;
    protected JButton okButton;
    protected JButton detailsButton;
    protected GridBagLayout gridbag;
    protected GridBagConstraints c;
    protected Throwable detailException = null;

    public static void showError(Frame frame, String message, Throwable t) {
        ErrorDialog eDialog = new ErrorDialog(frame, message, t, false);
        eDialog.show();
    }

    public ErrorDialog(Frame frame, String message, boolean modal) {
        this(frame, message, null, modal);
    }

    public ErrorDialog(Frame frame, String message, Throwable e, boolean modal) {
        super(frame, modal);
        this.detailException = e;
        this.initialize(message, e);
    }

    public ErrorDialog(Frame frame, boolean modal) {
        super(frame, modal);
    }

    protected void initialize(String message, Throwable e) {
        this.messageArea = new JTextArea(message);
        this.messageArea.setEditable(false);
        this.messageArea.setLineWrap(true);
        this.messageArea.setWrapStyleWord(true);
        this.messageArea.setOpaque(false);
        this.okButton = new JButton("Ok");
        this.buttonPanel = new JPanel();
        this.buttonPanel.add(this.okButton);
        this.gridbag = new GridBagLayout();
        this.c = new GridBagConstraints();
        this.messagePanel = new JPanel(this.gridbag);
        this.c.gridwidth = 0;
        this.c.weighty = 0.5;
        this.c.weightx = 1.0;
        this.c.fill = 2;
        this.c.insets = new Insets(3, 3, 3, 3);
        this.gridbag.setConstraints(this.messageArea, this.c);
        this.messagePanel.add(this.messageArea);
        if (e != null) {
            this.exceptionText = new JTextArea(e.getMessage());
            this.exceptionText.setEditable(false);
            this.exceptionText.setLineWrap(true);
            this.exceptionText.setWrapStyleWord(true);
            this.exceptionText.setOpaque(false);
            this.c.gridwidth = -1;
            this.c.weighty = 1.0;
            this.gridbag.setConstraints(this.exceptionText, this.c);
            this.messagePanel.add(this.exceptionText);
            this.detailsButton = new JButton("Details");
            this.detailsButton.addActionListener(this);
            this.c.gridwidth = 0;
            this.c.fill = 0;
            this.gridbag.setConstraints(this.detailsButton, this.c);
            this.messagePanel.add(this.detailsButton);
        }
        this.getContentPane().add((Component)this.messagePanel, "Center");
        this.getContentPane().add((Component)this.buttonPanel, "South");
        this.okButton.addActionListener(this);
        this.setBounds(100, 100, 300, 180);
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        if (event.getSource() == this.okButton) {
            this.setVisible(false);
        } else if (event.getSource() == this.detailsButton) {
            if (this.expTraceArea != null) {
                return;
            }
            ByteArrayOutputStream outStream = new ByteArrayOutputStream();
            PrintWriter pw = new PrintWriter(outStream);
            if (this.detailException != null) {
                this.detailException.printStackTrace(pw);
                pw.flush();
                this.expTraceArea = new JTextArea(outStream.toString());
            } else {
                this.expTraceArea = new JTextArea("Sorry no details availabe.");
            }
            this.expTraceArea.setEditable(false);
            this.expTraceArea.setLineWrap(true);
            this.expTraceArea.setWrapStyleWord(true);
            this.expTraceScroll = new JScrollPane(this.expTraceArea);
            this.c.gridwidth = 0;
            this.c.weighty = 1.5;
            this.c.weightx = 1.0;
            this.c.fill = 1;
            this.c.insets = new Insets(3, 3, 3, 3);
            this.gridbag.setConstraints(this.expTraceScroll, this.c);
            this.messagePanel.add(this.expTraceScroll);
            this.detailsButton.setEnabled(false);
            this.setBounds(this.getLocation().x, this.getLocation().y, 600, 400);
            this.validate();
        }
    }
}

