/*
 * Decompiled with CFR 0.152.
 */
package org.concord.swing;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Paint;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.geom.Area;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import java.awt.image.CropImageFilter;
import java.awt.image.FilteredImageSource;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.ListIterator;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;
import javax.swing.JToolTip;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import org.concord.swing.CoordinateTransformer;
import org.concord.swing.DoubleClickThread;
import org.concord.swing.Draggable;
import org.concord.swing.JAnnotationImageContainer;
import org.concord.swing.JAnnotationImageModel;
import org.concord.swing.JStyledToolTip;
import org.concord.swing.ParentComponentTransformer;
import org.concord.swing.StaticAnnotationToolTip;

public class JAnnotationImage
extends JPanel {
    static final String START_DRAG_PROPERTY = "startDragPoint";
    private int dragLimit = 20;
    Draggable currentDraggable;
    JAnnotationImageModel model;
    ParentComponentTransformer draggableComponentTransformer;
    ParentComponentTransformer draggableImageTransformer;
    AnnotatedImageMouseListener annotatedImageMouseListener = new AnnotatedImageMouseListener();
    AnnotatedImageMouseMotionListener annotatedImageMouseMotionListener = new AnnotatedImageMouseMotionListener();
    HashMap properties = new HashMap();
    boolean pointsModeStarted = false;
    Vector pointModeDots;
    Point prevPt = null;
    JAnnotationImageContainer owner;
    boolean htmlSupport = false;
    DoubleClickThread doubleClickthread = null;
    Timer pressedTimer;
    protected int defaultCursor = 1;
    static final String TEST_TOOL_TIP = "Annotation";
    BasicStroke bs = new BasicStroke(1.25f);

    public JAnnotationImage(JAnnotationImageContainer owner) {
        this.owner = owner;
        this.setLayout(null);
        this.setBorder(BorderFactory.createBevelBorder(0));
        this.setToolTipText("");
        this.addMouseListener(this.annotatedImageMouseListener);
        this.addMouseMotionListener(this.annotatedImageMouseMotionListener);
    }

    public JAnnotationImage(JAnnotationImageContainer owner, JAnnotationImageModel model) {
        this(owner);
        this.setModel(model);
    }

    public JAnnotationImage(JAnnotationImageContainer owner, String resString) {
        this(owner);
        this.model = new JAnnotationImageModel();
        this.setImageResourceString(resString);
    }

    public JAnnotationImage(JAnnotationImageContainer owner, BufferedImage bim) {
        this(owner);
        this.model = new JAnnotationImageModel(bim);
    }

    @Override
    public Dimension getPreferredSize() {
        BufferedImage bim;
        if (this.model != null && (bim = this.model.getMainImage()) != null) {
            return new Dimension(bim.getWidth(), bim.getHeight());
        }
        return new Dimension(20, 20);
    }

    public JAnnotationImageModel getModel() {
        return this.model;
    }

    public void setModel(JAnnotationImageModel model) {
        if (this.model == model) {
            return;
        }
        if (this.model != null) {
            this.model.clearAnnotationSpots();
        }
        this.model = model;
    }

    public void setEditMode(boolean editMode) {
        if (this.model != null) {
            this.model.setEditMode(editMode);
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                Window c = SwingUtilities.getWindowAncestor(JAnnotationImage.this);
                if (c != null) {
                    ((Component)c).setCursor(Cursor.getDefaultCursor());
                }
                JAnnotationImage.this.defaultCursor = 0;
            }
        });
        this.repaint();
    }

    public boolean isEditMode() {
        return this.model != null ? this.model.isEditMode() : false;
    }

    public int getChoosingMode() {
        return this.model != null ? this.model.getChoosingMode() : 0;
    }

    public synchronized void setChoosingMode(int choosingMode) {
        if (this.model != null) {
            this.model.setChoosingMode(choosingMode);
        }
    }

    public boolean getHtmlSupport() {
        return this.htmlSupport;
    }

    public void setHtmlSupport(boolean htmlSupport) {
        this.htmlSupport = htmlSupport;
    }

    public LinkedList getAnnotationSpots() {
        return this.model != null ? this.model.getAnnotationSpots() : null;
    }

    public boolean isAnnotationSpotPopupVisible() {
        return this.model != null ? this.model.isAnnotationSpotPopupVisible() : false;
    }

    @Override
    public JToolTip createToolTip() {
        return new JStyledToolTip();
    }

    @Override
    public String getToolTipText(MouseEvent event) {
        return this.model != null ? this.model.getToolTipText(event) : null;
    }

    public void deleteSelectedSpot() {
        if (this.model != null) {
            this.model.deleteSelectedSpot();
        }
        this.repaint();
    }

    public void clearAnnotationSpots() {
        if (this.model != null) {
            this.model.clearAnnotationSpots();
        }
        this.repaint();
    }

    public void setToolTipMode(boolean toolTipMode) {
        if (this.model != null) {
            this.model.setToolTipMode(toolTipMode);
        }
    }

    public boolean isToolTipMode() {
        if (this.model != null) {
            return this.model.isToolTipMode();
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuffer sb = new StringBuffer();
        String eol = "\n";
        sb.append("<class>" + this.getClass().getName() + "</class>" + eol);
        return sb.toString();
    }

    public JAnnotationImageModel.AnnotationSpot getSelectedAnnotationSpot() {
        return this.model != null ? this.model.getSelectedAnnotationSpot() : null;
    }

    public void dispose() {
        this.removeMouseListener(this.annotatedImageMouseListener);
        this.removeMouseMotionListener(this.annotatedImageMouseMotionListener);
        if (this.model != null) {
            this.model.dispose();
        }
    }

    protected void setImageResourceString(String imageResourceString) {
        if (this.model != null) {
            this.model.setImageResourceString(imageResourceString);
        }
        this.repaint();
    }

    protected String getImageResourceString() {
        return this.model != null ? this.model.getImageResourceString() : null;
    }

    ParentComponentTransformer getDraggableComponentTransformer() {
        return this.draggableComponentTransformer;
    }

    void setDraggableComponentTransformer(ParentComponentTransformer draggableComponentTransformer) {
        this.draggableComponentTransformer = draggableComponentTransformer;
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        this.internalPaintComponent(g);
    }

    protected void internalPaintComponent(Graphics g) {
        if (this.model == null) {
            return;
        }
        BufferedImage bim = this.isEditMode() ? this.model.getMainEditImage() : this.model.getMainImage();
        BufferedImage backgroundImage = this.model.getBackgroundImageImage();
        if (bim == null || backgroundImage == null) {
            return;
        }
        Graphics2D g2d = (Graphics2D)g;
        Graphics2D gi2d = backgroundImage.createGraphics();
        this.setImageClip(gi2d);
        gi2d.drawImage(bim, null, 0, 0);
        this.drawAnnotationSpots(gi2d);
        gi2d.dispose();
        g2d.drawImage(backgroundImage, null, 0, 0);
    }

    protected void setImageClip(Graphics g) {
        g.setClip(this.getImageClip());
    }

    protected Shape getImageClip() {
        Area toolTipArea;
        Insets insets = this.getInsets();
        if (insets == null) {
            insets = new Insets(0, 0, 0, 0);
        }
        Area clipTobe = new Area(new Rectangle(insets.left, insets.top, this.getSize().width - insets.left - insets.right, this.getSize().height - insets.top - insets.bottom));
        Area area = toolTipArea = this.model != null ? this.model.getToolTipAreaForClip(this) : null;
        if (toolTipArea != null) {
            clipTobe.subtract(toolTipArea);
        }
        return clipTobe;
    }

    protected void drawAnnotationSpots(Graphics2D g2d) {
        if (this.model == null) {
            return;
        }
        LinkedList annotationSpots = this.model.getAnnotationSpots();
        if (annotationSpots != null) {
            ListIterator it = annotationSpots.listIterator();
            while (it.hasNext()) {
                JAnnotationImageModel.AnnotationSpot as = (JAnnotationImageModel.AnnotationSpot)it.next();
                this.drawAnnotationSpot(g2d, as);
            }
        }
        if (this.pointsModeStarted && this.pointModeDots != null && this.pointModeDots.size() > 0) {
            Graphics2D gcopy = (Graphics2D)g2d.create();
            gcopy.setColor(Color.gray);
            gcopy.setStroke(this.bs);
            int i = 0;
            while (i < this.pointModeDots.size()) {
                Point pt = (Point)this.pointModeDots.elementAt(i);
                if (i > 0) {
                    Point ppt = (Point)this.pointModeDots.elementAt(i - 1);
                    gcopy.drawLine(ppt.x, ppt.y, pt.x, pt.y);
                }
                gcopy.fillRect(pt.x - 2, pt.y - 2, 5, 5);
                ++i;
            }
            gcopy.dispose();
        }
    }

    protected void drawAnnotationSpot(Graphics2D g2d, JAnnotationImageModel.AnnotationSpot as) {
        if (as == null || this.model == null || g2d == null) {
            return;
        }
        BufferedImage bim = this.model.getMainImage();
        if (bim == null) {
            return;
        }
        Rectangle r = as.getBounds();
        int cropW = r.width;
        int cropH = r.height;
        Object oldHint = g2d.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        if (cropW > 0 && cropH > 0) {
            CropImageFilter cif = new CropImageFilter(r.x, r.y, cropW, cropH);
            FilteredImageSource producer = new FilteredImageSource(bim.getSource(), cif);
            Shape oldClip = g2d.getClip();
            if (as.getSpot() != null) {
                g2d.setClip(as.getSpot());
            }
            g2d.drawImage(this.createImage(producer), r.x, r.y, null);
            g2d.setClip(oldClip);
            Stroke oldStroke = g2d.getStroke();
            g2d.setStroke(this.bs);
            Paint oldPaint = g2d.getPaint();
            if (as.getSpotColor() != null) {
                g2d.setPaint(as.getSpotColor());
            } else {
                g2d.setPaint(Color.gray);
            }
            g2d.draw(as.getSpot());
            if (oldPaint != null) {
                g2d.setPaint(oldPaint);
            }
            g2d.setStroke(oldStroke);
            if (this.isEditMode() && this.getSelectedAnnotationSpot() == as) {
                g2d.setColor(Color.red);
                g2d.drawRect(r.x, r.y, r.width, r.height);
            }
        }
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, oldHint);
    }

    protected boolean handleDoubleClick(MouseEvent e) {
        if (e.getClickCount() == 2) {
            if (!this.pointsModeStarted) {
                JAnnotationImageModel.AnnotationSpot selectedSpot = this.getSelectedAnnotationSpot();
                if (selectedSpot == null || selectedSpot.isEmpty()) {
                    return false;
                }
                selectedSpot.setupPopupMenu();
                return true;
            }
            this.pointsModeStarted = false;
            this.getNewAnnotationSpot(e.getPoint());
            if (this.owner != null) {
                this.owner.repaint();
            }
            return true;
        }
        return false;
    }

    public Draggable getStaticAnnotationSpotDraggable(JAnnotationImageModel.AnnotationSpot as) {
        if (as == null || as.isToolTipMode() || as.getAnnotationToolTip() == null) {
            return null;
        }
        JLayeredPaneDraggable draggable = new JLayeredPaneDraggable(as, as.getAnnotationToolTip());
        return draggable;
    }

    protected JAnnotationImageModel.AnnotationSpot getNewAnnotationSpot(Point pt) {
        JAnnotationImageModel.AnnotationSpot newAnnotationSpot = null;
        if (pt == null) {
            return newAnnotationSpot;
        }
        int px = (int)Math.round(pt.getX());
        int py = (int)Math.round(pt.getY());
        switch (this.model.getChoosingMode()) {
            case 3: {
                if (this.pointModeDots == null || this.pointModeDots.size() < 3) {
                    return null;
                }
                int[] xs = new int[this.pointModeDots.size() + 1];
                int[] ys = new int[this.pointModeDots.size() + 1];
                int i = 0;
                while (i < this.pointModeDots.size()) {
                    Point dpt = (Point)this.pointModeDots.elementAt(i);
                    xs[i] = dpt.x;
                    ys[i] = dpt.y;
                    ++i;
                }
                xs[xs.length - 1] = xs[0];
                ys[ys.length - 1] = ys[0];
                newAnnotationSpot = new JAnnotationImageModel.AnnotationSpot(new Polygon(xs, ys, xs.length));
                break;
            }
            case 2: {
                newAnnotationSpot = new JAnnotationImageModel.AnnotationSpot(new Polygon(new int[]{px}, new int[]{py}, 1));
                break;
            }
            case 1: {
                newAnnotationSpot = new JAnnotationImageModel.AnnotationSpot(new Ellipse2D.Double(px, py, 0.0, 0.0));
                break;
            }
            default: {
                newAnnotationSpot = new JAnnotationImageModel.AnnotationSpot(new Rectangle(px, py, 0, 0));
            }
        }
        this.model.setSelectedAnnotationSpot(newAnnotationSpot);
        newAnnotationSpot.setChoosingMode(this.model.getChoosingMode());
        newAnnotationSpot.setEnclosedRectangle(new Rectangle(this.dragLimit, this.dragLimit, this.getSize().width - 2 * this.dragLimit, this.getSize().height - 2 * this.dragLimit));
        Point aToolLocation = this.draggableComponentTransformer != null ? this.draggableComponentTransformer.transform(pt) : pt;
        newAnnotationSpot.setAnnotationToolTipLocation(JAnnotationImage.createPointFromPoint2D(aToolLocation));
        newAnnotationSpot.setAnnotation(TEST_TOOL_TIP);
        newAnnotationSpot.setAnnotationImage(this);
        this.model.addAnnotationSpot(newAnnotationSpot, true);
        JLayeredPane container = this.owner.layeredPane;
        if (container instanceof JLayeredPane) {
            newAnnotationSpot.createAnnotationToolTip();
            int layerIndex = JLayeredPane.DRAG_LAYER;
            JComponent jc = newAnnotationSpot.getAnnotationToolTip();
            if (jc != null) {
                container.add((Component)jc, new Integer(layerIndex + newAnnotationSpot.getIndex()));
                jc.addMouseListener(this.annotatedImageMouseListener);
                jc.addMouseMotionListener(this.annotatedImageMouseMotionListener);
                newAnnotationSpot.checkAnnotationToolTipPosition();
            }
        }
        return newAnnotationSpot;
    }

    protected void checkAnnotationToolTips() {
        LinkedList annotationSpots;
        if (this.model == null) {
            return;
        }
        Container container = this.getParent();
        if (container instanceof JLayeredPane && (annotationSpots = this.model.getAnnotationSpots()) != null) {
            int layerIndex = JLayeredPane.DRAG_LAYER;
            ListIterator it = annotationSpots.listIterator();
            while (it.hasNext()) {
                JAnnotationImageModel.AnnotationSpot as = (JAnnotationImageModel.AnnotationSpot)it.next();
                JComponent jc = as.getAnnotationToolTip();
                if (jc == null || container.isAncestorOf(jc)) continue;
                as.checkAnnotationToolTip();
                ((JLayeredPane)container).add((Component)jc, new Integer(layerIndex + as.getIndex()));
                jc.removeMouseListener(this.annotatedImageMouseListener);
                jc.removeMouseMotionListener(this.annotatedImageMouseMotionListener);
                jc.addMouseListener(this.annotatedImageMouseListener);
                jc.addMouseMotionListener(this.annotatedImageMouseMotionListener);
            }
        }
    }

    protected void startPressedTimer(Point pt) {
        this.disposePressedTimer();
        Point startPoint = JAnnotationImage.createPointFromPoint2D(pt);
        this.pressedTimer = new Timer(1000, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JAnnotationImage.this.disposePressedTimer();
                JAnnotationImage.this.currentDraggable = new JLayeredPaneDraggable(JAnnotationImage.this);
                JAnnotationImage.this.currentDraggable.startDrag(JAnnotationImage.this.draggableImageTransformer, (Point)JAnnotationImage.this.properties.get(JAnnotationImage.START_DRAG_PROPERTY));
            }
        });
        this.pressedTimer.start();
    }

    protected void disposePressedTimer() {
        if (this.pressedTimer != null) {
            if (this.pressedTimer.isRunning()) {
                this.pressedTimer.stop();
            }
            this.pressedTimer = null;
        }
    }

    protected void adjustCursor(Point pt) {
        int cursorSpotRegion;
        if (this.model == null) {
            return;
        }
        Window w = SwingUtilities.getWindowAncestor(this);
        if (!(w instanceof Frame)) {
            return;
        }
        final Frame frame = (Frame)w;
        final int runnableCursorSpotRegion = cursorSpotRegion = this.model.getCursorSpotRegionForPoint(pt);
        if (cursorSpotRegion == 9 && this.defaultCursor != cursorSpotRegion) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    frame.setCursor(Cursor.getPredefinedCursor(JAnnotationImage.this.isEditMode() ? 12 : 1));
                    JAnnotationImage.this.defaultCursor = runnableCursorSpotRegion;
                }
            });
        }
        if ((cursorSpotRegion == 0 || cursorSpotRegion == 10) && this.defaultCursor != cursorSpotRegion) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    frame.setCursor(Cursor.getDefaultCursor());
                    JAnnotationImage.this.defaultCursor = runnableCursorSpotRegion;
                }
            });
        }
        if (cursorSpotRegion >= 1 && cursorSpotRegion <= 8 && this.defaultCursor != cursorSpotRegion) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    int cursorType = 12;
                    switch (runnableCursorSpotRegion) {
                        case 1: {
                            cursorType = 6;
                            break;
                        }
                        case 2: {
                            cursorType = 7;
                            break;
                        }
                        case 3: {
                            cursorType = 4;
                            break;
                        }
                        case 4: {
                            cursorType = 5;
                            break;
                        }
                        case 5: {
                            cursorType = 10;
                            break;
                        }
                        case 6: {
                            cursorType = 11;
                            break;
                        }
                        case 7: {
                            cursorType = 8;
                            break;
                        }
                        case 8: {
                            cursorType = 9;
                        }
                    }
                    frame.setCursor(Cursor.getPredefinedCursor(cursorType));
                    JAnnotationImage.this.defaultCursor = runnableCursorSpotRegion;
                }
            });
        }
    }

    static Point createPointFromPoint2D(Point2D p2d) {
        if (p2d == null) {
            return null;
        }
        return new Point((int)Math.round(p2d.getX()), (int)Math.round(p2d.getY()));
    }

    class AnnotatedImageMouseListener
    extends MouseAdapter {
        AnnotatedImageMouseListener() {
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public void mousePressed(MouseEvent e) {
            try {
                JAnnotationImage.this.owner.requestFocusInWindow();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            if (JAnnotationImage.this.model == null || !JAnnotationImage.this.isEditMode() || JAnnotationImage.this.isAnnotationSpotPopupVisible()) {
                return;
            }
            int modifiers = e.getModifiers();
            boolean wasShift = (modifiers & 1) != 0;
            JAnnotationImageModel.AnnotationSpot currentAnnotationSpot = null;
            Component source = e.getComponent();
            if (JAnnotationImage.this.draggableComponentTransformer == null) {
                JAnnotationImage.this.draggableComponentTransformer = new ParentComponentTransformer();
                JAnnotationImage.this.draggableComponentTransformer.setDestinationComponent(JAnnotationImage.this.owner);
            }
            if (JAnnotationImage.this.draggableImageTransformer == null) {
                JAnnotationImage.this.draggableImageTransformer = new ParentComponentTransformer(JAnnotationImage.this.owner.layeredPane, JAnnotationImage.this);
            }
            JAnnotationImage.this.properties.put(JAnnotationImage.START_DRAG_PROPERTY, e.getPoint());
            if (!wasShift) {
                if (JAnnotationImage.this.getChoosingMode() == 3 && source instanceof JAnnotationImage) {
                    if (JAnnotationImage.this.pointsModeStarted) return;
                    if (JAnnotationImage.this.pointModeDots == null) {
                        JAnnotationImage.this.pointModeDots = new Vector();
                    } else {
                        JAnnotationImage.this.pointModeDots.removeAllElements();
                    }
                    JAnnotationImage.this.pointsModeStarted = true;
                } else {
                    JAnnotationImage.this.pointsModeStarted = false;
                    if (JAnnotationImage.this.pointModeDots != null) {
                        JAnnotationImage.this.pointModeDots.removeAllElements();
                    }
                    JAnnotationImage.this.prevPt = null;
                }
                JAnnotationImage.this.model.setSelectedAnnotationSpot(null);
                JAnnotationImage.this.draggableComponentTransformer.setSourceComponent(source);
                if (source instanceof JAnnotationImage) {
                    JAnnotationImage.this.currentDraggable = null;
                } else {
                    if (!(source instanceof StaticAnnotationToolTip)) return;
                    JAnnotationImageModel.AnnotationSpot spot = ((StaticAnnotationToolTip)source).getOwner();
                    if (spot == null) {
                        return;
                    }
                    JAnnotationImage.this.currentDraggable = JAnnotationImage.this.getStaticAnnotationSpotDraggable(spot);
                    if (JAnnotationImage.this.currentDraggable == null) {
                        return;
                    }
                }
            }
            if (JAnnotationImage.this.currentDraggable == null || wasShift) {
                if (!wasShift) {
                    currentAnnotationSpot = JAnnotationImage.this.model.getAnnotationSpotForPoint(e.getPoint());
                    JAnnotationImage.this.model.setSelectedAnnotationSpot(currentAnnotationSpot);
                    if (currentAnnotationSpot != null) {
                        JAnnotationImage.this.currentDraggable = currentAnnotationSpot;
                    }
                } else {
                    JAnnotationImage.this.startPressedTimer(e.getPoint());
                    return;
                }
            }
            if (JAnnotationImage.this.currentDraggable == null) return;
            JAnnotationImage.this.pointsModeStarted = false;
            if (JAnnotationImage.this.pointModeDots != null) {
                JAnnotationImage.this.pointModeDots.removeAllElements();
            }
            JAnnotationImage.this.currentDraggable.startDrag(JAnnotationImage.this.draggableComponentTransformer, e.getPoint());
            JAnnotationImage.this.prevPt = null;
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            JAnnotationImage.this.prevPt = null;
            JAnnotationImage.this.properties.remove(JAnnotationImage.START_DRAG_PROPERTY);
            JAnnotationImage.this.disposePressedTimer();
            if (!JAnnotationImage.this.isEditMode() || JAnnotationImage.this.model == null) {
                return;
            }
            if (JAnnotationImage.this.pointsModeStarted) {
                JAnnotationImage.this.pointModeDots.add(e.getPoint());
            }
            if (JAnnotationImage.this.handleDoubleClick(e)) {
                return;
            }
            if (JAnnotationImage.this.currentDraggable != null) {
                JAnnotationImage.this.currentDraggable.endDrag(e.getPoint());
                JAnnotationImage.this.currentDraggable = null;
            }
            if (JAnnotationImage.this.owner != null) {
                JAnnotationImage.this.owner.repaint();
            }
        }
    }

    class AnnotatedImageMouseMotionListener
    extends MouseMotionAdapter {
        AnnotatedImageMouseMotionListener() {
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            if (JAnnotationImage.this.pointsModeStarted) {
                return;
            }
            if (JAnnotationImage.this.currentDraggable == null) {
                if (JAnnotationImage.this.pressedTimer != null) {
                    JAnnotationImage.this.disposePressedTimer();
                }
                Point startDragPoint = (Point)JAnnotationImage.this.properties.get(JAnnotationImage.START_DRAG_PROPERTY);
                JAnnotationImageModel.AnnotationSpot currentAnnotationSpot = JAnnotationImage.this.getNewAnnotationSpot(startDragPoint);
                JAnnotationImage.this.currentDraggable = currentAnnotationSpot;
                if (JAnnotationImage.this.currentDraggable != null) {
                    JAnnotationImage.this.currentDraggable.startDrag(null, JAnnotationImage.createPointFromPoint2D(startDragPoint));
                }
            }
            if (JAnnotationImage.this.currentDraggable != null) {
                JAnnotationImage.this.currentDraggable.doDrag(e.getPoint());
                Graphics gc = JAnnotationImage.this.getGraphics();
                if (gc == null) {
                    JAnnotationImage.this.repaint();
                } else {
                    gc.dispose();
                }
                if (JAnnotationImage.this.owner != null) {
                    JAnnotationImage.this.owner.repaint();
                }
            }
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            JAnnotationImage.this.adjustCursor(e.getPoint());
            if (JAnnotationImage.this.getChoosingMode() == 3 && e.getSource() instanceof JAnnotationImage && JAnnotationImage.this.pointsModeStarted && JAnnotationImage.this.pointModeDots != null && JAnnotationImage.this.pointModeDots.size() > 0) {
                Graphics2D gc = (Graphics2D)JAnnotationImage.this.getGraphics();
                Point dpt = (Point)JAnnotationImage.this.pointModeDots.elementAt(JAnnotationImage.this.pointModeDots.size() - 1);
                gc.setXORMode(Color.red);
                if (JAnnotationImage.this.prevPt != null) {
                    gc.drawLine(dpt.x, dpt.y, JAnnotationImage.this.prevPt.x, JAnnotationImage.this.prevPt.y);
                }
                JAnnotationImage.this.prevPt = e.getPoint();
                gc.drawLine(dpt.x, dpt.y, JAnnotationImage.this.prevPt.x, JAnnotationImage.this.prevPt.y);
                gc.dispose();
            }
        }
    }

    public static class JLayeredPaneDraggable
    implements Draggable {
        Point2D startDragPoint;
        Point2D startParentDragPoint;
        Point2D startComponentLocation;
        Component owner;
        JAnnotationImageModel.AnnotationSpot annotationSpot;
        CoordinateTransformer currentTransformer;

        JLayeredPaneDraggable(Component owner) {
            this(null, owner);
        }

        JLayeredPaneDraggable(JAnnotationImageModel.AnnotationSpot annotationSpot, Component owner) {
            this.owner = owner;
            this.annotationSpot = annotationSpot;
        }

        @Override
        public int startDrag(CoordinateTransformer transformer, Point pt) {
            if (this.owner == null) {
                return 0;
            }
            this.startComponentLocation = this.owner.getLocation();
            this.startParentDragPoint = transformer != null ? transformer.transform(pt) : pt;
            this.startDragPoint = pt;
            this.currentTransformer = transformer;
            return 0;
        }

        @Override
        public void doDrag(Point pt) {
            if (this.owner == null) {
                return;
            }
            Point currPoint = this.currentTransformer != null ? this.currentTransformer.transform(pt) : pt;
            int newx = (int)Math.round(this.startComponentLocation.getX() + (((Point2D)currPoint).getX() - this.startParentDragPoint.getX()));
            int newy = (int)Math.round(this.startComponentLocation.getY() + (((Point2D)currPoint).getY() - this.startParentDragPoint.getY()));
            if (newx < 0) {
                newx = 0;
            }
            if (newy < 0) {
                newy = 0;
            }
            if (newx + this.owner.getSize().width > this.owner.getParent().getSize().width) {
                newx = this.owner.getParent().getSize().width - this.owner.getSize().width;
            }
            if (newy + this.owner.getSize().height > this.owner.getParent().getSize().height) {
                newy = this.owner.getParent().getSize().height - this.owner.getSize().height;
            }
            final int newix = newx;
            final int newiy = newy;
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    owner.setLocation(newix, newiy);
                    if (owner.getParent() != null) {
                        owner.getParent().repaint();
                    }
                }
            });
        }

        @Override
        public void endDrag(Point pt) {
            if (this.annotationSpot == null || this.owner == null) {
                return;
            }
            this.annotationSpot.setAnnotationToolTipLocation(this.owner.getLocation());
        }

        @Override
        public void setDraggable(boolean draggable) {
        }

        @Override
        public boolean isDraggable() {
            return true;
        }
    }
}

