/*
 * Decompiled with CFR 0.152.
 */
package org.concord.swing;

import java.awt.Component;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.MouseMotionListener;
import org.concord.swing.EventRelay;
import org.concord.swing.Selectable;
import org.concord.swing.SelectableContainer;

public class SelectionManager
extends MouseMotionAdapter
implements MouseListener {
    protected int mouseX;
    protected int mouseY;
    protected boolean multiple = false;
    protected boolean dragged = false;
    protected boolean popup = false;
    protected SelectableContainer selectableContainer;
    protected Selectable selectedObject;
    protected Selectable activeObject;
    protected Component popupComponent;
    protected EventRelay eventRelay = new EventRelay();
    protected final String[] mouseNames = new String[]{"mouseEntered", "mouseExited", "mousePressed", "mouseReleased", "mouseClicked"};
    protected final String[] mouseMotionNames = new String[]{"mouseDragged", "mouseMoved"};

    public Selectable getSelectedObject() {
        return this.selectedObject;
    }

    public Selectable getActiveObject() {
        return this.activeObject;
    }

    public void setSelectableContainer(SelectableContainer container) {
        this.selectableContainer = container;
    }

    @Override
    public void mousePressed(MouseEvent event) {
        this.mouseX = event.getX();
        this.mouseY = event.getY();
        if (this.activeObject != null && this.activeObject.contains(this.mouseX, this.mouseY)) {
            this.eventRelay.relay("mousePressed", event);
        } else {
            this.multiple = event.isShiftDown();
            Selectable next = this.selectableContainer.findSelectable(event, this.mouseX, this.mouseY);
            if (next == null || next != this.selectedObject) {
                this.activeObject = null;
                this.eventRelay.reset();
            }
            this.selectedObject = next;
            if (this.selectedObject != null) {
                this.selectableContainer.select(this.selectedObject, this.multiple);
            } else {
                this.selectableContainer.deselect();
            }
            this.popup = event.isPopupTrigger();
        }
    }

    @Override
    public void mouseReleased(MouseEvent event) {
        if (this.activeObject != null && this.activeObject.contains(event.getX(), event.getY())) {
            this.eventRelay.relay("mouseReleased", event);
        } else {
            if ((this.popup || event.isPopupTrigger()) && this.popupComponent instanceof Component) {
                this.popupComponent.setVisible(true);
                this.popupComponent.setLocation(this.mouseX, this.mouseY);
            } else if (this.dragged) {
                this.selectableContainer.dragActionDone(this.selectedObject);
                this.dragged = false;
            } else if (this.multiple && this.selectedObject != null) {
                this.selectedObject.toggleSelected();
            }
            this.multiple = false;
        }
    }

    @Override
    public void mouseDragged(MouseEvent event) {
        if (this.activeObject != null && this.activeObject.contains(event.getX(), event.getY())) {
            this.eventRelay.relay("mouseDragged", event);
        } else {
            int x = event.getX();
            int y = event.getY();
            int deltaX = x - this.mouseX;
            int deltaY = y - this.mouseY;
            if (deltaX != 0 || deltaY != 0) {
                this.dragged = true;
            }
            if (this.dragged && this.selectedObject != null) {
                this.selectableContainer.dragAction(deltaX, deltaY, this.selectedObject);
            }
            this.mouseX = x;
            this.mouseY = y;
        }
    }

    public void setPopupComponent(Component popup) {
        this.popupComponent = popup;
    }

    @Override
    public void mouseClicked(MouseEvent event) {
        if (this.activeObject != null && this.activeObject.contains(event.getX(), event.getY())) {
            this.eventRelay.relay("mouseClicked", event);
        } else if (event.getClickCount() == 2 && this.selectedObject != null) {
            this.activeObject = this.selectedObject;
            Component component = this.activeObject.getComponent();
            if (component != null) {
                this.eventRelay.reset();
                this.eventRelay.addTarget(component, MouseListener.class, MouseEvent.class, this.mouseNames);
                this.eventRelay.addTarget(component, MouseMotionListener.class, MouseEvent.class, this.mouseMotionNames);
                this.selectableContainer.select(this.selectedObject, false);
            }
        }
    }

    @Override
    public void mouseMoved(MouseEvent event) {
        if (this.activeObject != null && this.activeObject.contains(event.getX(), event.getY())) {
            this.eventRelay.relay("mouseMoved", event);
        }
    }

    @Override
    public void mouseEntered(MouseEvent event) {
        if (this.activeObject != null && this.activeObject.contains(event.getX(), event.getY())) {
            this.eventRelay.relay("mouseEntered", event);
        }
    }

    @Override
    public void mouseExited(MouseEvent event) {
        if (this.activeObject != null && this.activeObject.contains(event.getX(), event.getY())) {
            this.eventRelay.relay("mouseExited", event);
        }
    }
}

