/*
 * Decompiled with CFR 0.152.
 */
package org.concord.swing;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.ListModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.concord.swing.ModifyValueDialog;
import org.concord.swing.event.VariableListener;

public class VariableDialog
extends JDialog
implements ActionListener,
ListSelectionListener {
    protected JList variableList = new JList();
    protected JTextArea variableComment = new JTextArea();
    protected JButton doneButton = new JButton("Done");
    protected JButton addButton = new JButton("Add");
    protected JButton modifyButton = new JButton("Modify");
    protected JButton removeButton = new JButton("Remove");
    protected JPanel controlPanel = new JPanel();
    protected JPanel listPanel = new JPanel();
    protected JScrollPane commentScroll = new JScrollPane(this.variableComment);
    protected JScrollPane listScroll = new JScrollPane(this.variableList);
    protected ModifyValueDialog modifyDialog;
    protected Properties prefixTable = new Properties();
    protected JPanel contentPane;
    protected String selectedItem;
    protected Map variables;
    protected boolean javaVariable = true;
    protected VariableErrorDialog errorDialog;
    protected final String COMMENT = ".comment";

    public VariableDialog(JFrame frame, String title, Map variables) {
        super(frame, title, false);
        this.modifyDialog = this.createModifyValueDialog(frame);
        this.errorDialog = new VariableErrorDialog(frame);
        this.setVariables(variables);
        this.initialize();
    }

    public VariableDialog(JFrame frame, String title) {
        this(frame, title, null);
    }

    public ModifyValueDialog createModifyValueDialog(JFrame frame) {
        return new ModifyValueDialog(frame, "Edit value");
    }

    public static boolean isVariable(Object object) {
        if (object instanceof String) {
            String value = (String)object;
            int n = value.length();
            if (n == 0) {
                return false;
            }
            if (!Character.isJavaIdentifierStart(value.charAt(0))) {
                return false;
            }
            int i = 1;
            while (i < n) {
                if (!Character.isJavaIdentifierPart(value.charAt(i))) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        return false;
    }

    public void initialize() {
        this.controlPanel.setLayout(new GridLayout(0, 1));
        this.controlPanel.add(this.doneButton);
        this.controlPanel.add(this.addButton);
        this.controlPanel.add(this.modifyButton);
        this.controlPanel.add(this.removeButton);
        this.listPanel.setLayout(new GridLayout(1, 0));
        this.listPanel.add(this.listScroll);
        this.listPanel.add(this.commentScroll);
        this.contentPane = (JPanel)this.getContentPane();
        this.contentPane.setLayout(new BorderLayout());
        this.contentPane.add((Component)this.listPanel, "Center");
        this.contentPane.add((Component)this.controlPanel, "East");
        this.doneButton.addActionListener(this);
        this.addButton.addActionListener(this);
        this.modifyButton.addActionListener(this);
        this.removeButton.addActionListener(this);
        this.removeButton.setEnabled(false);
        this.variableComment.setLineWrap(true);
        this.variableComment.setWrapStyleWord(true);
        this.variableList.addListSelectionListener(this);
        this.setLocation(200, 200);
        this.pack();
        this.setResizable(false);
    }

    public boolean isJavaVariable() {
        return this.javaVariable;
    }

    public void setJavaVariable(boolean value) {
        this.javaVariable = value;
    }

    public void setVariables(Map variables) {
        this.variables = variables;
    }

    protected Vector getVariableList(Map varTable) {
        Vector variableList = new Vector();
        Set keySet = varTable.keySet();
        for (Object key : keySet) {
            if (this.javaVariable && !VariableDialog.isVariable(key)) continue;
            variableList.add(key);
        }
        return variableList;
    }

    @Override
    public void show() {
        if (this.variables instanceof Map) {
            Vector list = this.getVariableList(this.variables);
            this.variableList.setListData(list);
            this.selectedItem = (String)this.variableList.getSelectedValue();
            if (this.selectedItem instanceof String && this.variables.containsKey(this.selectedItem)) {
                this.variableList.setSelectedValue(this.selectedItem, true);
                this.modifyButton.setEnabled(true);
            } else {
                this.modifyButton.setEnabled(false);
            }
            super.show();
        }
    }

    public boolean showSelectedVariable(String varName) {
        if (this.variables instanceof Map) {
            this.variableList.setListData(this.getVariableList(this.variables));
            ListModel listModel = this.variableList.getModel();
            int i = 0;
            while (i < listModel.getSize()) {
                Object listElement = listModel.getElementAt(i);
                if (varName.equals((String)listElement)) {
                    this.variableList.setSelectedValue(listElement, true);
                    this.modifyButton.setEnabled(true);
                    super.show();
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    public void addVariableListener(VariableListener listener) {
        this.modifyDialog.addVariableListener(listener);
    }

    public void removeVariableListener(VariableListener listener) {
        this.modifyDialog.removeVariableListener(listener);
    }

    public void addVariableValue(String variable, Object value) {
        if (this.variables instanceof Map) {
            boolean varExists = false;
            while (true) {
                this.modifyDialog.setModify(false);
                this.modifyDialog.setVariable(variable);
                this.modifyDialog.setValue(value);
                this.modifyDialog.show();
                variable = this.modifyDialog.getVariable();
                value = this.modifyDialog.getValue();
                varExists = this.variables.containsKey(variable);
                if (!(variable instanceof String) || !varExists) break;
                this.errorDialog.setBounds(this.getBounds());
                this.errorDialog.setErrorText("Variable (" + variable + ") already exists.\nChange the variable name or Cancel.");
            }
            if (variable instanceof String && variable.length() > 0) {
                this.variables.put(variable, this.modifyDialog.getValue());
                this.modifyButton.setEnabled(true);
                this.removeButton.setEnabled(true);
            }
            if (variable.length() == 0) {
                variable = null;
            }
            this.selectedItem = variable;
        }
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        if (this.variables instanceof Map) {
            JButton button;
            Object source = event.getSource();
            JButton jButton = button = source instanceof JButton ? (JButton)source : null;
            if (button == this.doneButton) {
                this.setVisible(false);
            } else if (button == this.addButton) {
                this.addVariableValue(this.modifyDialog.getVariable(), null);
            } else if (button == this.modifyButton) {
                boolean varExists = this.variables.containsKey(this.selectedItem);
                if (this.selectedItem instanceof String && varExists) {
                    String variable = this.selectedItem;
                    Object value = this.variables.get(variable);
                    this.modifyDialog.setVariable(variable);
                    this.modifyDialog.setValue(value);
                    this.modifyDialog.setModify(true);
                    this.modifyDialog.show();
                    variable = this.modifyDialog.getVariable();
                    if (variable instanceof String && variable.length() > 0) {
                        this.variables.put(variable, this.modifyDialog.getValue());
                    }
                    this.selectedItem = variable;
                }
            } else if (button == this.removeButton && this.selectedItem instanceof String) {
                this.variables.remove(this.selectedItem);
                this.selectedItem = null;
            }
            this.setSelected(this.selectedItem);
        }
    }

    public void setSelected(String item) {
        if (this.variables instanceof Map) {
            this.variableList.removeListSelectionListener(this);
            this.variableList.setListData(this.getVariableList(this.variables));
            if (this.selectedItem instanceof String && this.variables.containsKey(item)) {
                this.variableList.setSelectedValue(item, true);
            }
            this.variableList.addListSelectionListener(this);
        }
    }

    protected void updateVariableComment(String oldItem, String newItem) {
        String oldItemComment = String.valueOf(oldItem) + ".comment";
        String newItemComment = String.valueOf(newItem) + ".comment";
        String comment = this.variableComment.getText();
        String string = comment = comment == null ? "" : comment.trim();
        if (comment.length() > 0) {
            this.variables.put(oldItemComment, comment);
        } else {
            this.variables.remove(oldItemComment);
        }
        comment = (String)this.variables.get(newItemComment);
        this.variableComment.setText(comment == null ? "" : comment);
    }

    public void setSelectedItem(String item) {
        if (this.variables instanceof Map) {
            this.removeButton.setEnabled(item instanceof String);
            if (this.selectedItem instanceof String) {
                if (this.selectedItem == item) {
                    boolean varExists;
                    String comment = (String)this.variables.get(String.valueOf(item) + ".comment");
                    this.variableComment.setText(comment == null ? "" : comment);
                    this.modifyDialog.setVariable(item);
                    boolean bl = varExists = item instanceof String && this.variables.containsKey(item);
                    if (varExists) {
                        this.modifyDialog.setValue(this.variables.get(item));
                        this.modifyButton.setEnabled(true);
                    }
                } else {
                    this.updateVariableComment(this.selectedItem, item);
                }
            } else {
                this.modifyButton.setEnabled(false);
            }
            this.selectedItem = item;
        }
    }

    @Override
    public void valueChanged(ListSelectionEvent event) {
        Object object = event.getSource();
        if (object instanceof JList) {
            JList list = (JList)object;
            this.setSelectedItem((String)list.getSelectedValue());
        }
    }

    public class VariableErrorDialog
    extends JDialog
    implements ActionListener {
        protected JTextArea errorTextArea;
        protected JButton continueButton;
        protected JPanel buttonPanel;

        public VariableErrorDialog(JFrame owner) {
            super(owner, "Variable Error", true);
            this.errorTextArea = new JTextArea();
            this.continueButton = new JButton("Continue");
            this.buttonPanel = new JPanel();
            this.errorTextArea.setEditable(false);
            this.errorTextArea.setLineWrap(true);
            this.errorTextArea.setWrapStyleWord(true);
            this.errorTextArea.setBackground(this.buttonPanel.getBackground());
            this.getContentPane().setLayout(new BorderLayout());
            this.buttonPanel.add(this.continueButton);
            this.getContentPane().add((Component)this.buttonPanel, "South");
            this.getContentPane().add((Component)this.errorTextArea, "Center");
            this.continueButton.addActionListener(this);
            this.setSize(300, 150);
            this.setResizable(false);
        }

        public void setErrorText(String errorText) {
            this.errorTextArea.setText(errorText);
            this.show();
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            this.hide();
        }
    }
}

